/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoProcCommand
extends BaseJdmpviewCommand {
    public InfoProcCommand() {
        this.addCommand("info process", "", "displays threads, command line arguments, environment");
        this.addCommand("info proc", "", "shortened form of info process");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"info proc\" command does not take any parameters");
            return;
        }
        this.printAddressSpaceInfo();
    }

    private void printAddressSpaceInfo() {
        ImageAddressSpace ias = this.ctx.getAddressSpace();
        ImageProcess ip = ias.getCurrentProcess();
        if (ip == null) {
            this.out.print("\t(No process in this address space)\n");
        } else {
            this.printProcessInfo();
        }
        this.out.print("\n");
    }

    private void printProcessInfo() {
        this.out.print("\n");
        this.printProcessID();
        this.out.print("\n");
        this.printThreads();
        this.out.print("\n");
        this.printCommandLine();
        if (this.ctx.getRuntime() != null) {
            this.out.print("\n");
            this.printJITOptions();
        }
        this.out.print("\n");
        this.printEnvironmentVariables();
    }

    private void printProcessID() {
        this.out.print("\t Process ID:");
        this.out.print("\n\t  ");
        try {
            this.out.print(this.ctx.getProcess().getID());
        }
        catch (DataUnavailable e) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.print("\n");
    }

    private void printJITOptions() {
        try {
            if (this.ctx.getRuntime().isJITEnabled()) {
                this.out.println("\t JIT was enabled for this runtime");
                Properties props = this.ctx.getRuntime().getJITProperties();
                StringBuilder options = new StringBuilder("\t ");
                for (Object key : props.keySet()) {
                    options.append(" " + key + " " + props.get(key) + ",");
                }
                this.out.println(options.substring(0, options.length() - 1));
            } else {
                this.out.println("\t JIT was disabled for this runtime");
            }
        }
        catch (CorruptDataException e) {
            this.out.println("\t JIT options\n");
        }
        catch (DataUnavailable e) {
            this.out.println("\t JIT options not supported by this implementation of DTFJ");
        }
    }

    private void printThreads() {
        ImageProcess ip = this.ctx.getProcess();
        this.out.print("\t Native thread IDs:");
        this.out.print("\n\t  ");
        int lineLength = 10;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) {
                this.out.print("\n\t  <corrupt data>");
                continue;
            }
            ImageThread it = (ImageThread)next;
            try {
                String threadID = it.getID();
                if (threadID == null) continue;
                if (lineLength + threadID.length() > 80) {
                    this.out.print("\n\t  ");
                    lineLength = 10;
                }
                this.out.print(it.getID() + " ");
                lineLength += threadID.length() + 1;
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
        }
        this.out.print("\n");
    }

    private void printCommandLine() {
        ImageProcess ip = this.ctx.getProcess();
        this.out.print("\t Command line:\n\t  ");
        try {
            String commandLine = ip.getCommandLine();
            if (null == commandLine) {
                this.out.print("<null>");
            } else {
                this.out.print(commandLine);
            }
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        catch (DataUnavailable e) {
            this.out.print("Could not determine command line");
        }
        this.out.println();
        this.out.println();
        try {
            JavaVMInitArgs args = this.ctx.getRuntime().getJavaVMInitArgs();
            if (args != null) {
                this.out.print("\t Java VM init options: ");
                Iterator opts = args.getOptions();
                while (opts.hasNext()) {
                    this.out.println();
                    Object obj = opts.next();
                    if (!(obj instanceof JavaVMOption)) continue;
                    JavaVMOption opt = (JavaVMOption)obj;
                    this.out.print("\t  " + opt.getOptionString());
                    if (opt.getExtraInfo().getAddress() == 0L) continue;
                    this.out.print(" " + Utils.toHex(opt.getExtraInfo()));
                }
            } else {
                this.out.print(Exceptions.getDataUnavailableString());
            }
        }
        catch (Exception cde) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        this.out.print("\n");
    }

    private void printEnvironmentVariables() {
        Properties variables;
        ImageProcess ip = this.ctx.getProcess();
        this.out.print("\t Environment variables:");
        this.out.print("\n");
        try {
            variables = ip.getEnvironment();
        }
        catch (CorruptDataException e) {
            this.out.print("\t  " + Exceptions.getCorruptDataExceptionString() + "\n");
            return;
        }
        catch (DataUnavailable e) {
            this.out.print("\t  " + Exceptions.getDataUnavailableString() + "\n");
            return;
        }
        Enumeration<?> keys = variables.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.printVariableInfo(key, variables.getProperty(key));
        }
    }

    private void printVariableInfo(String key, String value) {
        this.out.print("\t  " + key + "=" + value + "\n");
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("displays process ID, threads, command line arguments and environment variables for the current process\n\nparameters: none\n\nprints the following information about the current process\n\n  - process ID for the process and thread IDs for all its threads\n  - the command line arguments and JVM init arguments it's using\n  - its environment variables\n\nnote: to view the shared libraries used by a process, use the \"info mod\" command\n");
    }
}

