/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29_00.types.I64;
import com.ibm.j9ddr.vm29_00.types.IDATA;
import com.ibm.j9ddr.vm29_00.types.IScalar;
import com.ibm.j9ddr.vm29_00.types.Scalar;
import com.ibm.j9ddr.vm29_00.types.U64;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import com.ibm.j9ddr.vm29_00.types.UScalar;

public class U32
extends UScalar {
    public static final int SIZEOF = 4;
    public static final long MASK = 0xFFFFFFFFL;
    public static final U32 MIN = new U32(0L);
    public static final U32 MAX = new U32(0xFFFFFFFFL);

    public U32(long value) {
        super(value & 0xFFFFFFFFL);
    }

    public U32(Scalar parameter) {
        super(parameter);
    }

    public U32 add(int number) {
        return new U32(this.data + (long)number);
    }

    public U32 add(UScalar parameter) {
        return this.add(new U32(parameter));
    }

    public U32 add(U32 parameter) {
        return new U32(this.data + parameter.data);
    }

    public U64 add(U64 parameter) {
        return new U64(this).add(parameter);
    }

    public boolean eq(U64 parameter) {
        return new U64(this).eq(parameter);
    }

    public UDATA add(UDATA parameter) {
        return new UDATA(this).add(parameter);
    }

    public boolean eq(UDATA parameter) {
        return new UDATA(this).eq(parameter);
    }

    public U32 add(IScalar parameter) {
        return this.add(new U32(parameter));
    }

    public boolean eq(IScalar parameter) {
        return this.eq(new U32(parameter));
    }

    public I64 add(I64 parameter) {
        return new I64(this).add(parameter);
    }

    public boolean eq(I64 parameter) {
        return new I64(this).eq(parameter);
    }

    public IDATA add(IDATA parameter) {
        return new IDATA(this).add(parameter);
    }

    public U32 sub(int number) {
        return new U32(this.data - (long)number);
    }

    public U32 sub(UScalar parameter) {
        return this.sub(new U32(parameter));
    }

    public U32 sub(U32 parameter) {
        return new U32(this.data - parameter.data);
    }

    public U64 sub(U64 parameter) {
        return new U64(this).sub(parameter);
    }

    public UDATA sub(UDATA parameter) {
        return new UDATA(this).sub(parameter);
    }

    public U32 sub(IScalar parameter) {
        return this.sub(new U32(parameter));
    }

    public I64 sub(I64 parameter) {
        return new I64(this).sub(parameter);
    }

    public IDATA sub(IDATA parameter) {
        return new IDATA(this).sub(parameter);
    }

    @Override
    public int intValue() {
        if (super.intValue() < 0) {
            throw new InvalidDataTypeException("U_32 contains value larger than Integer.MAX_VALUE");
        }
        return super.intValue();
    }

    public U32 bitOr(int number) {
        return new U32(this.data | (long)number);
    }

    public U32 bitOr(long number) {
        return new U32(this.data | number);
    }

    public U32 bitOr(UScalar parameter) {
        return this.bitOr(new U32(parameter));
    }

    public U32 bitOr(U32 parameter) {
        return new U32(this.data | parameter.data);
    }

    public U64 bitOr(U64 parameter) {
        return new U64(this).bitOr(parameter);
    }

    public UDATA bitOr(UDATA parameter) {
        return new UDATA(this).bitOr(parameter);
    }

    public U32 bitOr(IScalar parameter) {
        return this.bitOr(new U32(parameter));
    }

    public I64 bitOr(I64 parameter) {
        return new I64(this).bitOr(parameter);
    }

    public IDATA bitOr(IDATA parameter) {
        return new IDATA(this).bitOr(parameter);
    }

    public U32 bitXor(int number) {
        return new U32(this.data ^ (long)number);
    }

    public U32 bitXor(long number) {
        return new U32(this.data ^ number);
    }

    public U32 bitXor(Scalar parameter) {
        return this.bitXor(new U32(parameter));
    }

    public U32 bitXor(U32 parameter) {
        return new U32(this.data ^ parameter.data);
    }

    public UDATA bitXor(UDATA parameter) {
        return new UDATA(this).bitXor(parameter);
    }

    public IDATA bitXor(IDATA parameter) {
        return new IDATA(this).bitXor(parameter);
    }

    public U64 bitXor(U64 parameter) {
        return new U64(this).bitXor(parameter);
    }

    public I64 bitXor(I64 parameter) {
        return new I64(this).bitXor(parameter);
    }

    public U32 bitAnd(int number) {
        return new U32(this.data & (long)number);
    }

    public U32 bitAnd(long number) {
        return new U32(this.data & number);
    }

    public U32 bitAnd(UScalar parameter) {
        return this.bitAnd(new U32(parameter));
    }

    public U32 bitAnd(U32 parameter) {
        return new U32(this.data & parameter.data);
    }

    public U64 bitAnd(U64 parameter) {
        return new U64(this).bitAnd(parameter);
    }

    public UDATA bitAnd(UDATA parameter) {
        return new UDATA(this).bitAnd(parameter);
    }

    public U32 bitAnd(IScalar parameter) {
        return this.bitAnd(new U32(parameter));
    }

    public I64 bitAnd(I64 parameter) {
        return new I64(this).bitAnd(parameter);
    }

    public IDATA bitAnd(IDATA parameter) {
        return new IDATA(this).bitAnd(parameter);
    }

    public U32 leftShift(int i) {
        return new U32(this.data << i);
    }

    public U32 rightShift(int i) {
        return new U32(this.data >>> i);
    }

    public U32 bitNot() {
        return new U32(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public U32 mult(int parameter) {
        return new U32(this.data * (long)parameter);
    }

    public U32 mult(U32 parameter) {
        return new U32(this.data * parameter.data);
    }

    @Override
    public int sizeof() {
        return 4;
    }
}

