/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindModuleByNameCommand
extends Command {
    public FindModuleByNameCommand() {
        this.addCommand("findmodulebyname", "<moduleName>", "find the modules corresponding to a name pattern (e.g. 'java.*')");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printUsage(out);
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
                int hitCount = 0;
                String searchModuleName = args[0];
                PatternString pattern = new PatternString(searchModuleName);
                out.printf("Searching for modules named '%s' in VM=%s%n", searchModuleName, Long.toHexString(vm.getAddress()));
                while (iterator.hasNext()) {
                    J9ClassLoaderPointer classLoaderPointer = iterator.next();
                    HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(classLoaderPointer.moduleHashTable());
                    Iterator slotIterator = moduleHashTable.iterator();
                    while (slotIterator.hasNext()) {
                        J9ModulePointer modulePtr = (J9ModulePointer)slotIterator.next();
                        String moduleName = ModularityHelper.getModuleName(modulePtr);
                        if (!pattern.isMatch(moduleName)) continue;
                        ++hitCount;
                        String hexAddress = modulePtr.getHexAddress();
                        out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
                    }
                }
                out.printf("Found %d module(s) named '%s'%n", hitCount, searchModuleName);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printUsage(PrintStream out) {
        out.println("findmodulebyname <moduleNamePattern> - find the modules corresponding to a name pattern (e.g. 'java.*')");
    }
}

