/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;

public class DumpPackageCommand
extends Command {
    public DumpPackageCommand() {
        this.addCommand("dumppackage", "[all|exportsTo|classes] <packageAddress>|help", "List details about a package");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        Subcommand subcommand;
        String filterArg = null;
        ModularityHelper.ClassOutput classOutputter = null;
        ModularityHelper.ClassIteratorFilter classFilter = null;
        block2 : switch (args.length) {
            case 1: {
                switch (args[0]) {
                    case "help": {
                        subcommand = Subcommand.HELP;
                        break block2;
                    }
                }
                filterArg = args[0];
                subcommand = Subcommand.ALL;
                break;
            }
            case 2: {
                filterArg = args[1];
                switch (args[0]) {
                    case "all": {
                        subcommand = Subcommand.ALL;
                        break block2;
                    }
                    case "exportsTo": {
                        subcommand = Subcommand.PRINT_PACKAGE;
                        break block2;
                    }
                    case "classes": {
                        classOutputter = ModularityHelper::printJ9Class;
                        classFilter = DumpPackageCommand::filterClassByPackage;
                        subcommand = Subcommand.CLASS;
                        break block2;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            default: {
                subcommand = Subcommand.INVALID;
            }
        }
        try {
            J9PackagePointer packagePtr = null;
            if (null != filterArg) {
                try {
                    packagePtr = J9PackagePointer.cast(Long.decode(filterArg));
                }
                catch (NumberFormatException e) {
                    throw new DDRInteractiveCommandException("The argument \"" + filterArg + "\" is not a valid number. It should be the address of a J9Package.");
                }
            }
            int result = 0;
            switch (subcommand) {
                case ALL: {
                    out.println("Exported to:");
                    ModularityHelper.printPackageExports(packagePtr, out);
                    break;
                }
                case PRINT_PACKAGE: {
                    ModularityHelper.printPackageExports(packagePtr, out);
                    break;
                }
                case CLASS: {
                    J9ClassLoaderPointer classLoaderPtr = packagePtr.classLoader();
                    result = ModularityHelper.iterateClassLoaderClasses(out, classFilter, classOutputter, filterArg, classLoaderPtr);
                    out.printf("Found %d class%s%n", result, 1 == result ? "" : "es");
                    break;
                }
                case HELP: {
                    this.printHelp(out);
                    break;
                }
                default: {
                    out.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    this.printHelp(out);
                    break;
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private static boolean filterClassByPackage(J9ClassPointer classPtr, String targetModuleAddress) throws CorruptDataException {
        boolean result = false;
        String className = J9ClassHelper.getJavaName(classPtr);
        int index = className.lastIndexOf(47);
        if (index >= 0) {
            String classPackage = className.substring(0, index);
            J9PackagePointer packagePtr = J9PackagePointer.cast(Long.decode(targetModuleAddress));
            String packageName = J9UTF8Helper.stringValue(packagePtr.packageName());
            result = classPackage.equals(packageName);
        }
        return result;
    }

    void printHelp(PrintStream out) {
        out.println("Usage:");
        out.println("  !dumppackage <packageAddress>");
        out.println("      Lists !dumppackage all <packageAddress>");
        out.println("  !dumppackage all <packageAddress>");
        out.println("      Lists !dumppackage exportsTo <packageAddress>");
        out.println("  !dumppackage exportsTo <packageAddress>");
        out.println("      Lists all modules that the given package is exported to");
        out.println("  !dumppackage classes <packageAddress>");
        out.println("      Lists all loaded classes in the given package");
    }

    static enum Subcommand {
        CLASS,
        ALL,
        PRINT_PACKAGE,
        HELP,
        INVALID;

    }
}

