/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.PackageHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleExportsCommand
extends Command {
    public DumpModuleExportsCommand() {
        this.addCommand("dumpmoduleexports", "<targetModuleAddress>", "display all j9packages exported by the target module");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !dumpmoduleexports <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
                String targetModuleAddress = args[0];
                while (iterator.hasNext()) {
                    J9ClassLoaderPointer classLoaderPointer = iterator.next();
                    HashTable<J9PackagePointer> packageHashTable = PackageHashTable.fromJ9HashTable(classLoaderPointer.packageHashTable());
                    Iterator slotIterator = packageHashTable.iterator();
                    while (slotIterator.hasNext()) {
                        J9PackagePointer packagePtr = (J9PackagePointer)slotIterator.next();
                        if (!packagePtr.module().getHexAddress().equals(targetModuleAddress)) continue;
                        String packageName = J9UTF8Helper.stringValue(packagePtr.packageName());
                        String hexAddress = packagePtr.getHexAddress();
                        out.printf("%-45s !j9package %s%n", packageName, hexAddress);
                    }
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

