/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.PackageHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class ModularityHelper {
    public static boolean moduleFilterMatchAll(J9ModulePointer modulePtr, String arg) {
        return true;
    }

    public static void printJ9Module(J9ModulePointer modulePtr, PrintStream out) throws CorruptDataException {
        String moduleName = ModularityHelper.getModuleName(modulePtr);
        String hexAddress = modulePtr.getHexAddress();
        out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
    }

    public static void printPackageJ9Module(J9PackagePointer packagePtr, PrintStream out) throws CorruptDataException {
        J9ModulePointer modulePtr = packagePtr.module();
        ModularityHelper.printJ9Module(modulePtr, out);
    }

    public static void printJ9Package(J9PackagePointer packagePtr, PrintStream out) throws CorruptDataException {
        String packageName = J9UTF8Helper.stringValue(packagePtr.packageName());
        String hexAddress = packagePtr.getHexAddress();
        out.printf("%-45s !j9package %s%n", packageName, hexAddress);
    }

    public static void printJ9Class(J9ClassPointer classPtr, PrintStream out) throws CorruptDataException {
        String className = J9ClassHelper.getName(classPtr);
        String classAddress = classPtr.getHexAddress();
        out.printf("%-30s !j9class %s%n", className, classAddress);
    }

    public static void printPackageExportVerbose(J9PackagePointer packagePtr, PrintStream out) throws CorruptDataException {
        out.print("Exports ");
        ModularityHelper.printJ9Package(packagePtr, out);
        if (packagePtr.exportToAll().isZero()) {
            ModularityHelper.printPackageExportTo(packagePtr, out, "     to ");
        }
    }

    public static void printPackageExports(J9PackagePointer packagePtr, PrintStream out) throws CorruptDataException {
        if (packagePtr.exportToAll().isZero()) {
            int exportCount = ModularityHelper.printPackageExportTo(packagePtr, out, "");
            if (0 == exportCount) {
                out.println("Package is not exported");
            }
        } else {
            out.println("Package is exported to all");
        }
    }

    private static int printPackageExportTo(J9PackagePointer packagePtr, PrintStream out, String linePrefix) throws CorruptDataException {
        int count = 0;
        J9HashTablePointer exportsHashTable = packagePtr.exportsHashTable();
        HashTable<J9ModulePointer> exportsModuleHashTable = ModuleHashTable.fromJ9HashTable(exportsHashTable);
        Iterator exportsSlotIterator = exportsModuleHashTable.iterator();
        while (exportsSlotIterator.hasNext()) {
            ++count;
            J9ModulePointer modulePtr = (J9ModulePointer)exportsSlotIterator.next();
            out.print(linePrefix);
            ModularityHelper.printJ9Module(modulePtr, out);
        }
        if (!packagePtr.exportToAllUnnamed().isZero()) {
            ++count;
            out.printf("%sALL-UNNAMED%n", linePrefix);
        }
        return count;
    }

    public static int iterateModules(PrintStream out, ModuleIteratorFilter filter, ModuleOutput outputter, String filterArg) throws CorruptDataException {
        int count = 0;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
            GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
            while (iterator.hasNext()) {
                J9ClassLoaderPointer classLoaderPointer = iterator.next();
                HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(classLoaderPointer.moduleHashTable());
                Iterator slotIterator = moduleHashTable.iterator();
                while (slotIterator.hasNext()) {
                    J9ModulePointer modulePtr = (J9ModulePointer)slotIterator.next();
                    if (!filter.filter(modulePtr, filterArg)) continue;
                    ++count;
                    outputter.print(modulePtr, out);
                }
            }
        }
        return count;
    }

    public static int iteratePackages(PrintStream out, PackageIteratorFilter filter, PackageOutput outputter, String filterArg) throws CorruptDataException {
        int count = 0;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
            GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
            while (iterator.hasNext()) {
                count += ModularityHelper.iterateClassLoaderPackages(out, filter, outputter, filterArg, iterator.next());
            }
        }
        return count;
    }

    public static int iterateClassLoaderPackages(PrintStream out, PackageIteratorFilter filter, PackageOutput outputter, String filterArg, J9ClassLoaderPointer classLoaderPtr) throws CorruptDataException {
        int count = 0;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
            HashTable<J9PackagePointer> packageHashTable = PackageHashTable.fromJ9HashTable(classLoaderPtr.packageHashTable());
            Iterator slotIterator = packageHashTable.iterator();
            while (slotIterator.hasNext()) {
                J9PackagePointer packagePtr = (J9PackagePointer)slotIterator.next();
                if (!filter.filter(packagePtr, filterArg)) continue;
                ++count;
                outputter.print(packagePtr, out);
            }
        }
        return count;
    }

    public static int iterateClassLoaderClasses(PrintStream out, ClassIteratorFilter filter, ClassOutput outputter, String filterArg, J9ClassLoaderPointer classLoaderPtr) throws CorruptDataException {
        int count = 0;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
            Iterator<J9ClassPointer> classIterator = ClassIterator.fromJ9Classloader(classLoaderPtr);
            while (classIterator.hasNext()) {
                J9ClassPointer classPtr = classIterator.next();
                if (!filter.filter(classPtr, filterArg)) continue;
                ++count;
                outputter.print(classPtr, out);
            }
        }
        return count;
    }

    public static String getModuleName(J9ModulePointer module) throws CorruptDataException {
        String moduleName = null;
        if (module != null && module.notNull()) {
            if (0L != J9Consts.J9_MODULE_NAME_IS_J9UTF8) {
                J9UTF8Pointer mn = module.moduleName();
                moduleName = J9UTF8Helper.stringValue(mn);
            } else {
                J9ObjectPointer mn = J9ObjectPointer.cast(module.moduleNameEA().at(0L));
                moduleName = J9ObjectHelper.stringValue(mn);
            }
        }
        return moduleName;
    }

    @FunctionalInterface
    public static interface ClassIteratorFilter {
        public boolean filter(J9ClassPointer var1, String var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ClassOutput {
        public void print(J9ClassPointer var1, PrintStream var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ModuleIteratorFilter {
        public boolean filter(J9ModulePointer var1, String var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ModuleOutput {
        public void print(J9ModulePointer var1, PrintStream var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface PackageIteratorFilter {
        public boolean filter(J9PackagePointer var1, String var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface PackageOutput {
        public void print(J9PackagePointer var1, PrintStream var2) throws CorruptDataException;
    }
}

