/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9Consts.class)
public class J9ConstsPointer
extends StructurePointer {
    public static final J9ConstsPointer NULL = new J9ConstsPointer(0L);

    protected J9ConstsPointer(long address) {
        super(address);
    }

    public static J9ConstsPointer cast(AbstractPointer structure) {
        return J9ConstsPointer.cast(structure.getAddress());
    }

    public static J9ConstsPointer cast(UDATA udata) {
        return J9ConstsPointer.cast(udata.longValue());
    }

    public static J9ConstsPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ConstsPointer(address);
    }

    @Override
    public J9ConstsPointer add(long count) {
        return J9ConstsPointer.cast(this.address + J9Consts.SIZEOF * count);
    }

    @Override
    public J9ConstsPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9ConstsPointer addOffset(long offset) {
        return J9ConstsPointer.cast(this.address + offset);
    }

    @Override
    public J9ConstsPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ConstsPointer sub(long count) {
        return J9ConstsPointer.cast(this.address - J9Consts.SIZEOF * count);
    }

    @Override
    public J9ConstsPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9ConstsPointer subOffset(long offset) {
        return J9ConstsPointer.cast(this.address - offset);
    }

    @Override
    public J9ConstsPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9ConstsPointer untag(long mask) {
        return J9ConstsPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9ConstsPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Consts.SIZEOF;
    }
}

