/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.MonitorTable;
import com.ibm.j9ddr.vm27.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckMonitorTable
extends Check {
    CheckMonitorTable() {
    }

    @Override
    public void check() {
        try {
            GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
            while (monitorReferenceIterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitor = monitorReferenceIterator.next();
                J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(objectMonitor.monitor());
                PointerPointer slot = PointerPointer.cast(monitor.userDataEA());
                if (this._engine.checkSlotPool(slot, VoidPointer.cast(monitorReferenceIterator.currentMonitorTable().getJ9HashTablePointer())) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "MONITOR TABLE";
    }

    @Override
    public void print() {
        try {
            VoidPointer monitorTableList = VoidPointer.cast(this.getJavaVM().monitorTableList());
            GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
            MonitorTable previousMonitorTable = null;
            ScanFormatter formatter = new ScanFormatter(this, "MonitorTableList", monitorTableList);
            while (monitorReferenceIterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitor = monitorReferenceIterator.next();
                MonitorTable currentMonitorTable = monitorReferenceIterator.currentMonitorTable();
                if (!currentMonitorTable.equals(previousMonitorTable)) {
                    if (null != previousMonitorTable) {
                        formatter.endSection();
                    }
                    formatter.section("MonitorTable", currentMonitorTable.getMonitorTableListEntryPointer());
                }
                J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(objectMonitor.monitor());
                formatter.entry(VoidPointer.cast(monitor.userData()));
                previousMonitorTable = currentMonitorTable;
            }
            if (null != previousMonitorTable) {
                formatter.endSection();
            }
            formatter.end("MonitorTableList", monitorTableList);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

