/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm27.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm27.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm27.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm27.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMEntryLocalStoragePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.structure.J9Consts;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;

public class JitstackCommand
extends Command {
    public JitstackCommand() {
        this.addCommand("jitstack", "<thread>,<sp>,<pc>", "Dump jit stack");
        this.addCommand("jitstackslots", "<thread>,<sp>,<pc>", "Dump jit stack slots");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (!J9BuildFlags.interp_nativeSupport) {
            CommandUtils.dbgPrint(out, "No JIT in this build\n");
            return;
        }
        try {
            String[] realArgs = null;
            if (args.length != 0) {
                realArgs = args[0].split(",");
            }
            if (args.length == 0 || realArgs.length != 3 && realArgs.length != 4) {
                CommandUtils.dbgPrint(out, "Usage:\n");
                CommandUtils.dbgPrint(out, "\t!jitstack thread,sp,pc\n");
                CommandUtils.dbgPrint(out, "\t!jitstack thread,sp,pc,els\n");
                CommandUtils.dbgPrint(out, "\tUse !jitstackslots instead of !jitstack to see slot values\n");
                return;
            }
            long address = CommandUtils.parsePointer(realArgs[0], J9BuildFlags.env_data64);
            J9VMThreadPointer thread = J9VMThreadPointer.cast(address);
            StackWalkerUtils.enableVerboseLogging(2, out);
            WalkState walkState = new WalkState();
            address = CommandUtils.parsePointer(realArgs[1], J9BuildFlags.env_data64);
            UDATAPointer sp = UDATAPointer.cast(address);
            address = CommandUtils.parsePointer(realArgs[2], J9BuildFlags.env_data64);
            U8Pointer pc = U8Pointer.cast(address);
            UDATAPointer arg0EA = UDATAPointer.NULL;
            J9MethodPointer literals = J9MethodPointer.NULL;
            J9VMEntryLocalStoragePointer entryLocalStorage = J9VMEntryLocalStoragePointer.NULL;
            if (realArgs.length == 4) {
                address = CommandUtils.parsePointer(realArgs[3], J9BuildFlags.env_data64);
                entryLocalStorage = J9VMEntryLocalStoragePointer.cast(address);
            } else {
                entryLocalStorage = thread.entryLocalStorage();
            }
            walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
            walkState.flags |= J9Consts.J9_STACKWALK_START_AT_JIT_FRAME;
            if (command.equalsIgnoreCase("!jitstackslots")) {
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
                StackWalkerUtils.enableVerboseLogging(100, out);
            }
            walkState.walkThread = thread;
            walkState.callBacks = new BaseStackWalkerCallbacks();
            walkState.frameFlags = new UDATA(0L);
            StackWalkResult result = StackWalker.walkStackFrames(walkState, sp, arg0EA, pc, literals, entryLocalStorage);
            if (result != StackWalkResult.NONE) {
                out.println("Stack walk result: " + (Object)((Object)result));
            }
            StackWalkerUtils.disableVerboseLogging();
            out.flush();
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

