/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.structure.HyportConstants;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=HyportConstants.class)
public class HyportConstantsPointer
extends StructurePointer {
    public static final HyportConstantsPointer NULL = new HyportConstantsPointer(0L);

    protected HyportConstantsPointer(long address) {
        super(address);
    }

    public static HyportConstantsPointer cast(AbstractPointer structure) {
        return HyportConstantsPointer.cast(structure.getAddress());
    }

    public static HyportConstantsPointer cast(UDATA udata) {
        return HyportConstantsPointer.cast(udata.longValue());
    }

    public static HyportConstantsPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new HyportConstantsPointer(address);
    }

    @Override
    public HyportConstantsPointer add(long count) {
        return HyportConstantsPointer.cast(this.address + HyportConstants.SIZEOF * count);
    }

    @Override
    public HyportConstantsPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public HyportConstantsPointer addOffset(long offset) {
        return HyportConstantsPointer.cast(this.address + offset);
    }

    @Override
    public HyportConstantsPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public HyportConstantsPointer sub(long count) {
        return HyportConstantsPointer.cast(this.address - HyportConstants.SIZEOF * count);
    }

    @Override
    public HyportConstantsPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public HyportConstantsPointer subOffset(long offset) {
        return HyportConstantsPointer.cast(this.address - offset);
    }

    @Override
    public HyportConstantsPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public HyportConstantsPointer untag(long mask) {
        return HyportConstantsPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public HyportConstantsPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return HyportConstants.SIZEOF;
    }
}

