/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.AbstractLruCache;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public final class IntegerLruCache
extends AbstractLruCache {
    int[] values = new int[17];
    private boolean doCheck = true;

    public IntegerLruCache(int maxSize) {
        super(maxSize);
    }

    @Override
    Object getValuesArray() {
        return this.values;
    }

    @Override
    void allocNewValuesArray(int newSize) {
        super.allocNewValuesArray(newSize);
        this.values = new int[newSize];
    }

    @Override
    void put(long key, Object oldvalues, int offset) {
        int[] v = (int[])oldvalues;
        this.put(key, v[offset]);
    }

    public synchronized int get(long key) {
        int index = this.getIndexAndPromote(key);
        if (index != -1) {
            return this.values[index];
        }
        return -1;
    }

    public synchronized void put(long key, int value) {
        int index = this.putIndexAndPromote(key);
        this.values[index] = value;
        this.checkRehash();
    }

    private void test() {
        Random rand = new Random(23L);
        LruCache check = new LruCache(1000);
        for (int i = 0; i < 50000; ++i) {
            long key = rand.nextLong();
            int value = rand.nextInt();
            if (this.get(key) != -1) continue;
            this.put(key, value);
            if (!this.doCheck) continue;
            check.put(key, value);
            if (this.get(key) == value) continue;
            throw new Error("found " + this.get(key) + " expected " + value);
        }
        if (this.doCheck) {
            Long[] keys = check.keySet().toArray(new Long[0]);
            for (int i = 0; i < keys.length; ++i) {
                long key = keys[i];
                int value = (Integer)check.get(keys[i]);
                if (this.get(key) == value) continue;
                throw new Error("at " + i + " found " + this.get(key) + " expected " + value + " key " + key);
            }
        }
    }

    public static void main(String[] args) {
        int j;
        int i;
        IntegerLruCache map = new IntegerLruCache(20);
        for (i = 0; i < 20; ++i) {
            map.put(i, i);
        }
        for (i = 19; i >= 0; --i) {
            j = map.get(i);
            if (i == j) continue;
            throw new Error("j is " + j + " for i " + i);
        }
        for (i = 20; i < 30; ++i) {
            map.put(i, i);
        }
        for (i = 0; i < 30; ++i) {
            j = map.get(i);
            if (!(i >= 20 || i < 10 ? i != j : j != -1)) continue;
            throw new Error("j is " + j + " for i " + i);
        }
        map = new IntegerLruCache(1000);
        map.test();
        IntEnumeration e = map.getKeys();
        while (e.hasMoreElements()) {
            long key = e.nextInt();
            if (map.get(key) != -1) continue;
            throw new Error("uh oh");
        }
        System.out.println("finished!");
    }

    private class LruCache
    extends LinkedHashMap {
        int maxSize;

        LruCache(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

