/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;

public final class Merge {
    private Vector threads;
    private TraceRecord currentTraceRecord = null;
    private BigInteger nextOldest;
    private LinkedList traceRecordList = new LinkedList();
    private boolean oneThreadLeft = false;
    private int numberOfRecordsProcessed = 0;

    protected Merge(Vector threads) throws IOException {
        this.threads = threads;
        for (TraceThread traceThread : threads) {
            TraceRecord traceRecord = (TraceRecord)traceThread.firstElement();
            traceRecord.prime();
            this.traceRecordList.add(traceRecord);
        }
        TraceFormat.outStream.println("Number of Trace Buffers Processed:");
        TraceFormat.outStream.print("     0 ");
        this.getCurrentTraceRecordAndUpdateNextOldest();
        Util.Debug.println("Merge: nextOldest after constructor " + this.nextOldest);
    }

    protected final void getCurrentTraceRecordAndUpdateNextOldest() {
        Collections.sort(this.traceRecordList);
        this.currentTraceRecord = (TraceRecord)this.traceRecordList.get(0);
        if (this.traceRecordList.size() > 1) {
            this.nextOldest = ((TraceRecord)this.traceRecordList.get(1)).getCurrentTimeStamp();
        } else {
            this.nextOldest = BigInteger.ZERO;
            this.oneThreadLeft = true;
        }
    }

    protected final String getNextEntry() throws IOException {
        while (this.currentTraceRecord.getNextEntry() == 0) {
            Util.Debug.println("Merge: no more entries in this Record");
            ++this.numberOfRecordsProcessed;
            if (this.numberOfRecordsProcessed % 10 == 0 || this.numberOfRecordsProcessed == TraceFormat.expectedRecords) {
                StringBuffer tempBuffer = new StringBuffer(new Integer(this.numberOfRecordsProcessed).toString());
                Util.padBuffer(tempBuffer, 6, ' ', false);
                TraceFormat.outStream.print(tempBuffer + " ");
            }
            if ((this.numberOfRecordsProcessed + 10) % 100 == 0) {
                TraceFormat.outStream.println("");
            }
            this.currentTraceRecord.release();
            this.traceRecordList.remove(this.currentTraceRecord);
            TraceRecord traceRecord = this.currentTraceRecord.getNextRecord();
            if (traceRecord != null) {
                Util.Debug.println("Merge: priming next Record on this thread");
                traceRecord.prime();
                this.traceRecordList.add(traceRecord);
            }
            if (this.traceRecordList.size() == 0) {
                Util.Debug.println("Merge: Finished");
                TraceFormat.outStream.println(" ");
                return null;
            }
            this.getCurrentTraceRecordAndUpdateNextOldest();
        }
        BigInteger timeStamp = this.currentTraceRecord.getCurrentTimeStamp();
        if (timeStamp.compareTo(this.nextOldest) != -1 && !this.oneThreadLeft) {
            this.getCurrentTraceRecordAndUpdateNextOldest();
            this.currentTraceRecord.getNextEntry();
        }
        return this.currentTraceRecord.formatCurrentEntry();
    }
}

