/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.cpu.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.cpu.CpuLabels;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.CpuInternalObject;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Logger;

public class CpuParser
implements LineParser {
    private static final String CLASSNAME = CpuParser.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(CpuParser.class);
    private static final DataFactory factory = DataFactory.getFactory();
    private static final String DELIMITER = "@#";
    private static final String EYECATCHER = "startCPU";
    private AxisPair numberAxisPair = null;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = AxisUtil.PERCENT_AXIS.createDataAxis(outputProperties, UnitLabels.PERCENT_SIGN);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.populateCpuData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    private SubsystemDataBuilder getCpuSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.CPU);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createCpuSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createCpuSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(JVMLabels.CPU, "com.ibm.java.diagnostics.healthcenter.cpu.perspective.CpuPerspective");
        return subsystemDataBuilder;
    }

    private void createCpuProcessDataPoint(DataBuilder dataBuilder, double d, double d2) {
        String string;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        SubsystemDataBuilder subsystemDataBuilder = this.getCpuSubsystemData(dataBuilder);
        DataBuilder dataBuilder2 = subsystemDataBuilder.getData(string = CpuLabels.CPU_PROCESS);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            subsystemDataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, d2, this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private void createCpuSystemDataPoint(DataBuilder dataBuilder, double d, double d2) {
        String string;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        SubsystemDataBuilder subsystemDataBuilder = this.getCpuSubsystemData(dataBuilder);
        DataBuilder dataBuilder2 = subsystemDataBuilder.getData(string = CpuLabels.CPU_SYSTEM);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            subsystemDataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, d2, this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private boolean populateCpuData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (!string.startsWith(EYECATCHER)) continue;
            String[] stringArray2 = string.split(DELIMITER);
            double d = new Double(stringArray2[1]);
            double d2 = new Double(stringArray2[2]);
            double d3 = new Double(stringArray2[3]);
            if (d2 >= 0.0) {
                this.createCpuProcessDataPoint(dataBuilder, d, d2 *= 100.0);
                bl = true;
            }
            if (d3 >= 0.0) {
                if ((d3 *= 100.0) < d2) {
                    d3 = d2;
                }
                bl = true;
                this.createCpuSystemDataPoint(dataBuilder, d, d3);
            }
            CpuInternalObject cpuInternalObject = new CpuInternalObject((long)d, d3, d2);
            MarshallerImpl.getMarshaller().getCpuEventHandler().addEvent(cpuInternalObject);
        }
        return bl;
    }
}

