/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.G;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public final class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private IBMJCEPlusProvider e = null;
    private static final String[] z;

    public ECParameters(IBMJCEPlusProvider iBMJCEPlusProvider) {
        this.e = iBMJCEPlusProvider;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.a();
    }

    protected byte[] a() throws IOException {
        byte[] byArray = this.c();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            ECParameterSpec eCParameterSpec = new ECParameterSpec(this.b, this.c, this.d, this.a);
            return (T)((AlgorithmParameterSpec)clazz.cast(eCParameterSpec));
        }
        if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new ECGenParameterSpec(clazz.getName())));
        }
        throw new InvalidParameterSpecException(z[19]);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(algorithmParameterSpec);
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            G g2 = null;
            try {
                g2 = new G(eCGenParameterSpec.getName());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new InvalidParameterSpecException(invalidParameterException.getMessage());
            }
            ECParameterSpec eCParameterSpec = g2.b();
            this.b = eCParameterSpec.getCurve();
            this.c = eCParameterSpec.getGenerator();
            this.d = eCParameterSpec.getOrder();
            this.a = eCParameterSpec.getCofactor();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidParameterSpecException(z[0]);
        }
        this.b = ((ECParameterSpec)algorithmParameterSpec).getCurve();
        this.c = ((ECParameterSpec)algorithmParameterSpec).getGenerator();
        this.d = ((ECParameterSpec)algorithmParameterSpec).getOrder();
        this.a = ((ECParameterSpec)algorithmParameterSpec).getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.a(byArray);
    }

    protected void a(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.c(byArray);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return this.b();
    }

    protected String b() {
        return z[11] + this.b.getA() + z[13] + this.b.getB() + z[14] + this.b.getField().getFieldSize() + z[10] + this.d.toString() + z[12] + this.a + "\n";
    }

    protected static AlgorithmParameters a(IBMJCEPlusProvider iBMJCEPlusProvider, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[4], iBMJCEPlusProvider);
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[5] + generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] a(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n3 = ellipticCurve.getField().getFieldSize();
        int n2 = n3 + 7 >> 3;
        byte[] byArray2 = ECParameters.b(eCPoint.getAffineX().toByteArray());
        byte[] byArray = ECParameters.b(eCPoint.getAffineY().toByteArray());
        if (byArray2.length <= n2 && byArray.length <= n2) {
            byte[] byArray3 = new byte[1 + (n2 << 1)];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        throw new ProviderException(z[24]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ECPoint a(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[2]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[3]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] b(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static DerValue a(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.b(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.b(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[1] + iOException);
        }
    }

    private static EllipticCurve a(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[17]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = byArray3 == null ? new EllipticCurve(eCField, bigInteger, bigInteger2) : new EllipticCurve(eCField, bigInteger, bigInteger2, byArray3);
            return ellipticCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[18] + iOException);
        }
    }

    private static DerValue a(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[23] + iOException);
        }
    }

    private static ECFieldFp a(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[20]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[21]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[22] + iOException);
        }
    }

    private byte[] c() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            G g2 = ECParameters.b(eCParameterSpec);
            if (g2 != null) {
                return g2.c();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[6]);
            }
            DerValue derValue = ECParameters.a((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.a(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.a(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[7] + iOException);
        }
    }

    static byte[] a(ECParameterSpec eCParameterSpec) throws IOException {
        try {
            EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
            ECPoint eCPoint = eCParameterSpec.getGenerator();
            BigInteger bigInteger = eCParameterSpec.getOrder();
            int n2 = eCParameterSpec.getCofactor();
            G g2 = ECParameters.b(eCParameterSpec);
            if (g2 != null) {
                return g2.c();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[15]);
            }
            DerValue derValue = ECParameters.a((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.a(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.a(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[16] + iOException);
        }
    }

    private static ECParameterSpec c(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return G.c(string);
                }
                throw new IOException(z[9]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.a(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.a(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.a(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[8] + iOException);
        }
    }

    static G b(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = G.a();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                ECParameterSpec eCParameterSpec2;
                String string;
                block43: {
                    byte[] byArray;
                    byte[] byArray2;
                    block42: {
                        string = entry.getKey();
                        eCParameterSpec2 = entry.getValue();
                        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                        BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                        BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                        int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                        int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                        byArray2 = eCParameterSpec2.getCurve().getSeed();
                        byArray = eCParameterSpec.getCurve().getSeed();
                        if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4)) continue;
                        if (n2 != n3) {
                            continue;
                        }
                        if (byArray2 != null || byArray != null) break block42;
                        break block43;
                    }
                    if (byArray2 == null && byArray != null) {
                        continue;
                    }
                    if (byArray2 != null && byArray == null) {
                        continue;
                    }
                    if (byArray2 == null || byArray == null) break block43;
                    if (byArray2.length != byArray.length) {
                        continue;
                    }
                    boolean bl = true;
                    int n4 = 0;
                    while (true) {
                        block47: {
                            if (n4 >= byArray2.length) break;
                            if (byArray2[n4] == byArray[n4]) break block47;
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator())) {
                    continue;
                }
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder())) {
                    continue;
                }
                if (eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) {
                    continue;
                }
                G g2 = new G(string);
                return g2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "N5\u0010|Nu4\u0001~Wf/\u0014,Nf)\u0010a[s>\u0003,Mw>\u0012eXn8\u0010xWh5";
        int n3 = -1;
        block32: while (true) {
            char[] cArray;
            block36: {
                int n4;
                int n5;
                block35: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block35;
                    n5 = n5;
                    if (n5 <= n4) break block36;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 7;
                            break;
                        }
                        case 1: {
                            n6 = 91;
                            break;
                        }
                        case 2: {
                            n6 = 113;
                            break;
                        }
                        case 3: {
                            n6 = 12;
                            break;
                        }
                        default: {
                            n6 = 62;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "B#\u0012iNs2\u001eb\u001en5QiPd4\u0015i{k7\u0018|Jn82yLq>Y%\u0004'";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "H5\u001du\u001er5\u0012cSw)\u0014\u007fMb?Q|Qn5\u0005,Xh)\u001cmJ'(\u0004|Nh)\u0005iZ";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "W4\u0018bJ'?\u001eiM'5\u001ex\u001ej:\u0005oV'=\u0018iRc{\u0002eDb";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "B\u0018";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "R5\u0002yNw4\u0003x[c{\u0001mLf6\u0014x[u{\u0002|[d2\u0017e]f/\u0018cP={";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "B\u00187e[k?7>S'>\u001foQr5\u0005iLb?QeP'>\u001foQc>4Onf)\u0010a[s>\u0003\u007f\u0016.uQ,{D\u001d\u0018iRc\u001dCa\u001en(QbQs{\u0012yLu>\u001fxR~{\u0002yNw4\u0003x[cu";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "B#\u0012iNs2\u001eb\u001en5QiPd4\u0015i{D\u000b\u0010~_j>\u0005iLtsX6\u001e";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "B#\u0012iNs2\u001eb\u001en5Qh[d4\u0015i{D\u000b\u0010~_j>\u0005iLtsX6\u001e";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "I4\u0005,_'\b4]kB\u00152I\u001eh)QmP'\u00148H";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\rR\u001e~Zb)K,4\u000eR";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\rR\u0012yLq>K,4\u000eR\u00106\u001e";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\rR\u0012cXf8\u0005cL={";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\rRxn\u0004'";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\rRx\u007fW}>K,";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "B\u00187e[k?7>S'>\u001foQr5\u0005iLb?QeP'>\u001foQc>4Onf)\u0010a[s>\u0003\u007f\u0016.uQ,{D\u001d\u0018iRc\u001dCa\u001en(QbQs{\u0012yLu>\u001fxR~{\u0002yNw4\u0003x[cu";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "B#\u0012iNs2\u001eb\u001en5QiPd4\u0015i{D\u000b\u0010~_j>\u0005iLtsX6\u001e";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "I4\u0005,_'\b4]kB\u00152I";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "B#\u0012iNs2\u001eb\u001en5Qh[d4\u0015i{k7\u0018|Jn82yLq>Y%\u0004'";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "H5\u001du\u001eB\u0018!mLf6\u0014x[u\b\u0001i]':\u001fh\u001eB\u00186iPW:\u0003mSb/\u0014~mw>\u0012,Mr+\u0001cLs>\u0015";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "I4\u0005,_'\b4]kB\u00152I";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "N5\u0012cLu>\u0012x\u001eH\u00125,[i8\u001eyPs>\u0003iZ'?\u0004~Wi<Qh[d4\u0015inu2\u001cixn>\u001dhj~+\u0014\"";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "B#\u0012iNs2\u001eb\u001en5Qh[d4\u0015inu2\u001cixn>\u001dhj~+\u0014$\u0017={";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "B#\u0012iNs2\u001eb\u001en5QiPd4\u0015inu2\u001cixn>\u001dhj~+\u0014$\u0017={";
                    n3 = 22;
                    continue block32;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "W4\u0018bJ'8\u001ecLc2\u001fmJb(QhQ'5\u001ex\u001ej:\u0005oV'=\u0018iRc{\u0002eDb";
                    n3 = 23;
                    continue block32;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

