/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DisplayText
implements Cloneable {
    private String text;
    private byte format;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DisplayText";
    private volatile int cachedHashVal = 0;

    public DisplayText(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DisplayText", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "DisplayText");
        }
    }

    public DisplayText(String text, byte format) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "DisplayText", text, new Byte(format));
        }
        if (text == null) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "text not specified");
            }
            throw new IllegalArgumentException("text not specified");
        }
        if (text.length() > 200) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "text too long");
            }
            throw new IllegalArgumentException("text too long");
        }
        if (format != 30 && format != 12 && format != 22 && format != 26) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "Invalid text format");
            }
            throw new IllegalArgumentException("Invalid text format");
        }
        this.text = text;
        this.format = format;
        if (debug != null) {
            debug.exit(16384L, className, "DisplayText");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            DisplayText retobj = new DisplayText(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream tmp = new DerOutputStream();
        switch (this.format) {
            case 26: {
                tmp.putVisibleString(this.text);
                break;
            }
            case 30: {
                tmp.putBMPString(this.text);
                break;
            }
            case 12: {
                tmp.putUTF8String(this.text);
                break;
            }
            case 22: {
                tmp.putIA5String(this.text);
                break;
            }
        }
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() == 30) {
            this.format = (byte)30;
            this.text = PKCS12Utils.bmp2string(new DerInputStream(encoding.toByteArray()).getBMPString());
        } else if (encoding.getTag() == 12) {
            this.format = (byte)12;
            this.text = encoding.getUTF8String();
        } else if (encoding.getTag() == 26) {
            this.format = (byte)26;
            this.text = encoding.getVisibleString();
        } else if (encoding.getTag() == 22) {
            this.format = (byte)22;
            this.text = encoding.getIA5String();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DisplayText parsing error, invalid tag " + encoding.getTag());
            }
            throw new IOException("DisplayText parsing error, invalid tag " + encoding.getTag());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof DisplayText)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((DisplayText)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public byte getTextFormat() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTextFormat");
            debug.exit(16384L, (Object)className, "getTextFormat", this.format);
        }
        return this.format;
    }

    public String getText() {
        if (debug != null) {
            debug.entry(16384L, className, "getText");
            debug.exit(16384L, (Object)className, "getText", this.text);
        }
        return this.text;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "";
        out = out + this.text;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

