/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class CPSuri
implements Qualifier,
Cloneable {
    private ObjectIdentifier oid = PKIXExtensions.CPSuri_Id;
    private String value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.X509.CPSuri";
    private volatile int cachedHashVal = 0;

    public CPSuri(String uri) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CPSuri", uri);
            debug.exit(16384L, className, "CPSuri");
        }
        this.value = uri;
    }

    public CPSuri(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CPSuri", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "CPSuri");
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream derout = new DerOutputStream();
        derout.putIA5String(this.value);
        out.write(derout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKIXExtensions.CPSuri_Id);
        }
        return PKIXExtensions.CPSuri_Id;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CPSuri");
        }
        return "CPSuri";
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", new CPSuri(derout.toByteArray()));
            }
            return new CPSuri(derout.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "CPSuri: [";
        out = out + "\r\n\tobject identifier: " + this.oid;
        out = out + "\r\n\turi: " + this.value.toString();
        out = out + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof CPSuri)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((CPSuri)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        this.value = encoding.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }
}

