/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.tools.dumpASN1Atom;
import com.ibm.security.tools.dumpASN1OidList;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public final class dumpASN1 {
    static final long LENGTH_MAGIC = 177545L;
    public static boolean printDots = false;
    public static boolean doPure = false;
    private static int doDumpHeader = 0;
    public static int tryBSConstructed = 0;
    public static int tryOSConstructed = 0;
    public static boolean extraOIDinfo = false;
    public static boolean doHexValues = false;
    public static boolean useStdin = false;
    private static int offset = 0;
    public static boolean pd = false;
    public static int noErrors;
    public static int noWarnings;
    public static PrintStream ps;
    public static dumpASN1OidList oidList;
    byte[] bytes;
    int bInd;

    public dumpASN1(byte[] bytes) throws IOException {
        this(bytes, offset);
        oidList = new dumpASN1OidList();
        noErrors = 0;
        noWarnings = 0;
    }

    public dumpASN1(byte[] bytes, int bytesIndex) {
        this.bytes = bytes;
        this.bInd = bytesIndex;
        if (pd) {
            ps.print("***Inside dumpASN1 constructor. bytesIndex:" + bytesIndex);
        }
    }

    public int printASN1() throws IOException {
        int retCode = this.printASN1(0, 177545L, false);
        if (!doPure) {
            ps.print("\n" + noWarnings + " warning" + (noWarnings != 1 ? "s" : "") + ", " + noErrors + " error" + (noErrors != 1 ? "s" : "") + ".");
        }
        return retCode;
    }

    public int printASN1(int level, long length, boolean isIndefinite) throws IOException {
        int lastPos = this.bInd;
        int seenEnum = 0;
        boolean seenEOC = false;
        boolean index = false;
        String printLen = "";
        String printPos = "";
        if (pd) {
            ps.print("\n-> Entering Steam's printASN1.  level:" + level + " length:" + length);
        }
        if (length == 0L && !isIndefinite) {
            return 0;
        }
        while (this.bInd < this.bytes.length) {
            if (pd) {
                ps.print("\n Stream's printASN1: getting an dumpASN1Atom.  level:" + level + " bInd:" + this.bInd);
            }
            dumpASN1Atom item = new dumpASN1Atom(this.bytes, this.bInd);
            this.bInd = item.getByteIndex();
            if (pd) {
                ps.print("\n Stream's printASN1: back from getting an dumpASN1Atom.  level:" + level + " bInd:" + this.bInd);
            }
            if (length == 177545L && !item.indefinite) {
                length = (long)item.headerSize + item.length;
            }
            if (seenEnum != 0) {
                --seenEnum;
            }
            if (item.tag == 10) {
                seenEnum = 2;
            }
            if (doDumpHeader > 0) {
                this.dumpHeader(item);
            }
            if (!doPure) {
                boolean printIt;
                if (item.indefinite) {
                    printIt = true;
                    printLen = "NDEF";
                } else if ((item.id | item.tag) == 0) {
                    seenEOC = true;
                    printIt = false;
                } else {
                    printIt = true;
                    if (doHexValues) {
                        printLen = Long.toHexString(item.length).toUpperCase();
                        printLen = dumpASN1Atom.format(printLen, 4);
                    } else {
                        printLen = dumpASN1Atom.format(item.length, 4);
                    }
                }
                if (printIt) {
                    if (doHexValues) {
                        printPos = Integer.toHexString(lastPos).toUpperCase();
                        printPos = dumpASN1Atom.format(printPos, 4, '0');
                    } else {
                        printPos = dumpASN1Atom.format(lastPos, 4);
                    }
                    ps.print(printPos + " " + dumpASN1Atom.hexDigit(item.idOctet1) + " " + printLen + ": ");
                }
            }
            if (!seenEOC) {
                dumpASN1Atom.doIndent(level);
                item.printASN1Object(level, seenEnum);
                this.bInd = item.getByteIndex();
            }
            if (pd) {
                ps.print("\nStream's printASN1 back from item's printASN1Object. length: " + length + " lastPos: " + lastPos + "bInd:" + this.bInd);
            }
            length -= (long)(this.bInd - lastPos);
            lastPos = this.bInd;
            if (pd) {
                ps.print("\nUpdated.  Now                                        length: " + length + " lastPos: " + lastPos);
            }
            if (isIndefinite) {
                if (!seenEOC) continue;
                if (pd) {
                    ps.print("\n<- Exiting Stream's printASN1. **isIndefinite** level:" + level + " bInd:" + this.bInd + " length:" + length);
                }
                return 0;
            }
            if (length > 0L) continue;
            if (pd) {
                ps.print("\n<- Exiting Stream's printASN1.  level:" + level + " bInd:" + this.bInd + " length:" + length);
            }
            if (length < 0L) {
                return (int)(-length);
            }
            return 0;
        }
        return 0;
    }

    private void dumpHeader(dumpASN1Atom item) {
        int i;
        int extraLen = 24 - item.headerSize;
        if (!doPure) {
            ps.print("    ");
        }
        ps.print("<" + dumpASN1Atom.hexDigit((byte)item.header[0]));
        for (i = 1; i < item.headerSize; ++i) {
            ps.print(" " + dumpASN1Atom.hexDigit((byte)item.header[i]));
        }
        if (extraLen > 0 && doDumpHeader > 1) {
            if ((long)extraLen > item.length && !item.indefinite) {
                extraLen = (int)item.length;
            }
            for (i = 0; i < extraLen; ++i) {
                ps.print(" " + dumpASN1Atom.hexDigit(this.bytes[this.bInd + i]));
            }
        }
        ps.print(">\n");
    }

    public static void setOptions(String options) throws IOException {
        boolean optIsNum;
        int intVal = 0;
        boolean moreArgs = true;
        options = options.toUpperCase();
        try {
            intVal = Integer.valueOf(options);
            optIsNum = true;
        }
        catch (NumberFormatException e) {
            optIsNum = false;
        }
        if (optIsNum) {
            offset = intVal;
        } else {
            block12: for (int ind = 0; ind < options.length() && moreArgs; ++ind) {
                char ch = options.charAt(ind);
                switch (ch) {
                    case '-': {
                        moreArgs = false;
                        continue block12;
                    }
                    case 'B': {
                        ++tryBSConstructed;
                        continue block12;
                    }
                    case 'D': {
                        printDots = true;
                        continue block12;
                    }
                    case 'L': {
                        extraOIDinfo = true;
                        continue block12;
                    }
                    case 'H': {
                        ++doDumpHeader;
                        continue block12;
                    }
                    case 'O': {
                        ++tryOSConstructed;
                        continue block12;
                    }
                    case 'P': {
                        doPure = true;
                        continue block12;
                    }
                    case 'X': {
                        doHexValues = true;
                        continue block12;
                    }
                    default: {
                        throw new IOException("Unknown argument '" + ch + "'.\n");
                    }
                }
            }
        }
    }

    public int getByteIndex() {
        return this.bInd;
    }

    public void setPrintStream(PrintStream newps) {
        ps = newps;
    }

    public void test(String fileDir) throws IOException {
        Random r = new Random();
        int intR = r.nextInt(9999);
        System.out.print("\ndumpASN1.test.  Output in extension " + intR + "\n");
        String javaFN = fileDir + "javaASN1." + intR;
        String byteFN = fileDir + "byteASN1." + intR;
        String hexdFN = fileDir + "hexdASN1." + intR;
        HexDumpEncoder hd = new HexDumpEncoder();
        FileOutputStream fosh = new FileOutputStream(hexdFN);
        PrintStream ps = new PrintStream(fosh);
        ps.println("Encoding:");
        ps.println(hd.encodeBuffer(this.bytes));
        ps.close();
        FileOutputStream fosb = new FileOutputStream(byteFN);
        fosb.write(this.bytes);
        fosb.close();
        FileOutputStream fosj = new FileOutputStream(javaFN);
        this.setPrintStream(new PrintStream(fosj));
        int result = this.printASN1();
        fosj.close();
    }

    public static void main(String[] args) throws IOException {
        int argIndex = 0;
        if (args[argIndex].startsWith("-")) {
            dumpASN1.setOptions(args[argIndex].substring(1));
            ++argIndex;
        }
        FileInputStream fis = new FileInputStream(args[argIndex]);
        byte[] fileBytes = new byte[fis.available()];
        fis.read(fileBytes);
        dumpASN1 asn1s = new dumpASN1(fileBytes);
        asn1s.printASN1();
    }

    static {
        ps = System.out;
    }
}

