/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class SubjectKeyIdentifier
extends PKCSDerObject
implements EntityIdentifier,
Cloneable {
    private byte[] identifier;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SubjectKeyIdentifier";
    private volatile int cachedHashVal = 0;

    public SubjectKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier");
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", provider);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", (Object)der);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier", der, provider);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier", filename, new Boolean(base64));
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", parms);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SubjectKeyIdentifier result = new SubjectKeyIdentifier(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubjectKeyIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        byte[] identifier = ((SubjectKeyIdentifier)other).getIdentifier();
        if (this.identifier.length != identifier.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < identifier.length; ++i) {
            if (this.identifier[i] == identifier[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            this.cachedHashVal = 17;
            for (int i = 0; i < this.identifier.length; ++i) {
                this.cachedHashVal = 37 * this.cachedHashVal + this.identifier[i];
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.identifier == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "SubjectKeyIdentifier not specified.");
            }
            throw new IOException("SubjectKeyIdentifier not specified.");
        }
        if (this.identifier == null || this.identifier.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding identifier");
            }
            throw new IOException("error encoding identifier");
        }
        DerOutputStream tmpout = new DerOutputStream();
        tmpout.putOctetString(this.identifier);
        os.write(tmpout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getData().available() != 0) {
            this.identifier = encoding.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public synchronized void setIdentifier(byte[] identifier) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setIdentifier", (Object)identifier);
        }
        if (this.identifier != null) {
            if (debug != null) {
                debug.text(16384L, className, "setIdentifier", "Identifier byte array already set.");
            }
            throw new PKCSException("Identifier byte array already set.");
        }
        if (identifier == null || identifier.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setIdentifier", "Identifier byte array not specified.");
            }
            throw new IllegalArgumentException("Identifier byte array not specified.");
        }
        this.identifier = new byte[identifier.length];
        System.arraycopy(identifier, 0, this.identifier, 0, identifier.length);
        if (debug != null) {
            debug.exit(16384L, className, "setIdentifier");
        }
    }

    public byte[] getIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIdentifier");
        }
        if (this.identifier == null || this.identifier.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIdentifier_1", null);
            }
            return null;
        }
        byte[] identifier2 = new byte[this.identifier.length];
        System.arraycopy(this.identifier, 0, identifier2, 0, this.identifier.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIdentifier", identifier2);
        }
        return identifier2;
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 SubjectKeyIdentifier:\r\n";
        out = this.identifier != null ? out + hexDump.encodeBuffer(this.identifier) + "\r\n" : out + "null";
        return out;
    }
}

