/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.CORBALevel;
import com.ibm.idl.Comment;
import com.ibm.idl.IncludeEntry;
import com.ibm.idl.InvalidCharacter;
import com.ibm.idl.ParseException;
import com.ibm.idl.Parser;
import com.ibm.idl.ScannerData;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.Token;
import com.ibm.idl.Util;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

class Scanner {
    static final int Star = 0;
    static final int Plus = 1;
    static final int Dot = 2;
    static final int None = 3;
    private int BOL;
    private ScannerData data = new ScannerData();
    private Stack dataStack = new Stack();
    private Vector keywords = new Vector();
    private Vector openEndedKeywords = new Vector();
    private Vector wildcardKeywords = new Vector();
    private boolean verbose;
    boolean escapedOK = true;
    private boolean emitAll;
    private CORBALevel corbaLevel;
    private boolean useLatin1 = false;

    Scanner(IncludeEntry includeEntry, String[] stringArray, boolean bl, boolean bl2, CORBALevel cORBALevel, boolean bl3) throws IOException {
        this.useLatin1 = bl3;
        this.readFile(includeEntry);
        this.verbose = bl;
        this.emitAll = bl2;
        this.sortKeywords(stringArray);
        this.corbaLevel = cORBALevel;
    }

    void sortKeywords(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.wildcardAtEitherEnd(stringArray[i])) {
                this.openEndedKeywords.addElement(stringArray[i]);
                continue;
            }
            if (this.wildcardsInside(stringArray[i])) {
                this.wildcardKeywords.addElement(stringArray[i]);
                continue;
            }
            this.keywords.addElement(stringArray[i]);
        }
    }

    private boolean wildcardAtEitherEnd(String string) {
        return string.startsWith("*") || string.startsWith("+") || string.startsWith(".") || string.endsWith("*") || string.endsWith("+") || string.endsWith(".");
    }

    private boolean wildcardsInside(String string) {
        return string.indexOf("*") > 0 || string.indexOf("+") > 0 || string.indexOf(".") > 0;
    }

    boolean isLatin1Platform() {
        int n = 97;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            outputStreamWriter.write(n);
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray.length == 1 && byArray[0] == (byte)n;
    }

    void readFile(IncludeEntry includeEntry) throws IOException {
        String string = includeEntry.name();
        string = string.substring(1, string.length() - 1);
        this.readFile(includeEntry, string);
    }

    void readFile(IncludeEntry includeEntry, String string) throws IOException {
        this.data.fileEntry = includeEntry;
        this.data.filename = string;
        File file = new File(this.data.filename);
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = this.isLatin1Platform() || this.useLatin1 ? new InputStreamReader((InputStream)fileInputStream, "8859_1") : new InputStreamReader(fileInputStream);
        String string2 = System.getProperty("line.separator");
        this.data.fileBytes = new char[n + string2.length()];
        inputStreamReader.read(this.data.fileBytes, 0, n);
        inputStreamReader.close();
        fileInputStream.close();
        for (int i = 0; i < string2.length(); ++i) {
            this.data.fileBytes[n + i] = string2.charAt(i);
        }
        this.readChar();
    }

    Token getToken() throws IOException {
        Token token = null;
        String string = new String("");
        while (token == null) {
            try {
                this.data.oldIndex = this.data.fileIndex;
                this.data.oldLine = this.data.line;
                if (this.data.ch <= ' ') {
                    this.skipWhiteSpace();
                    continue;
                }
                if (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z' || this.data.ch == '_' || Character.isLetter(this.data.ch)) {
                    if (this.data.ch == 'L') {
                        this.readChar();
                        if (this.data.ch == '\'') {
                            token = this.getWideCharacter();
                            this.readChar();
                            continue;
                        }
                        if (this.data.ch == '\"') {
                            this.readWideChar();
                            token = new Token(207, this.getUntil('\"', true));
                            this.readChar();
                            continue;
                        }
                        this.unread(this.data.ch);
                        this.unread(this.data.ch);
                        this.readChar();
                        token = this.getString();
                        continue;
                    }
                    token = this.getString();
                    continue;
                }
                if (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch == '.') {
                    token = this.getNumber();
                    continue;
                }
                switch (this.data.ch) {
                    case ';': {
                        token = new Token(100);
                        break;
                    }
                    case '{': {
                        token = new Token(101);
                        break;
                    }
                    case '}': {
                        token = new Token(102);
                        break;
                    }
                    case ':': {
                        this.readChar();
                        if (this.data.ch == ':') {
                            this.readChar();
                            if (this.data.ch == ':') {
                                this.unread(this.data.ch);
                                this.unread(this.data.ch);
                                token = new Token(103);
                                break;
                            }
                            this.unread(this.data.ch);
                            token = new Token(124);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(103);
                        break;
                    }
                    case ',': {
                        token = new Token(104);
                        break;
                    }
                    case '=': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(130);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(105);
                        break;
                    }
                    case '+': {
                        token = new Token(106);
                        break;
                    }
                    case '-': {
                        token = new Token(107);
                        break;
                    }
                    case '(': {
                        token = new Token(108);
                        break;
                    }
                    case ')': {
                        token = new Token(109);
                        break;
                    }
                    case '<': {
                        this.readChar();
                        if (this.data.ch == '<') {
                            token = new Token(125);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(133);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(110);
                        break;
                    }
                    case '>': {
                        this.readChar();
                        if (this.data.ch == '>') {
                            token = new Token(126);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(132);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(111);
                        break;
                    }
                    case '[': {
                        token = new Token(112);
                        break;
                    }
                    case ']': {
                        token = new Token(113);
                        break;
                    }
                    case '\'': {
                        token = this.getCharacter();
                        break;
                    }
                    case '\"': {
                        this.readChar();
                        token = new Token(204, this.getUntil('\"', false));
                        break;
                    }
                    case '\\': {
                        this.readChar();
                        if (this.data.ch == '\n' || this.data.ch == '\r') {
                            token = null;
                            break;
                        }
                        token = new Token(116);
                        break;
                    }
                    case '|': {
                        this.readChar();
                        if (this.data.ch == '|') {
                            token = new Token(134);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(117);
                        break;
                    }
                    case '^': {
                        token = new Token(118);
                        break;
                    }
                    case '&': {
                        this.readChar();
                        if (this.data.ch == '&') {
                            token = new Token(135);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(119);
                        break;
                    }
                    case '*': {
                        token = new Token(120);
                        break;
                    }
                    case '/': {
                        this.readChar();
                        if (this.data.ch == '/') {
                            string = this.getLineComment();
                            break;
                        }
                        if (this.data.ch == '*') {
                            string = this.getBlockComment();
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(121);
                        break;
                    }
                    case '%': {
                        token = new Token(122);
                        break;
                    }
                    case '~': {
                        token = new Token(123);
                        break;
                    }
                    case '#': {
                        token = this.getDirective();
                        break;
                    }
                    case '!': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(131);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(129);
                        break;
                    }
                    case '?': {
                        try {
                            token = this.replaceTrigraph();
                            break;
                        }
                        catch (InvalidCharacter invalidCharacter) {
                            // empty catch block
                        }
                    }
                    default: {
                        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
                    }
                }
                this.readChar();
            }
            catch (EOFException eOFException) {
                token = new Token(999);
            }
        }
        token.comment = new Comment(string);
        return token;
    }

    void scanString(String string) {
        this.dataStack.push(this.data);
        this.data = new ScannerData(this.data);
        this.data.fileIndex = 0;
        this.data.oldIndex = 0;
        int n = string.length();
        this.data.fileBytes = new char[n];
        string.getChars(0, n, this.data.fileBytes, 0);
        this.data.macrodata = true;
        try {
            this.readChar();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void scanIncludedFile(IncludeEntry includeEntry, String string, boolean bl) throws IOException {
        this.dataStack.push(this.data);
        this.data = new ScannerData();
        this.data.indent = ((ScannerData)this.dataStack.peek()).indent + ' ';
        this.data.includeIsImport = bl;
        try {
            this.readFile(includeEntry, string);
            if (!this.emitAll && bl) {
                SymtabEntry.enteringInclude(includeEntry);
            }
            Parser.enteringInclude();
            if (this.verbose) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parsing", string));
            }
        }
        catch (IOException iOException) {
            this.data = (ScannerData)this.dataStack.pop();
            throw iOException;
        }
    }

    private void unread(char c) {
        char c2;
        --this.data.fileIndex;
        if (this.data.fileIndex > 0 && (c2 = (char)(this.data.fileBytes[this.data.fileIndex - 1] & 0xFF)) == '\n' && !this.data.macrodata) {
            --this.data.line;
        }
    }

    void readChar() throws IOException {
        if (this.data.fileIndex >= this.data.fileBytes.length) {
            if (this.dataStack.empty()) {
                throw new EOFException();
            }
            if (!this.data.macrodata) {
                if (!this.emitAll && this.data.includeIsImport) {
                    SymtabEntry.exitingInclude();
                }
                Parser.exitingInclude();
            }
            if (this.verbose && !this.data.macrodata) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parseDone", this.data.filename));
            }
            this.data = (ScannerData)this.dataStack.pop();
        } else {
            if (this.data.fileIndex > 0) {
                this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex - 1] & 0xFF);
                if (this.data.ch == '\n' && !this.data.macrodata) {
                    ++this.data.line;
                }
            }
            this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex] & 0xFF);
            ++this.data.fileIndex;
        }
    }

    void readWideChar() throws IOException {
        if (this.data.fileIndex >= this.data.fileBytes.length) {
            if (this.dataStack.empty()) {
                throw new EOFException();
            }
            if (!this.data.macrodata) {
                if (!this.emitAll && this.data.includeIsImport) {
                    SymtabEntry.exitingInclude();
                }
                Parser.exitingInclude();
            }
            if (this.verbose && !this.data.macrodata) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parseDone", this.data.filename));
            }
            this.data = (ScannerData)this.dataStack.pop();
        } else {
            if (this.data.fileIndex > 0) {
                this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex - 1] & 0xFF);
                if (this.data.ch == '\n' && !this.data.macrodata) {
                    ++this.data.line;
                }
            }
            this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex] & 0xFF);
            ++this.data.fileIndex;
        }
    }

    private Token getCharacter() throws IOException {
        Token token = null;
        this.readChar();
        if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == 'x') {
                char c = this.data.ch;
                int n = this.getNDigitHexNumber(2);
                return new Token(201, (char)n + "\\" + c + Integer.toString(n, 16));
            }
            if (this.data.ch == 'u') {
                char c = this.data.ch;
                int n = this.getNDigitHexNumber(4);
                return new Token(206, (char)n + "\\" + c + Integer.toString(n, 16));
            }
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                int n = this.get3DigitOctalNumber();
                return new Token(201, (char)n + "\\" + Integer.toString(n, 8));
            }
            return this.singleCharEscapeSequence();
        }
        token = new Token(201, "" + this.data.ch + this.data.ch);
        this.readChar();
        return token;
    }

    private Token getWideCharacter() throws IOException {
        Token token = null;
        this.readWideChar();
        if (this.data.ch == '\\') {
            this.readWideChar();
            if (this.data.ch == 'x' || this.data.ch == 'u') {
                char c = this.data.ch;
                int n = this.getNDigitHexNumber(c == 'x' ? 2 : 4);
                return new Token(206, (char)n + "\\" + c + Integer.toString(n, 16));
            }
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                int n = this.get3DigitOctalNumber();
                return new Token(206, (char)n + "\\" + Integer.toString(n, 8));
            }
            return this.singleCharEscapeSequence();
        }
        token = new Token(206, "" + this.data.ch + this.data.ch);
        this.readChar();
        return token;
    }

    private Token singleCharEscapeSequence() throws IOException {
        Token token;
        if (this.data.ch == 'n') {
            token = new Token(201, "\n\\n");
        } else if (this.data.ch == 't') {
            token = new Token(201, "\t\\t");
        } else if (this.data.ch == 'v') {
            token = new Token(201, "\u000b\\v");
        } else if (this.data.ch == 'b') {
            token = new Token(201, "\b\\b");
        } else if (this.data.ch == 'r') {
            token = new Token(201, "\r\\r");
        } else if (this.data.ch == 'f') {
            token = new Token(201, "\f\\f");
        } else if (this.data.ch == 'a') {
            token = new Token(201, "\u0007\\a");
        } else if (this.data.ch == '\\') {
            token = new Token(201, "\\\\\\");
        } else if (this.data.ch == '?') {
            token = new Token(201, "?\\?");
        } else if (this.data.ch == '\'') {
            token = new Token(201, "'\\'");
        } else if (this.data.ch == '\"') {
            token = new Token(201, "\"\\\"");
        } else {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        this.readChar();
        return token;
    }

    private Token singleWideCharEscapeSequence() throws IOException {
        Token token;
        if (this.data.ch == 'n') {
            token = new Token(206, "\n\\n");
        } else if (this.data.ch == 't') {
            token = new Token(206, "\t\\t");
        } else if (this.data.ch == 'v') {
            token = new Token(206, "\u000b\\v");
        } else if (this.data.ch == 'b') {
            token = new Token(206, "\b\\b");
        } else if (this.data.ch == 'r') {
            token = new Token(206, "\r\\r");
        } else if (this.data.ch == 'f') {
            token = new Token(206, "\f\\f");
        } else if (this.data.ch == 'a') {
            token = new Token(206, "\u0007\\a");
        } else if (this.data.ch == '\\') {
            token = new Token(206, "\\\\\\");
        } else if (this.data.ch == '?') {
            token = new Token(206, "?\\?");
        } else if (this.data.ch == '\'') {
            token = new Token(206, "'\\'");
        } else if (this.data.ch == '\"') {
            token = new Token(206, "\"\\\"");
        } else {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        this.readChar();
        return token;
    }

    private Token getString() throws IOException {
        String string = new String();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.data.ch == '_') {
            string = string + this.data.ch;
            this.readChar();
            if (this.escapedOK && this.data.ch == '_') {
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
        }
        while (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z' || this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch == '_' || Character.isLetter(this.data.ch)) {
            string = string + this.data.ch;
            this.readChar();
        }
        if (this.escapedOK && string.startsWith("_")) {
            string = string.substring(1);
            bl = true;
        } else {
            int n = 48;
            for (int i = 0; i <= n; ++i) {
                if (string.equals(Token.Keywords[i])) {
                    if (this.corbaLevel.lte(2.2f)) {
                        if (i > 35) {
                            bl2 |= this.escapedOK;
                            break;
                        }
                    } else if (this.corbaLevel.lte(2.3f)) {
                        if (i > 47) {
                            bl2 |= this.escapedOK;
                            break;
                        }
                    } else if (this.corbaLevel.lte(2.4f) && i > 48) {
                        bl2 |= this.escapedOK;
                        break;
                    }
                    return string.equals("TRUE") || string.equals("FALSE") ? new Token(200, string) : new Token(i, bl3);
                }
                if (!string.equalsIgnoreCase(Token.Keywords[i])) continue;
                bl2 |= true;
                break;
            }
        }
        string = this.getIdentifier(string);
        if (this.data.ch == '(') {
            this.readChar();
            return new Token(61, string, bl, bl2, bl3);
        }
        return new Token(60, string, bl, bl2, bl3);
    }

    private boolean matchesClosedWildKeyword(String string) {
        boolean bl = true;
        String string2 = string;
        Enumeration enumeration = this.wildcardKeywords.elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n = 3;
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), "*+.", true);
            if (!stringTokenizer.hasMoreTokens() || !string2.startsWith(string3 = stringTokenizer.nextToken())) continue;
            string2 = string2.substring(string3.length());
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n2;
                string3 = stringTokenizer.nextToken();
                if (string3.equals("*")) {
                    n = 0;
                    continue;
                }
                if (string3.equals("+")) {
                    n = 1;
                    continue;
                }
                if (string3.equals(".")) {
                    n = 2;
                    continue;
                }
                if (n == 0) {
                    n2 = string2.indexOf(string3);
                    if (n2 >= 0) {
                        string2 = string2.substring(n2 + string3.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n == 1) {
                    n2 = string2.indexOf(string3);
                    if (n2 > 0) {
                        string2 = string2.substring(n2 + string3.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n != 2) continue;
                n2 = string2.indexOf(string3);
                if (n2 == 1) {
                    string2 = string2.substring(1 + string3.length());
                    continue;
                }
                bl = false;
            }
            if (!bl || !string2.equals("")) continue;
            break;
        }
        return bl && string2.equals("");
    }

    private String matchesOpenWildcard(String string) {
        Enumeration enumeration = this.openEndedKeywords.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            int n = 3;
            boolean bl = true;
            String string3 = string;
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), "*+.", true);
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n2;
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("*")) {
                    n = 0;
                    continue;
                }
                if (string4.equals("+")) {
                    n = 1;
                    continue;
                }
                if (string4.equals(".")) {
                    n = 2;
                    continue;
                }
                if (n == 0) {
                    n = 3;
                    n2 = string3.lastIndexOf(string4);
                    if (n2 >= 0) {
                        string3 = this.blankOutMatch(string3, n2, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n == 1) {
                    n = 3;
                    n2 = string3.lastIndexOf(string4);
                    if (n2 > 0) {
                        string3 = this.blankOutMatch(string3, n2, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n == 2) {
                    n = 3;
                    n2 = string3.lastIndexOf(string4);
                    if (n2 == 1) {
                        string3 = this.blankOutMatch(string3, 1, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n != 3) continue;
                if (string3.startsWith(string4)) {
                    string3 = this.blankOutMatch(string3, 0, string4.length());
                    continue;
                }
                bl = false;
            }
            if (!(!bl || n == 0 || n == 1 && string3.lastIndexOf(32) != string3.length() - 1 || n == 2 && string3.lastIndexOf(32) == string3.length() - 2 || n == 3 && string3.lastIndexOf(32) == string3.length() - 1)) {
                bl = false;
            }
            if (!bl) continue;
            string2 = string2 + "_" + this.matchesOpenWildcard(string3.trim());
            break;
        }
        return string2;
    }

    private String blankOutMatch(String string, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.substring(0, n) + new String(cArray) + string.substring(n + n2);
    }

    private String getIdentifier(String string) {
        if (this.keywords.contains(string)) {
            string = '_' + string;
        } else {
            String string2 = "";
            string2 = this.matchesClosedWildKeyword(string) ? "_" : this.matchesOpenWildcard(string);
            string = string2 + string;
        }
        return string;
    }

    private Token getDirective() throws IOException {
        this.readChar();
        String string = new String();
        while (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z') {
            string = string + this.data.ch;
            this.readChar();
        }
        this.unread(this.data.ch);
        for (int i = 0; i < Token.Directives.length; ++i) {
            if (!string.equals(Token.Directives[i])) continue;
            Token token = new Token(300 + i, string);
            token.lineNumber = this.data.line;
            return token;
        }
        return new Token(313, string);
    }

    private Token getNumber() throws IOException {
        if (this.data.ch == '.') {
            return this.getFractionNoInteger();
        }
        if (this.data.ch == '0') {
            return this.isItHex();
        }
        return this.getInteger();
    }

    private Token getFractionNoInteger() throws IOException {
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            return this.getFraction(".");
        }
        return new Token(127);
    }

    private Token getFraction(String string) throws IOException {
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            string = string + this.data.ch;
            this.readChar();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        return new Token(203, string);
    }

    private Token getExponent(String string) throws IOException {
        this.readChar();
        if (this.data.ch == '+' || this.data.ch == '-') {
            string = string + this.data.ch;
            this.readChar();
        } else if (this.data.ch < '0' || this.data.ch > '9') {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(203, string);
    }

    private Token isItHex() throws IOException {
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction("0.");
        }
        if (this.data.ch == 'x' || this.data.ch == 'X') {
            return this.getHexNumber("0x");
        }
        if (this.data.ch == '8' || this.data.ch == '9') {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            return this.getOctalNumber();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent("0E");
        }
        return new Token(202, "0");
    }

    private Token getOctalNumber() throws IOException {
        String string = "0" + this.data.ch;
        this.readChar();
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            if (this.data.ch == '8' || this.data.ch == '9') {
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(202, string);
    }

    private Token getHexNumber(String string) throws IOException {
        this.readChar();
        if (!(this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F')) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        while (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F') {
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(202, string);
    }

    private int getNDigitHexNumber(int n) throws IOException {
        this.readChar();
        if (!this.isHexChar(this.data.ch)) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        String string = "" + this.data.ch;
        this.readChar();
        for (int i = 2; i <= n && this.isHexChar(this.data.ch); ++i) {
            string = string + this.data.ch;
            this.readChar();
        }
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean isHexChar(char c) {
        return this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F';
    }

    private int get3DigitOctalNumber() throws IOException {
        char c = this.data.ch;
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            string = string + this.data.ch;
            this.readChar();
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                string = string + this.data.ch;
                if (c > '3') {
                    throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), c);
                }
                this.readChar();
            }
        }
        int n = 0;
        try {
            n = Integer.parseInt(string, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), string.charAt(0));
        }
        return n;
    }

    private Token getInteger() throws IOException {
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction(string + '.');
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            while (this.data.ch >= '0' && this.data.ch <= '9') {
                string = string + this.data.ch;
                this.readChar();
                if (this.data.ch != '.') continue;
                this.readChar();
                return this.getFraction(string + '.');
            }
        }
        return new Token(202, string);
    }

    private Token replaceTrigraph() throws IOException {
        this.readChar();
        if (this.data.ch == '?') {
            this.readChar();
            if (this.data.ch == '=') {
                this.data.ch = (char)35;
            } else if (this.data.ch == '/') {
                this.data.ch = (char)92;
            } else if (this.data.ch == '\'') {
                this.data.ch = (char)94;
            } else if (this.data.ch == '(') {
                this.data.ch = (char)91;
            } else if (this.data.ch == ')') {
                this.data.ch = (char)93;
            } else if (this.data.ch == '!') {
                this.data.ch = (char)124;
            } else if (this.data.ch == '<') {
                this.data.ch = (char)123;
            } else if (this.data.ch == '>') {
                this.data.ch = (char)125;
            } else if (this.data.ch == '-') {
                this.data.ch = (char)126;
            } else {
                this.unread(this.data.ch);
                this.unread('?');
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            return this.getToken();
        }
        this.unread('?');
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
    }

    void skipWhiteSpace() throws IOException {
        while (this.data.ch <= ' ') {
            this.readChar();
        }
    }

    private void skipBlockComment() throws IOException {
        try {
            boolean bl = false;
            this.readChar();
            while (!bl) {
                while (this.data.ch != '*') {
                    this.readChar();
                }
                this.readChar();
                if (this.data.ch != '/') continue;
                bl = true;
            }
        }
        catch (EOFException eOFException) {
            ParseException.unclosedComment(this.data.filename);
            throw eOFException;
        }
    }

    void skipLineComment() throws IOException {
        while (this.data.ch != '\n') {
            this.readChar();
        }
    }

    private String getLineComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("/");
        while (this.data.ch != '\n') {
            if (this.data.ch != '\r') {
                stringBuffer.append(this.data.ch);
            }
            this.readChar();
        }
        return stringBuffer.toString();
    }

    private String getBlockComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("/*");
        try {
            boolean bl = false;
            this.readChar();
            stringBuffer.append(this.data.ch);
            while (!bl) {
                while (this.data.ch != '*') {
                    this.readChar();
                    stringBuffer.append(this.data.ch);
                }
                this.readChar();
                stringBuffer.append(this.data.ch);
                if (this.data.ch != '/') continue;
                bl = true;
            }
        }
        catch (EOFException eOFException) {
            ParseException.unclosedComment(this.data.filename);
            throw eOFException;
        }
        return stringBuffer.toString();
    }

    Token skipUntil(char c) throws IOException {
        while (this.data.ch != c) {
            if (this.data.ch == '/') {
                this.readChar();
                if (this.data.ch == '/') {
                    this.skipLineComment();
                    if (c != '\n') continue;
                    break;
                }
                if (this.data.ch != '*') continue;
                this.skipBlockComment();
                continue;
            }
            this.readChar();
        }
        return this.getToken();
    }

    String getUntil(char c) throws IOException {
        String string = "";
        while (this.data.ch != c) {
            string = this.appendToString(string, false, false, false, false);
        }
        return string;
    }

    String getUntil(char c, boolean bl) throws IOException {
        String string = "";
        while (this.data.ch != c) {
            string = this.appendToString(string, false, false, bl, true);
        }
        return string;
    }

    String getUntil(char c, char c2) throws IOException {
        String string = "";
        while (this.data.ch != c && this.data.ch != c2) {
            string = this.appendToString(string, false, false, false, false);
        }
        return string;
    }

    private String appendToString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (this.data.ch == '/') {
            this.readChar();
            if (this.data.ch == '/' && !bl4) {
                this.skipLineComment();
            } else if (this.data.ch == '*' && !bl4) {
                this.skipBlockComment();
            } else {
                string = string + '/';
            }
        } else if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == '\n') {
                this.readChar();
            } else if (this.data.ch == '\r') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                }
            } else {
                string = string + '\\';
                if (!bl4) {
                    string = string + this.data.ch;
                    this.readChar();
                } else if (this.data.ch == 'x') {
                    string = string + this.data.ch;
                    int n = this.getNDigitHexNumber(2);
                    String string2 = Integer.toString(n, 16);
                    if (string2.length() == 1) {
                        string = string + "0";
                    }
                    string = string + string2;
                } else if (this.data.ch == 'u') {
                    string = string + this.data.ch;
                    int n = this.getNDigitHexNumber(4);
                    String string3 = Integer.toString(n, 16);
                    if (string3.length() == 1) {
                        string = string + "000";
                    } else if (string3.length() == 2) {
                        string = string + "00";
                    } else if (string3.length() == 3) {
                        string = string + "0";
                    }
                    string = string + string3;
                } else if (this.data.ch >= '0' && this.data.ch <= '7') {
                    int n = this.get3DigitOctalNumber();
                    String string4 = Integer.toString(n, 8);
                    if (string4.length() == 1) {
                        string = string + "00";
                    } else if (string4.length() == 2) {
                        string = string + "0";
                    }
                    string = string + string4;
                } else {
                    string = string + this.data.ch;
                    this.readChar();
                }
            }
        } else {
            if (!bl2 && this.data.ch == '\"') {
                this.readChar();
                string = string + '\"';
                while (this.data.ch != '\"') {
                    string = this.appendToString(string, true, false, bl3, bl4);
                }
            } else if (!(bl || bl2 || this.data.ch != '(' || bl4)) {
                this.readChar();
                string = string + '(';
                while (this.data.ch != ')') {
                    string = this.appendToString(string, false, false, bl3, bl4);
                }
            } else if (!bl && this.data.ch == '\'' && !bl4) {
                this.readChar();
                string = string + "'";
                while (this.data.ch != '\'') {
                    string = this.appendToString(string, false, true, bl3, bl4);
                }
            }
            string = string + this.data.ch;
            if (bl3) {
                this.readWideChar();
            } else {
                this.readChar();
            }
        }
        return string;
    }

    String getStringToEOL() throws IOException {
        String string = new String();
        while (this.data.ch != '\n') {
            if (this.data.ch == '\\') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                    continue;
                }
                if (this.data.ch == '\r') {
                    this.readChar();
                    if (this.data.ch != '\n') continue;
                    this.readChar();
                    continue;
                }
                string = string + this.data.ch;
                this.readChar();
                continue;
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return string;
    }

    String scanStringToEOL() throws IOException {
        String string = new String();
        int n = 0;
        this.readChar();
        ++n;
        while (this.data.ch <= ' ') {
            this.readChar();
            ++n;
        }
        while (this.data.ch != '\n') {
            if (this.data.ch == '\\') {
                this.readChar();
                ++n;
                if (this.data.ch == '\n') {
                    this.readChar();
                    ++n;
                    continue;
                }
                if (this.data.ch == '\r') {
                    this.readChar();
                    ++n;
                    if (this.data.ch != '\n') continue;
                    this.readChar();
                    ++n;
                    continue;
                }
                string = string + this.data.ch;
                this.readChar();
                ++n;
                continue;
            }
            string = string + this.data.ch;
            this.readChar();
            ++n;
        }
        for (int i = n; i > 0; --i) {
            this.unread(' ');
        }
        return string + "\n";
    }

    String filename() {
        return this.data.filename;
    }

    IncludeEntry fileEntry() {
        return this.data.fileEntry;
    }

    int currentLineNumber() {
        return this.data.line;
    }

    int lastTokenLineNumber() {
        return this.data.oldLine;
    }

    String currentLine() {
        this.BOL = this.data.fileIndex - 1;
        try {
            if (this.data.fileBytes[this.BOL - 1] == '\r' && this.data.fileBytes[this.BOL] == '\n') {
                this.BOL -= 2;
            } else if (this.data.fileBytes[this.BOL] == '\n') {
                --this.BOL;
            }
            while (this.data.fileBytes[this.BOL] != '\n') {
                --this.BOL;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.BOL = -1;
        }
        ++this.BOL;
        int n = this.data.fileIndex - 1;
        try {
            while (this.data.fileBytes[n] != '\n' && this.data.fileBytes[n] != '\r') {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = this.data.fileBytes.length;
        }
        if (this.BOL < n) {
            return new String(this.data.fileBytes, this.BOL, n - this.BOL);
        }
        return "";
    }

    String lastTokenLine() {
        int n = this.data.fileIndex;
        this.data.fileIndex = this.data.oldIndex;
        String string = this.currentLine();
        this.data.fileIndex = n;
        return string;
    }

    int currentLinePosition() {
        return this.data.fileIndex - this.BOL;
    }

    int lastTokenLinePosition() {
        return this.data.oldIndex - this.BOL;
    }
}

