/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.CORBALevel;
import com.ibm.idl.CORBANotSupportedException;
import com.ibm.idl.InvalidArgument;
import com.ibm.idl.Util;
import com.ibm.som.cff.FileLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Arguments {
    public String file = null;
    public boolean verbose = false;
    public boolean keepOldFiles = false;
    public boolean emitAll = false;
    public Vector includePaths = new Vector();
    public Hashtable definedSymbols = new Hashtable();
    public boolean cppModule = false;
    public boolean missingInterfaces = false;
    public boolean versionRequest = false;
    public boolean useLatin1 = false;
    public boolean generateLatin1 = false;
    public CORBALevel corbaLevel = new CORBALevel();
    public boolean noWarn = false;

    public Arguments() {
        try {
            this.corbaLevel.set(2.4f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parseOtherArgs(String[] stringArray, Properties properties) throws InvalidArgument {
        if (stringArray.length > 0) {
            throw new InvalidArgument(stringArray[0]);
        }
    }

    void parseArgs(String[] stringArray) throws InvalidArgument {
        Object[] objectArray;
        String string;
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        try {
            for (n = 0; n < stringArray.length - 1; ++n) {
                if (stringArray[n].charAt(0) != '-') {
                    throw new InvalidArgument(stringArray[n]);
                }
                object = stringArray[n].substring(1).toLowerCase();
                if (((String)object).equals("i")) {
                    this.includePaths.addElement(stringArray[++n]);
                    continue;
                }
                if (((String)object).startsWith("i")) {
                    this.includePaths.addElement(stringArray[n].substring(2));
                    continue;
                }
                if (((String)object).equals("v") || ((String)object).equals("verbose")) {
                    this.verbose = true;
                    Util.setVerbose(this.verbose);
                    continue;
                }
                if (((String)object).equals("d")) {
                    this.definedSymbols.put(stringArray[++n], "");
                    continue;
                }
                if (((String)object).startsWith("d")) {
                    this.definedSymbols.put(stringArray[n].substring(2), "");
                    continue;
                }
                if (((String)object).equals("emitall")) {
                    this.emitAll = true;
                    continue;
                }
                if (((String)object).equals("keep")) {
                    this.keepOldFiles = true;
                    continue;
                }
                if (((String)object).equals("nowarn")) {
                    this.noWarn = true;
                    continue;
                }
                if (((String)object).equals("trace")) {
                    Runtime.getRuntime().traceMethodCalls(true);
                    continue;
                }
                if (((String)object).equals("cppmodule")) {
                    this.cppModule = true;
                    continue;
                }
                if (((String)object).equals("missinginterfaces")) {
                    this.missingInterfaces = true;
                    continue;
                }
                if (((String)object).equals("version")) {
                    this.versionRequest = true;
                    continue;
                }
                if (((String)object).equals("corba")) {
                    if (n + 1 >= stringArray.length) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    if ((string = stringArray[++n]).charAt(0) == '-') {
                        throw new InvalidArgument(stringArray[n - 1]);
                    }
                    try {
                        this.corbaLevel.set(stringArray[n]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    catch (CORBANotSupportedException cORBANotSupportedException) {
                        throw new InvalidArgument("InvalidArgument.corbaLevelNotSupported", stringArray[n]);
                    }
                }
                if (((String)object).equals("encoding")) {
                    if (n + 1 >= stringArray.length) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    if (!(string = stringArray[++n]).equalsIgnoreCase("ISO-8859-1")) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    this.useLatin1 = true;
                    continue;
                }
                if (((String)object).equals("javaencoding")) {
                    if (n + 1 >= stringArray.length) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    if (!(string = stringArray[++n]).equalsIgnoreCase("ISO-8859-1")) {
                        throw new InvalidArgument(stringArray[n]);
                    }
                    this.generateLatin1 = true;
                    continue;
                }
                vector.addElement(stringArray[n]);
                ++n;
                while (n < stringArray.length - 1 && stringArray[n].charAt(0) != '-') {
                    vector.addElement(stringArray[n++]);
                }
                --n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidArgument(stringArray[stringArray.length - 1]);
        }
        if (n == stringArray.length - 1) {
            if (stringArray[n].toLowerCase().equals("-version")) {
                this.versionRequest = true;
            } else {
                this.file = stringArray[n];
            }
        } else {
            throw new InvalidArgument();
        }
        object = new Properties();
        string = "idl.config";
        try {
            objectArray = FileLocator.getFileFromClassLoader(string, false);
            if (objectArray != null) {
                ((Properties)object).load((InputStream)objectArray);
                this.addIncludePaths((Properties)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = new String[]{};
        }
        this.parseOtherArgs((String[])objectArray, (Properties)object);
    }

    private void addIncludePaths(Properties properties) {
        String string = properties.getProperty("includes");
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            int n = -string2.length();
            do {
                if ((n = (string = string.substring(n + string2.length())).indexOf(string2)) < 0) {
                    n = string.length();
                }
                this.includePaths.addElement(string.substring(0, n));
            } while (n != string.length());
        }
    }
}

