/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.DataValueReader;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.IIOPOutputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.Serializable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class ObjectArraySerializer
extends ArraySerializer {
    private static String CLASS = ObjectArraySerializer.class.getName();
    private static ObjectArraySerializer instance = new ObjectArraySerializer();

    private ObjectArraySerializer() {
        this.vTag = (byte)-128;
    }

    public static ObjectArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        encoderOutputStream.write_longInVarint(n);
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            boolean bl;
            IIOPOutputStream iIOPOutputStream;
            Object object2;
            Object object3 = objectArray[i];
            if (object3 == null) {
                encoderOutputStream.write_octet((byte)113);
                continue;
            }
            Class<?> clazz = object3.getClass();
            ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
            if (objectStreamClass2.isValueType(encoderOutputStream)) {
                encoderOutputStream.write_octet((byte)110);
                object2 = null;
                try {
                    object2 = encoderOutputStream.fastWriteVal((Serializable)object3);
                }
                catch (ClassCastException classCastException) {
                    if (object3 instanceof Serializable) {
                        throw classCastException;
                    }
                    Trc.ffdc(classCastException, CLASS, "write:83");
                    Utility.throwNotSerializableForCorba(object3.getClass().getName());
                }
                if (object2 != EncoderOutputStream.PENDING_WRITE) continue;
                iIOPOutputStream = this.getIIOPOutputStream(encoderOutputStream);
                iIOPOutputStream.addRecursionBreak();
                bl = encoderOutputStream.getPrevMustChunk();
                serializable = encoderOutputStream.getCurrentObject();
                iIOPOutputStream.simpleWriteObjectLoop(serializable);
                encoderOutputStream.postFastWriteVal(bl);
                continue;
            }
            if (objectStreamClass2.isAbstractInterface(encoderOutputStream)) {
                encoderOutputStream.write_octet((byte)111);
                object2 = encoderOutputStream.fast_write_abstract_interface(object3);
                if (object2 != EncoderOutputStream.PENDING_WRITE) continue;
                iIOPOutputStream = this.getIIOPOutputStream(encoderOutputStream);
                iIOPOutputStream.addRecursionBreak();
                bl = encoderOutputStream.getPrevMustChunk();
                serializable = encoderOutputStream.getCurrentObject();
                iIOPOutputStream.simpleWriteObjectLoop(serializable);
                encoderOutputStream.postFastWriteVal(bl);
                continue;
            }
            if (objectStreamClass2.isAny()) {
                encoderOutputStream.fast_writeAnyOpt(object);
                continue;
            }
            throw new MARSHAL("Unknown array type " + objectStreamClass2.forClass().getName(), 1229125817, CompletionStatus.COMPLETED_NO);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object objectArray, ObjectStreamClass objectStreamClass) throws IOException {
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        int n = encoderInputStream.read_longInVarint();
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(Object[].class, n);
        Object[] objectArray2 = null;
        if (objectArray == null) {
            objectArray = new Object[n];
            encoderInputStream.addToValueCache(objectArray);
        }
        try {
            objectArray2 = objectArray;
            for (int i = 0; i < n; ++i) {
                int n2;
                boolean bl;
                IIOPInputStream iIOPInputStream2;
                Object object;
                byte by = encoderInputStream.read_octet();
                if (by == 113) {
                    objectArray2[i] = null;
                    continue;
                }
                if (by == 110) {
                    object = encoderInputStream.fast_read_value();
                    if (object == DataValueReader.PENDING_READ) {
                        iIOPInputStream2 = this.getIIOPInputStream(encoderInputStream);
                        bl = encoderInputStream.getPrevIsChunked();
                        n2 = encoderInputStream.getValueIndirection();
                        iIOPInputStream2.addRecursionBreak();
                        object = iIOPInputStream2.simpleReadObjectLoop(object);
                        object = iIOPInputStream2.doPostReadProcessing(object, bl, n2);
                    }
                    objectArray2[i] = object;
                    continue;
                }
                if (by == 111) {
                    object = encoderInputStream.fast_read_abstract_interface();
                    if (object == DataValueReader.PENDING_READ) {
                        iIOPInputStream2 = this.getIIOPInputStream(encoderInputStream);
                        bl = encoderInputStream.getPrevIsChunked();
                        n2 = encoderInputStream.getValueIndirection();
                        iIOPInputStream2.addRecursionBreak();
                        object = iIOPInputStream2.simpleReadObjectLoop(object);
                        object = iIOPInputStream2.doPostReadProcessing(object, bl, n2);
                    }
                    objectArray2[i] = object;
                    continue;
                }
                objectArray2[i] = object = encoderInputStream.fast_readAnyOpt();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException(classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
        iIOPInputStream.decrementDepth();
        return objectArray2;
    }
}

