/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.Transport;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.rmi.Profile;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportInterface;
import com.ibm.rmi.transport.ConnectionTableImpl;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransportManager
implements ORBForTransports,
TransportInterface {
    private static final String CLASS = TransportManager.class.getName();
    private Transport theTransport = null;
    private GIOPImpl theGIOPImpl = null;
    private ORB theORB = null;
    private AtomicBoolean serverHasBeenInitialized = new AtomicBoolean(false);
    private AtomicBoolean serverInitStarted = new AtomicBoolean(false);

    public TransportManager(ORB oRB, GIOPImpl gIOPImpl) {
        this.theGIOPImpl = gIOPImpl;
        this.theORB = oRB;
    }

    @Override
    public Connection getConnection(IOR iOR, ClientDelegate clientDelegate, String string) {
        return this.get((Profile)iOR.getProfile(), clientDelegate, string);
    }

    @Override
    public Connection get(Profile profile, ClientSubcontract clientSubcontract, String string) {
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "before calling Transport.getConnection", CLASS, "get:95");
        }
        ORBConnection oRBConnection = this.theTransport.getConnection(profile, string, clientSubcontract);
        Connection connection = (Connection)oRBConnection;
        if (profile != null) {
            int n = profile.getPartnerVersion();
            connection.setPartnerVersion((short)(n >>> 16), (short)(n & 0xFFFF), profile.getPartnerExtended());
        }
        return connection;
    }

    public void setTransport(Transport transport) {
        this.theTransport = transport;
    }

    @Override
    public ORBConnection createORBConnection() {
        Connection connection = new Connection(this.theORB, this.theGIOPImpl, false);
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, " created " + connection, CLASS, "createORBConnection:123");
        }
        return connection;
    }

    @Override
    public ORBConnection createORBConnectionForServer() {
        Connection connection = new Connection(this.theORB, this.theGIOPImpl, true);
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, " created " + connection, CLASS, "createORBConnectionForServer:138");
        }
        return connection;
    }

    @Override
    public void initTransports() {
        if (this.serverInitStarted.get() && this.serverHasBeenInitialized.get()) {
            return;
        }
        if (this.serverInitStarted.compareAndSet(false, true)) {
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "before calling Transport.initTransports", CLASS, "initTransports:154");
            }
            try {
                this.theTransport.initTransports();
                this.serverHasBeenInitialized.set(true);
            }
            finally {
                if (!this.serverHasBeenInitialized.get()) {
                    this.serverInitStarted.set(false);
                }
            }
        }
    }

    @Override
    public Profile getServerIIOPProfile() {
        this.initTransports();
        return (Profile)this.theTransport.getIIOPProfile();
    }

    @Override
    public String getProperty(String string) {
        return this.theORB.getProperty(string);
    }

    @Override
    public void createListener(int n) {
        this.theTransport.createListener(n);
    }

    @Override
    public void destroyListener(int n) {
        this.theTransport.destroyListener(n);
    }

    @Override
    public void shutdown() {
        this.theTransport.shutdown();
    }

    @Override
    public String getHostIPAddress(String string) {
        return this.theTransport.getHostIPAddress(string);
    }

    public String getLocalHost() {
        return this.theTransport.getLocalHost();
    }

    @Override
    public void setTransportData(Object object) {
        this.theTransport.setTransportData(object);
    }

    @Override
    public Object getTransportData() {
        return this.theTransport.getTransportData();
    }

    @Override
    public int getConnectTimeout() {
        return this.theORB.getConnectTimeout();
    }

    @Override
    public String getUserSpecifiedLocalHost() {
        return this.theORB.getUserSpecifiedLocalHost();
    }

    Transport getTheTransport() {
        return this.theTransport;
    }

    public ConnectionTableImpl getConnectionTable() {
        if (this.theTransport instanceof TransportBase) {
            TransportBase transportBase = (TransportBase)this.theTransport;
            return (ConnectionTableImpl)transportBase.getConnectionTable();
        }
        return null;
    }
}

