/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.KrbException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosTicket
implements Destroyable,
Refreshable,
Serializable {
    private static final long serialVersionUID = 7395334370157380539L;
    private static int FORWARDABLE_TICKET_FLAG = 1;
    private static int FORWARDED_TICKET_FLAG = 2;
    private static int PROXIABLE_TICKET_FLAG = 3;
    private static int PROXY_TICKET_FLAG = 4;
    private static int POSTDATED_TICKET_FLAG = 6;
    private static int RENEWABLE_TICKET_FLAG = 8;
    private static int INITIAL_TICKET_FLAG = 9;
    private static int NUM_FLAGS = 32;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;
    KerberosTicket proxy = null;
    private transient boolean destroyed = false;
    transient KerberosPrincipal clientAlias = null;
    transient KerberosPrincipal serverAlias = null;

    public KerberosTicket(byte[] asn1Encoding, KerberosPrincipal client, KerberosPrincipal server, byte[] sessionKey, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] clientAddresses) {
        this.init(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
    }

    private void init(byte[] asn1Encoding, KerberosPrincipal client, KerberosPrincipal server, byte[] sessionKey, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] clientAddresses) {
        if (asn1Encoding == null) {
            throw new IllegalArgumentException("ASN.1 encoding of ticket cannot be null");
        }
        this.asn1Encoding = asn1Encoding;
        if (client == null) {
            throw new IllegalArgumentException("Client name in ticket cannot be null");
        }
        this.client = client;
        if (server == null) {
            throw new IllegalArgumentException("Server name in ticket cannot be null");
        }
        this.server = server;
        if (sessionKey == null) {
            throw new IllegalArgumentException("Session key for ticket cannot be null");
        }
        this.sessionKey = new KeyImpl(sessionKey, keyType);
        if (flags != null) {
            if (flags.length >= NUM_FLAGS) {
                this.flags = (boolean[])flags.clone();
            } else {
                this.flags = new boolean[NUM_FLAGS];
                for (int i = 0; i < flags.length; ++i) {
                    this.flags[i] = flags[i];
                }
            }
        } else {
            this.flags = new boolean[NUM_FLAGS];
        }
        if (this.flags[RENEWABLE_TICKET_FLAG]) {
            if (renewTill == null) {
                throw new IllegalArgumentException("The renewable period end time cannot be null for renewable tickets.");
            }
            this.renewTill = renewTill;
        }
        this.authTime = authTime;
        Date date = this.startTime = startTime != null ? startTime : authTime;
        if (endTime == null) {
            throw new IllegalArgumentException("End time for ticket validity cannot be null");
        }
        this.endTime = endTime;
        if (clientAddresses != null) {
            this.clientAddresses = (InetAddress[])clientAddresses.clone();
        }
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public final SecretKey getSessionKey() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey;
    }

    public final int getSessionKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey.getKeyType();
    }

    public final boolean isForwardable() {
        return this.flags[FORWARDABLE_TICKET_FLAG];
    }

    public final boolean isForwarded() {
        return this.flags[FORWARDED_TICKET_FLAG];
    }

    public final boolean isProxiable() {
        return this.flags[PROXIABLE_TICKET_FLAG];
    }

    public final boolean isProxy() {
        return this.flags[PROXY_TICKET_FLAG];
    }

    public final boolean isPostdated() {
        return this.flags[POSTDATED_TICKET_FLAG];
    }

    public final boolean isRenewable() {
        return this.flags[RENEWABLE_TICKET_FLAG];
    }

    public final boolean isInitial() {
        return this.flags[INITIAL_TICKET_FLAG];
    }

    public final boolean[] getFlags() {
        return this.flags == null ? null : (boolean[])this.flags.clone();
    }

    public final Date getAuthTime() {
        return this.authTime;
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final Date getRenewTill() {
        return this.renewTill;
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return (byte[])this.asn1Encoding.clone();
    }

    @Override
    public boolean isCurrent() {
        return System.currentTimeMillis() <= this.getEndTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        if (this.destroyed) {
            throw new RefreshFailedException("A destroyed ticket cannot be renewd.");
        }
        if (!this.isRenewable()) {
            throw new RefreshFailedException("This ticket is not renewable");
        }
        if (System.currentTimeMillis() > this.getRenewTill().getTime()) {
            throw new RefreshFailedException("This ticket is past its last renewal time.");
        }
        Throwable e = null;
        Credentials krb5Creds = null;
        try {
            krb5Creds = new Credentials(this.asn1Encoding, this.client.toString(), this.clientAlias != null ? this.clientAlias.getName() : null, this.server.toString(), this.serverAlias != null ? this.serverAlias.getName() : null, this.sessionKey.getEncoded(), this.sessionKey.getKeyType(), this.flags, this.authTime, this.startTime, this.endTime, this.renewTill, this.clientAddresses);
            krb5Creds = krb5Creds.renew();
        }
        catch (KrbException krbException) {
            e = krbException;
        }
        catch (IOException ioException) {
            e = ioException;
        }
        if (e != null) {
            RefreshFailedException rfException = new RefreshFailedException("Failed to renew Kerberos Ticket for client " + this.client + " and server " + this.server + " - " + e.getMessage());
            throw rfException;
        }
        KerberosTicket kerberosTicket = this;
        synchronized (kerberosTicket) {
            try {
                this.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            this.init(krb5Creds.getEncoded(), new KerberosPrincipal(krb5Creds.getClient().getName()), new KerberosPrincipal(krb5Creds.getServer().getName()), krb5Creds.getSessionKey().getBytes(), krb5Creds.getSessionKey().getEType(), krb5Creds.getFlags(), krb5Creds.getAuthTime(), krb5Creds.getStartTime(), krb5Creds.getEndTime(), krb5Creds.getRenewTill(), krb5Creds.getClientAddresses());
            this.destroyed = false;
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.asn1Encoding, (byte)0);
            this.client = null;
            this.server = null;
            this.sessionKey.destroy();
            this.flags = null;
            this.authTime = null;
            this.startTime = null;
            this.endTime = null;
            this.renewTill = null;
            this.clientAddresses = null;
            this.destroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        if (this.destroyed) {
            return "Destroyed KerberosTicket";
        }
        StringBuffer caddrBuf = new StringBuffer();
        if (this.clientAddresses != null) {
            for (int i = 0; i < this.clientAddresses.length; ++i) {
                caddrBuf.append("clientAddresses[" + i + "] = " + this.clientAddresses[i].toString());
            }
        }
        return "Ticket (hex) = \n" + new HexDumpEncoder().encodeBuffer(this.asn1Encoding) + "\nClient Principal = " + this.client.toString() + "\nServer Principal = " + this.server.toString() + "\nSession Key = " + this.sessionKey.toString() + "\nForwardable Ticket " + this.flags[FORWARDABLE_TICKET_FLAG] + "\nForwarded Ticket " + this.flags[FORWARDED_TICKET_FLAG] + "\nProxiable Ticket " + this.flags[PROXIABLE_TICKET_FLAG] + "\nProxy Ticket " + this.flags[PROXY_TICKET_FLAG] + "\nPostdated Ticket " + this.flags[POSTDATED_TICKET_FLAG] + "\nRenewable Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\nInitial Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\nAuth Time = " + String.valueOf(this.authTime) + "\nStart Time = " + String.valueOf(this.startTime) + "\nEnd Time = " + this.endTime.toString() + "\nRenew Till = " + String.valueOf(this.renewTill) + "\nClient Addresses " + (this.clientAddresses == null ? " Null " : caddrBuf.toString() + (this.proxy == null ? "" : "\nwith a proxy ticket") + "\n");
    }

    public int hashCode() {
        int result = 17;
        if (this.isDestroyed()) {
            return result;
        }
        result = result * 37 + Arrays.hashCode(this.getEncoded());
        result = result * 37 + this.endTime.hashCode();
        result = result * 37 + this.client.hashCode();
        result = result * 37 + this.server.hashCode();
        result = result * 37 + this.sessionKey.hashCode();
        if (this.authTime != null) {
            result = result * 37 + this.authTime.hashCode();
        }
        if (this.startTime != null) {
            result = result * 37 + this.startTime.hashCode();
        }
        if (this.renewTill != null) {
            result = result * 37 + this.renewTill.hashCode();
        }
        result = result * 37 + Arrays.hashCode(this.clientAddresses);
        if (this.proxy != null) {
            result = result * 37 + this.proxy.hashCode();
        }
        return result * 37 + Arrays.hashCode(this.flags);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KerberosTicket)) {
            return false;
        }
        KerberosTicket otherTicket = (KerberosTicket)other;
        if (this.isDestroyed() || otherTicket.isDestroyed()) {
            return false;
        }
        if (!(Arrays.equals(this.getEncoded(), otherTicket.getEncoded()) && this.endTime.equals(otherTicket.getEndTime()) && this.server.equals(otherTicket.getServer()) && this.client.equals(otherTicket.getClient()) && this.sessionKey.equals(otherTicket.getSessionKey()) && Arrays.equals(this.clientAddresses, otherTicket.getClientAddresses()) && Arrays.equals(this.flags, otherTicket.getFlags()))) {
            return false;
        }
        if (this.authTime == null ? otherTicket.getAuthTime() != null : !this.authTime.equals(otherTicket.getAuthTime())) {
            return false;
        }
        if (this.startTime == null ? otherTicket.getStartTime() != null : !this.startTime.equals(otherTicket.getStartTime())) {
            return false;
        }
        if (this.renewTill == null ? otherTicket.getRenewTill() != null : !this.renewTill.equals(otherTicket.getRenewTill())) {
            return false;
        }
        return Objects.equals(this.proxy, otherTicket.proxy);
    }
}

