/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.GenFileStream;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.AuxGen;
import com.ibm.idl.toJavaPortable.MethodGen;
import com.ibm.idl.toJavaPortable.Util;
import java.util.Hashtable;
import java.util.Vector;

public class ValueFactory
implements AuxGen {
    protected Hashtable symbolTable;
    protected SymtabEntry entry;
    protected GenFileStream stream;
    protected String factoryClass;
    protected String factoryType;

    @Override
    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        this.symbolTable = hashtable;
        this.entry = symtabEntry;
        this.init();
        if (this.hasFactoryMethods()) {
            this.openStream();
            if (this.stream == null) {
                return;
            }
            this.writeHeading();
            this.writeBody();
            this.writeClosing();
            this.closeStream();
        }
    }

    protected void init() {
        this.factoryClass = this.entry.name() + "ValueFactory";
        this.factoryType = Util.javaName(this.entry);
    }

    protected boolean hasFactoryMethods() {
        Vector vector = ((ValueEntry)this.entry).initializers();
        return vector != null && vector.size() > 0;
    }

    protected void openStream() {
        this.stream = Util.stream(this.entry, "ValueFactory.java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.entry, (short)0);
        Util.writeProlog(this.stream, this.stream.name());
        if (this.entry.comment() != null) {
            this.entry.comment().generate("", this.stream);
        }
        this.stream.println("public interface " + this.factoryClass + " extends org.omg.CORBA.portable.ValueFactory");
        this.stream.println('{');
    }

    protected void writeBody() {
        Vector vector = ((ValueEntry)this.entry).initializers();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                MethodEntry methodEntry = (MethodEntry)vector.elementAt(i);
                methodEntry.valueMethod(true);
                ((MethodGen)methodEntry.generator()).interfaceMethod(this.symbolTable, methodEntry, this.stream);
            }
        }
    }

    protected void writeClosing() {
        this.stream.println('}');
    }

    protected void closeStream() {
        this.stream.close();
    }
}

