/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.ibm.security.jgss.GSSManagerImpl;
import java.security.Provider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class GSSManager {
    private static GSSManagerImpl realManager = null;
    private static final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GSSManager getInstance() {
        Object object = mutex;
        synchronized (object) {
            if (realManager == null) {
                try {
                    realManager = new GSSManagerImpl();
                }
                catch (Exception exc) {
                    realManager = null;
                    System.err.println("*** ERROR creating real GSSManager ***");
                    exc.printStackTrace();
                }
            }
            return realManager;
        }
    }

    public abstract Oid[] getMechs();

    public abstract Oid[] getNamesForMech(Oid var1) throws GSSException;

    public abstract Oid[] getMechsForName(Oid var1);

    public abstract GSSName createName(String var1, Oid var2) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2) throws GSSException;

    public abstract GSSName createName(String var1, Oid var2, Oid var3) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2, Oid var3) throws GSSException;

    public abstract GSSCredential createCredential(int var1) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid var3, int var4) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid[] var3, int var4) throws GSSException;

    public abstract GSSContext createContext(GSSName var1, Oid var2, GSSCredential var3, int var4) throws GSSException;

    public abstract GSSContext createContext(GSSCredential var1) throws GSSException;

    public abstract GSSContext createContext(byte[] var1) throws GSSException;

    public abstract void addProviderAtFront(Provider var1, Oid var2) throws GSSException;

    public abstract void addProviderAtEnd(Provider var1, Oid var2) throws GSSException;
}

