/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.PooledWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.RefCountWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicBoolean;

public class WsByteBufferImpl
implements WsByteBuffer,
Externalizable {
    private static final long serialVersionUID = 3794216509672320032L;
    protected ByteBuffer oByteBuffer = null;
    public ByteBuffer oWsBBDirect = null;
    private static final String CLASS_NAME = "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl";
    protected AtomicBoolean booleanReleaseCalled = new AtomicBoolean(false);
    private WsByteBufferPoolManagerImpl oWsByteBufferPoolManager = null;
    private boolean isDirectPool = false;
    private boolean readOnly = false;
    private boolean trusted = false;
    private boolean removedFromLeakDetection = false;
    private String ownerID = null;
    private long lastAccessTime = 0L;
    private static final TraceComponent tc = Tr.register(WsByteBufferImpl.class, "WsByteBuffer", "com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");
    protected PooledWsByteBufferImpl wsBBRoot = null;
    protected RefCountWsByteBufferImpl wsBBRefRoot = null;
    protected static final int NOT_ACTIVATED = 0;
    protected static final int ACTIVATED = 1;
    protected int quickBufferAction = 0;
    private int GET_THRESHOLD = 1023;
    private int PUT_THRESHOLD = 2047;
    private int status = 1;

    public WsByteBufferImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Created WsByteBufferImpl");
        }
    }

    public PooledWsByteBufferImpl getWsBBRoot() {
        return this.wsBBRoot;
    }

    public void setWsBBRoot(PooledWsByteBufferImpl pooledWsByteBufferImpl) {
        this.wsBBRoot = pooledWsByteBufferImpl;
    }

    public RefCountWsByteBufferImpl getWsBBRefRoot() {
        return this.wsBBRefRoot;
    }

    public void setWsBBRefRoot(RefCountWsByteBufferImpl refCountWsByteBufferImpl) {
        this.wsBBRefRoot = refCountWsByteBufferImpl;
    }

    public byte[] array() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "array(): returns oByteBuffer.array()", this.oByteBuffer);
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.array();
    }

    public int arrayOffset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "arrayOffset(): returns oByteBuffer.arrayOffset()=" + this.oByteBuffer.arrayOffset());
        }
        return this.oByteBuffer.arrayOffset();
    }

    public WsByteBuffer compact() {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compact(): before oByteBuffer.compact()", this);
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.compact();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compact(): after oByteBuffer.compact()", this);
        }
        return this;
    }

    public int compareTo(Object object) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.compareTo(((WsByteBuffer)object).getWrappedByteBufferNonSafe());
    }

    public char getChar() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getChar();
    }

    public char getChar(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getChar(n);
    }

    public WsByteBuffer putChar(char c) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putChar(c);
        return this;
    }

    public WsByteBuffer putChar(int n, char c) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putChar(n, c);
        return this;
    }

    public WsByteBuffer putChar(char[] cArray) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.putChar(cArray, 0, cArray.length);
    }

    public WsByteBuffer putChar(char[] cArray, int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        if (n + n2 > cArray.length) {
            throw new IllegalArgumentException("Invalid Parameters: off=" + n + ", len=" + n2 + ", values.length=" + cArray.length);
        }
        for (int i = n; i < n + n2; ++i) {
            this.oByteBuffer.putChar(cArray[i]);
        }
        return this;
    }

    public double getDouble() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getDouble();
    }

    public double getDouble(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getDouble(n);
    }

    public WsByteBuffer putDouble(double d) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putDouble(d);
        return this;
    }

    public WsByteBuffer putDouble(int n, double d) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putDouble(n, d);
        return this;
    }

    public float getFloat() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getFloat();
    }

    public float getFloat(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getFloat(n);
    }

    public WsByteBuffer putFloat(float f) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putFloat(f);
        return this;
    }

    public WsByteBuffer putFloat(int n, float f) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putFloat(n, f);
        return this;
    }

    public int getInt() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getInt();
    }

    public int getInt(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getInt(n);
    }

    public WsByteBuffer putInt(int n) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putInt(n);
        return this;
    }

    public WsByteBuffer putInt(int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putInt(n, n2);
        return this;
    }

    public long getLong() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getLong();
    }

    public long getLong(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getLong(n);
    }

    public WsByteBuffer putLong(long l) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putLong(l);
        return this;
    }

    public WsByteBuffer putLong(int n, long l) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putLong(n, l);
        return this;
    }

    public short getShort() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getShort();
    }

    public short getShort(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getShort(n);
    }

    public WsByteBuffer putShort(short s) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putShort(s);
        return this;
    }

    public WsByteBuffer putShort(int n, short s) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putShort(n, s);
        return this;
    }

    public WsByteBuffer putString(String string) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(string.getBytes());
        return this;
    }

    public boolean hasArray() {
        return this.oByteBuffer.hasArray();
    }

    public ByteOrder order() {
        return this.oByteBuffer.order();
    }

    public WsByteBuffer order(ByteOrder byteOrder) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.order(byteOrder);
        return this;
    }

    public WsByteBuffer clear() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.clear();
        return this;
    }

    public int capacity() {
        return this.oByteBuffer.capacity();
    }

    public WsByteBuffer flip() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.flip();
        return this;
    }

    public void copyRangeToDirectBuffer(int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRangeToDirectBuffer(min,max) " + n + "," + n2);
        }
        int n3 = this.oWsBBDirect.position();
        int n4 = this.oWsBBDirect.limit();
        this.oWsBBDirect.limit(n2 + 1);
        this.oWsBBDirect.position(n);
        this.oWsBBDirect.put(this.oByteBuffer.array(), n + this.oByteBuffer.arrayOffset(), n2 - n + 1);
        this.oWsBBDirect.limit(n4);
        this.oWsBBDirect.position(n3);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyRangeToDirectBuffer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBufferAction(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferAction(newAction): " + n);
        }
        boolean bl = false;
        if (this.wsBBRoot == null) {
            this.wsBBRoot = new PooledWsByteBufferImpl();
        }
        Object object = this.wsBBRoot.actionAccess;
        synchronized (object) {
            if (n == 1) {
                if (!this.oByteBuffer.isDirect() && this.wsBBRoot.actionState == 0) {
                    this.wsBBRoot.actionState = 1;
                    this.quickBufferAction = 1;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "actionState set to COPY_WHEN_NEEDED_STATE1: " + this.wsBBRoot.actionState);
                    }
                    if (this.oWsBBDirect == null) {
                        this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
                    }
                    bl = true;
                }
            } else if (n == 2) {
                if ((this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) && this.wsBBRoot.readMin != -1 && this.wsBBRoot.readMax != -1) {
                    this.moveUpUsingGetMinMax(this.wsBBRoot.readMin, this.wsBBRoot.readMax, 0);
                }
                this.wsBBRoot.actionState = 4;
                this.quickBufferAction = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "actionState set to COPY_ALL_FINAL: " + this.wsBBRoot.actionState);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "setBufferAction returning true, exit point 2");
                }
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferAction returning: " + bl);
        }
        return bl;
    }

    public void moveDownUsingPutMinMax(int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "moveDownUsingPutMinMax(min,max) " + n + "," + n2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current putMin and putMax are: " + this.wsBBRoot.putMin + "," + this.wsBBRoot.putMax);
        }
        if (this.wsBBRoot.actionState == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "actionState set to COPY_WHEN_NEEDED_STATE2: " + this.wsBBRoot.actionState);
            }
            this.wsBBRoot.actionState = 2;
        }
        if (n >= this.wsBBRoot.putMin && n2 <= this.wsBBRoot.putMax || this.wsBBRoot.putMax == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (this.wsBBRoot.putMax == -1) {
                    Tr.debug(tc, "putMin/putMax are in initial state, set them to the new values");
                } else {
                    Tr.debug(tc, "new values are inside putMin/putMax, nothing will be done");
                }
            }
            if (this.wsBBRoot.putMax == -1) {
                this.wsBBRoot.putMin = n;
                this.wsBBRoot.putMax = n2;
                this.reduceReadMinMax(n, n2);
            }
        } else if (n2 < this.wsBBRoot.putMin - 1 || n > this.wsBBRoot.putMax + 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "new min/max completely outside putMin/putMax");
                Tr.debug(tc, "copy putMin/putMax to Direct buffer, then set putMin/putMax to new values");
            }
            boolean bl = false;
            if (this.wsBBRoot.readMin == -1 || this.wsBBRoot.readMin > n2 && this.wsBBRoot.readMin > this.wsBBRoot.putMax || this.wsBBRoot.readMax < n && this.wsBBRoot.readMax < this.wsBBRoot.putMin) {
                if (this.wsBBRoot.putMin > n) {
                    if (this.wsBBRoot.putMin - n2 <= this.PUT_THRESHOLD) {
                        this.wsBBRoot.putMin = n;
                        bl = true;
                    }
                } else if (n - this.wsBBRoot.putMax <= this.PUT_THRESHOLD) {
                    this.wsBBRoot.putMax = n2;
                    bl = true;
                }
            }
            if (!bl) {
                this.copyRangeToDirectBuffer(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
                this.wsBBRoot.putMin = n;
                this.wsBBRoot.putMax = n2;
                this.reduceReadMinMax(n, n2);
            }
        } else if (n2 <= this.wsBBRoot.putMax || n2 == this.wsBBRoot.putMin - 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "new min/max runs into putMin/putMax, set putMin to new value only");
            }
            this.wsBBRoot.putMin = n;
            this.reduceReadMinMax(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
        } else if (n >= this.wsBBRoot.putMin || n == this.wsBBRoot.putMax + 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "new min/max runs out from putMin/putMax, set putMax to new value only");
            }
            this.wsBBRoot.putMax = n2;
            this.reduceReadMinMax(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "new min/max contains putMin/putMax, set putMin/putMax to new values");
            }
            this.wsBBRoot.putMin = n;
            this.wsBBRoot.putMax = n2;
            this.reduceReadMinMax(n, n2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "moveDownUsingPutMinMax");
        }
    }

    public void copyRangeFromDirectBuffer(int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRangeFromDirectBuffer(min,max) " + n + "," + n2);
        }
        if (n > n2) {
            Exception exception = new Exception("minumum is greater than maximum");
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl.copyRangeFromDirectBuffer", "837", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: min > max");
            }
        } else {
            int n3 = this.oWsBBDirect.position();
            int n4 = this.oWsBBDirect.limit();
            this.oWsBBDirect.limit(n2 + 1);
            this.oWsBBDirect.position(n);
            this.oWsBBDirect.get(this.oByteBuffer.array(), n + this.oByteBuffer.arrayOffset(), n2 - n + 1);
            this.oWsBBDirect.limit(n4);
            this.oWsBBDirect.position(n3);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyRangeFromDirectBuffer");
        }
    }

    private void reduceReadMinMax(int n, int n2) {
        if (n <= this.wsBBRoot.readMin) {
            if (n2 >= this.wsBBRoot.readMax) {
                this.wsBBRoot.readMin = -1;
                this.wsBBRoot.readMax = -1;
            } else if (n2 >= this.wsBBRoot.readMin) {
                this.wsBBRoot.readMin = n2 + 1;
            }
        } else if (n2 > this.wsBBRoot.readMax && n <= this.wsBBRoot.readMax) {
            this.wsBBRoot.readMax = n - 1;
        }
    }

    public void moveUpUsingGetMinMax(int n, int n2, int n3) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "moveUpUsingGetMinMax(min,max) " + n + "," + n2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current getMin, getMax: " + this.wsBBRoot.getMin + "," + this.wsBBRoot.getMax + " actionState: " + this.wsBBRoot.actionState);
        }
        if (n3 == 0 && n2 - n < this.GET_THRESHOLD) {
            n2 = n + this.GET_THRESHOLD < this.limit() ? n + this.GET_THRESHOLD : this.limit() - 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded min,max: " + n + "," + n2);
            }
        }
        if (this.wsBBRoot.actionState == 1) {
            if (n2 < this.wsBBRoot.getMin || n > this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get is outside current getMin/getMax, so pull up data into NonDirect buffer");
                }
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMin = n;
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(n, n2);
            } else if (n2 <= this.wsBBRoot.getMax && n >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get is inside current getMin/getMax, nothing done");
                }
            } else if (n2 <= this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get runs into current getMin/getMax, pull up new data only");
                }
                n2 = this.wsBBRoot.getMin - 1;
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMin = n;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else if (n >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get runs out of current getMin/getMax, pull up new data only");
                }
                n = this.wsBBRoot.getMax + 1;
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else {
                this.copyRangeFromDirectBuffer(n, this.wsBBRoot.getMin - 1);
                this.copyRangeFromDirectBuffer(this.wsBBRoot.getMax + 1, n2);
                this.wsBBRoot.getMin = n;
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(n, n2);
            }
        } else if (this.wsBBRoot.actionState == 2) {
            if (this.wsBBRoot.putMax != -1) {
                boolean bl = false;
                if (n2 <= this.wsBBRoot.putMax && n >= this.wsBBRoot.putMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "new get is inside putMin/putMax, nothing done");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "moveUpUsingGetMinMax, exit point 1");
                    }
                    return;
                }
                if (n < this.wsBBRoot.putMin && n2 >= this.wsBBRoot.putMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "new get begins before putMin/putMax, move up to NonDirect buffer this beginning data");
                    }
                    this.moveUpUsingGetMinMax(n, this.wsBBRoot.putMin - 1, 1);
                    bl = true;
                }
                if (n2 > this.wsBBRoot.putMax && n <= this.wsBBRoot.putMax) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "new get ends after putMin/putMax, move up to NonDirect buffer this trailing data");
                    }
                    this.moveUpUsingGetMinMax(this.wsBBRoot.putMax + 1, n2, 1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "moveUpUsingGetMinMax, exit point 2");
                    }
                    return;
                }
                if (bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "moveUpUsingGetMinMax, exit point 3");
                    }
                    return;
                }
            }
            if (n2 <= this.wsBBRoot.getMax && n >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get is inside getMin/getMax, nothing done");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "moveUpUsingGetMinMax, exit point 4");
                }
                return;
            }
            if (n2 < this.wsBBRoot.getMin || n > this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get ends outside getMin/getMax, move up to NonDirect this data");
                }
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMin = n;
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(n, n2);
            } else if (n2 <= this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get runs into getMin/getMax, move up new data only");
                }
                n2 = this.wsBBRoot.getMin - 1;
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMin = n;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else if (n >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "new get runs out of getMin/getMax, move up new data only");
                }
                n = this.wsBBRoot.getMax + 1;
                this.copyRangeFromDirectBuffer(n, n2);
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else {
                this.copyRangeFromDirectBuffer(n, this.wsBBRoot.getMin - 1);
                this.copyRangeFromDirectBuffer(this.wsBBRoot.getMax + 1, n2);
                this.wsBBRoot.getMin = n;
                this.wsBBRoot.getMax = n2;
                this.reduceReadMinMax(n, n2);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "actionState is invalid, continuing on.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "moveUpUsingGetMinMax, exit point 5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get() quickBufferAction: " + this.quickBufferAction);
        }
        byte by = 0;
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 0) {
            by = this.oByteBuffer.get();
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n = this.oByteBuffer.position();
                    this.moveUpUsingGetMinMax(n, n, 0);
                    by = this.oByteBuffer.get();
                } else {
                    this.quickBufferAction = 0;
                    by = this.oByteBuffer.get();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get()");
        }
        return by;
    }

    public int position() {
        return this.oByteBuffer.position();
    }

    public WsByteBuffer position(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.position(n);
        return this;
    }

    public WsByteBuffer limit(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.limit(n);
        return this;
    }

    public int limit() {
        return this.oByteBuffer.limit();
    }

    public int remaining() {
        return this.oByteBuffer.remaining();
    }

    public WsByteBuffer mark() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.mark();
        return this;
    }

    public WsByteBuffer reset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.reset();
        return this;
    }

    public WsByteBuffer rewind() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.rewind();
        return this;
    }

    public boolean isReadOnly() {
        return this.oByteBuffer.isReadOnly();
    }

    public boolean hasRemaining() {
        return this.oByteBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer get(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get(byte[]) quickBufferAction: " + this.quickBufferAction);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.get(byArray);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n = this.oByteBuffer.position();
                    int n2 = n + byArray.length - 1;
                    if (n2 >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.get(byArray);
                    } else {
                        this.moveUpUsingGetMinMax(n, n2, 0);
                        this.oByteBuffer.get(byArray);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.get(byArray);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get(byte[])");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer get(byte[] byArray, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get(byte[] dst, int offset, int length) quickBufferAction: " + this.quickBufferAction);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.get(byArray, n, n2);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsBBRoot.actionState: " + this.wsBBRoot.actionState);
                }
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n3 = this.oByteBuffer.position();
                    int n4 = n3 + n2 - 1;
                    if (n4 >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.get(byArray, n, n2);
                    } else {
                        this.moveUpUsingGetMinMax(n3, n4, 0);
                        this.oByteBuffer.get(byArray, n, n2);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.get(byArray, n, n2);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get(byte[] dst, int offset, int length)");
        }
        return this;
    }

    public byte get(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.get(n);
    }

    public boolean isDirect() {
        return this.oByteBuffer.isDirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer put(byte by) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte) quickBufferAction: " + this.quickBufferAction);
        }
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(by);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n = this.oByteBuffer.position();
                    this.moveDownUsingPutMinMax(n, n);
                    this.oByteBuffer.put(by);
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(by);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "put(byte)");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer put(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte[]) quickBufferAction: " + this.quickBufferAction);
        }
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(byArray);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n = this.oByteBuffer.position();
                    int n2 = n + byArray.length - 1;
                    if (n2 >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.put(byArray);
                    } else {
                        this.moveDownUsingPutMinMax(n, n2);
                        this.oByteBuffer.put(byArray);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(byArray);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "put(byte[])");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer put(byte[] byArray, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte[] src, int offset, int length) quickBufferAction: " + this.quickBufferAction);
        }
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(byArray, n, n2);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int n3 = this.oByteBuffer.position();
                    int n4 = n3 + n2 - 1;
                    if (n4 >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.put(byArray, n, n2);
                    } else {
                        this.moveDownUsingPutMinMax(n3, n4);
                        this.oByteBuffer.put(byArray, n, n2);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(byArray, n, n2);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "put(byte[] src, int offset, int length)");
        }
        return this;
    }

    public WsByteBuffer put(int n, byte by) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(n, by);
        return this;
    }

    public WsByteBuffer put(ByteBuffer byteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(byteBuffer);
        return this;
    }

    public WsByteBuffer put(WsByteBuffer wsByteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(wsByteBuffer.getWrappedByteBuffer());
        return this;
    }

    public WsByteBuffer put(WsByteBuffer[] wsByteBufferArray) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            this.put(wsByteBufferArray[i]);
        }
        return this;
    }

    public ByteBuffer getWrappedByteBuffer() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.getWrappedByteBufferCommon(false);
    }

    public ByteBuffer getWrappedByteBufferNonSafe() {
        return this.getWrappedByteBufferCommon(true);
    }

    private ByteBuffer getWrappedByteBufferCommon(boolean bl) {
        if (!bl && this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer;
    }

    public WsByteBuffer duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "duplicate");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.duplicate(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not find pool manager, returning null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDuplicate(WsByteBufferImpl wsByteBufferImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDuplicate");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsByteBufferImpl.setReadOnly(true);
        }
        wsByteBufferImpl.setByteBufferNonSafe(this.oByteBuffer.duplicate());
        wsByteBufferImpl.quickBufferAction = this.quickBufferAction;
        if (!this.oByteBuffer.isDirect() && this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "buffer optomization on, duplicating shadow direct buffer");
                    }
                    int n = this.oWsBBDirect.position();
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    wsByteBufferImpl.setDirectShadowBuffer(this.oWsBBDirect.duplicate());
                    this.oWsBBDirect.position(n);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDuplicate");
        }
    }

    public WsByteBuffer slice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "slice");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.slice(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not find pool manager, returning null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlice(WsByteBufferImpl wsByteBufferImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSlice");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsByteBufferImpl.setReadOnly(true);
        }
        wsByteBufferImpl.setByteBufferNonSafe(this.oByteBuffer.slice());
        wsByteBufferImpl.quickBufferAction = this.quickBufferAction;
        if (!this.oByteBuffer.isDirect() && this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "buffer optomization on, slicing shadow direct buffer");
                    }
                    int n = this.oWsBBDirect.position();
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    wsByteBufferImpl.setDirectShadowBuffer(this.oWsBBDirect.slice());
                    this.oWsBBDirect.position(n);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSlice");
        }
    }

    public void resetReleaseCalled() {
        this.booleanReleaseCalled.set(false);
        this.readOnly = false;
    }

    public void printStackToDebug() {
        Throwable throwable = null;
        StackTraceElement[] stackTraceElementArray = null;
        throwable = new Throwable();
        stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length >= 7) {
            Tr.debug(tc, "Calling Stack Element[6]: " + stackTraceElementArray[6]);
        }
        if (stackTraceElementArray.length >= 6) {
            Tr.debug(tc, "Calling Stack Element[5]: " + stackTraceElementArray[5]);
        }
        if (stackTraceElementArray.length >= 5) {
            Tr.debug(tc, "Calling Stack Element[4]: " + stackTraceElementArray[4]);
        }
        if (stackTraceElementArray.length >= 4) {
            Tr.debug(tc, "Calling Stack Element[3]: " + stackTraceElementArray[3]);
        }
        if (stackTraceElementArray.length >= 3) {
            Tr.debug(tc, "Calling Stack Element[2]: " + stackTraceElementArray[2]);
        }
        if (stackTraceElementArray.length >= 2) {
            Tr.debug(tc, "Calling Stack Element[1]: " + stackTraceElementArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Throwable throwable = null;
        StackTraceElement[] stackTraceElementArray = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (stackTraceElementArray = (throwable = new Throwable()).getStackTrace()).length >= 2) {
            if (this.wsBBRoot == null || this.wsBBRoot.pool == null) {
                Tr.debug(tc, "BUFFER RELEASED: Calling Element: " + stackTraceElementArray[1] + " Main ID: none");
            } else {
                Tr.debug(tc, "BUFFER RELEASED: Calling Element: " + stackTraceElementArray[1] + " Main ID: " + this.wsBBRoot.getID());
            }
        }
        if (this.wsBBRoot == null || this.wsBBRoot.pool == null) {
            Object object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Released WsByteBuffer that was not allocated from the pool.It was either created from a wrapped buffer, or was larger than the pool.");
                object = new String();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    object = ((String)object).concat(stackTraceElementArray[i].toString());
                }
            }
            if (this.wsBBRefRoot != null) {
                object = this.wsBBRefRoot;
                synchronized (object) {
                    this.checkValidity();
                    --this.wsBBRefRoot.intReferenceCount;
                    if (this.wsBBRefRoot.intReferenceCount == 0) {
                        this.oWsByteBufferPoolManager.releasing(this.wsBBRefRoot.getWrappedByteBuffer());
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Marking wsBBRefRoot as released");
                        }
                        this.wsBBRefRoot.booleanReleaseCalled.set(true);
                    }
                    if (this.wsBBRefRoot != this) {
                        this.booleanReleaseCalled.set(true);
                    }
                }
            }
            return;
        }
        PooledWsByteBufferImpl pooledWsByteBufferImpl = this.wsBBRoot;
        synchronized (pooledWsByteBufferImpl) {
            this.checkValidity();
            if (this.oWsByteBufferPoolManager.getLeakDetectionInterval() > -1) {
                Object object = this.oWsByteBufferPoolManager.getLeakDetectionSyncObject();
                synchronized (object) {
                    this.booleanReleaseCalled.set(true);
                    --this.wsBBRoot.intReferenceCount;
                    this.releaseFromLeakDetection();
                    if (this.wsBBRoot.intReferenceCount == 0) {
                        this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                    }
                }
            } else {
                this.booleanReleaseCalled.set(true);
                --this.wsBBRoot.intReferenceCount;
                if (this.wsBBRoot.intReferenceCount == 0) {
                    this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                }
            }
        }
    }

    private void releaseFromLeakDetection() {
        if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
            this.wsBBRoot.removeWsByteBuffer(this);
        }
        if (this.ownerID != null) {
            this.wsBBRoot.removeOwner(this.ownerID);
        }
    }

    public void setIsDirectPool(boolean bl) {
        this.isDirectPool = bl;
    }

    public boolean getIsDirectPool() {
        return this.isDirectPool;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setOwnerID(String string) {
        this.ownerID = string;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String getOwnerID() {
        return this.ownerID;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setPoolManagerRef(WsByteBufferPoolManagerImpl wsByteBufferPoolManagerImpl) {
        this.oWsByteBufferPoolManager = wsByteBufferPoolManagerImpl;
        this.trusted = this.oWsByteBufferPoolManager.isTrustedUsers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setPoolManagerRef:  trusted set to: " + this.trusted);
        }
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.setByteBufferCommon(byteBuffer, false);
    }

    public void setByteBufferNonSafe(ByteBuffer byteBuffer) {
        this.setByteBufferCommon(byteBuffer, true);
        this.oByteBuffer = byteBuffer;
    }

    private void setByteBufferCommon(ByteBuffer byteBuffer, boolean bl) {
        if (!bl && this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer = byteBuffer;
    }

    public void setDirectShadowBuffer(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setDirectShadowBuffer");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oWsBBDirect = byteBuffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setDirectShadowBuffer");
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            String string = "none";
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                string = this.wsBBRoot.getID().toString();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to update a read only WsByteBuffer.\nWsByteBuffer: ID: " + string + "\nBuffer: " + this.oByteBuffer);
            }
            ReadOnlyBufferException readOnlyBufferException = new ReadOnlyBufferException();
            FFDCFilter.processException((Throwable)readOnlyBufferException, "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl.checkReadOnly", "1", this);
            throw readOnlyBufferException;
        }
    }

    private void checkValidity() {
        if (this.booleanReleaseCalled.get()) {
            String string = "none";
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                string = this.wsBBRoot.getID().toString();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to access WsByteBuffer that was already released.\nWsByteBuffer: ID: " + string + " Sub ID: " + this.oByteBuffer);
            }
            RuntimeException runtimeException = new RuntimeException("Invalid call to WsByteBuffer method.  Buffer has already been released.\nWsByteBuffer: ID: " + string + "\nBuffer: " + this.oByteBuffer);
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl.checkValidity", "1", this);
            throw runtimeException;
        }
        if (this.ownerID != null) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToDirectBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToDirectBuffer");
        }
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "copyToDirectBuffer, exit point 1");
            }
            return;
        }
        if (this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "bufferAction in STATE1, do not copy");
                    }
                    this.oWsBBDirect.limit(this.oByteBuffer.limit());
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "copyToDirectBuffer, exit point 2");
                    }
                    return;
                }
                if (this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "bufferAction in STATE2, copy only changed data");
                    }
                    if (this.wsBBRoot.putMin != -1 && this.wsBBRoot.putMax != -1) {
                        this.copyRangeToDirectBuffer(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
                        this.wsBBRoot.putMin = -1;
                        this.wsBBRoot.putMax = -1;
                    }
                    this.oWsBBDirect.limit(this.oByteBuffer.limit());
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "copyToDirectBuffer, exit point 3");
                    }
                    return;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "buffer optomization is off, copy all data");
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        int n = this.oByteBuffer.position();
        int n2 = this.oByteBuffer.limit();
        int n3 = this.oByteBuffer.arrayOffset();
        this.oWsBBDirect.limit(n2);
        this.oWsBBDirect.position(n);
        this.oWsBBDirect.put(this.oByteBuffer.array(), n + n3, n2 - n);
        this.oWsBBDirect.position(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToDirectBuffer, exit point 4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromDirectBuffer(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFromDirectBuffer");
        }
        int n2 = this.oWsBBDirect.position();
        int n3 = this.oByteBuffer.position();
        if (this.quickBufferAction == 0) {
            this.oWsBBDirect.position(n3);
            if (n == -1) {
                this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), this.oByteBuffer.remaining());
            } else if (n > 0) {
                this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), n);
            }
            this.oByteBuffer.position(n2);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "actionState: STATE1 - nothing will be copied");
                    }
                    this.oByteBuffer.position(n2);
                    int n4 = n3;
                    int n5 = n2 - 1;
                    if (this.wsBBRoot.readMin == -1 || n4 < this.wsBBRoot.readMin) {
                        this.wsBBRoot.readMin = n4;
                    }
                    if (this.wsBBRoot.readMax == -1 || n5 > this.wsBBRoot.readMax) {
                        this.wsBBRoot.readMax = n5;
                    }
                    if (this.wsBBRoot.getMax >= this.wsBBRoot.readMin && this.wsBBRoot.getMin <= this.wsBBRoot.readMax) {
                        this.wsBBRoot.getMax = -1;
                        this.wsBBRoot.getMin = -1;
                    }
                } else {
                    if (this.wsBBRoot.actionState == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "actionState: STATE2, first copy up any previously read data");
                        }
                        if (this.wsBBRoot.readMin != -1 && this.wsBBRoot.readMax != -1) {
                            this.moveUpUsingGetMinMax(this.wsBBRoot.readMin, this.wsBBRoot.readMax, 0);
                        }
                    }
                    this.wsBBRoot.actionState = 4;
                    this.quickBufferAction = 0;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "actionState: COPY_ALL_FINAL, copy currently read data to NonDirect buffer ");
                    }
                    this.oWsBBDirect.position(n3);
                    if (n == -1) {
                        this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), this.oByteBuffer.remaining());
                    } else if (n > 0) {
                        this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), n);
                    }
                    this.oByteBuffer.position(n2);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFromDirectBuffer");
        }
    }

    public void setParmsToDirectBuffer() {
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            return;
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        this.oWsBBDirect.limit(this.oByteBuffer.limit());
        this.oWsBBDirect.position(this.oByteBuffer.position());
    }

    public void setParmsFromDirectBuffer() {
        this.oByteBuffer.position(this.oWsBBDirect.position());
    }

    public int getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getType() returning: 0");
        }
        return 0;
    }

    public int getStatus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatus() returning: " + this.status);
        }
        return this.status;
    }

    public void setStatus(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setStatus(int) setting status to: " + n);
        }
        this.status = n;
    }

    public String toString() {
        if (null == this.oByteBuffer) {
            return "[null]";
        }
        return this.oByteBuffer.toString();
    }

    public void removeFromLeakDetection() {
        if (this.ownerID != null) {
            this.releaseFromLeakDetection();
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                this.wsBBRoot.pool.removeFromInUse(this.wsBBRoot);
            }
        }
        this.removedFromLeakDetection = true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (!this.removedFromLeakDetection && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Buffer being serialized but removeFromLeakDetection has not been called: " + this);
        }
        if (this.oByteBuffer.isDirect()) {
            objectOutput.writeObject("D");
        } else {
            objectOutput.writeObject("ND");
        }
        if (this.oByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            objectOutput.writeObject("B");
        } else {
            objectOutput.writeObject("L");
        }
        int n = this.oByteBuffer.position();
        int n2 = this.oByteBuffer.limit();
        this.oByteBuffer.position(0);
        this.oByteBuffer.limit(this.oByteBuffer.capacity());
        if (this.oByteBuffer.hasArray() && this.oByteBuffer.arrayOffset() == 0) {
            objectOutput.writeObject(this.oByteBuffer.array());
        } else {
            byte[] byArray = new byte[this.oByteBuffer.limit()];
            this.oByteBuffer.get(byArray);
            objectOutput.writeObject(byArray);
        }
        this.oByteBuffer.position(n);
        this.oByteBuffer.limit(n2);
        objectOutput.writeObject(Integer.toString(n));
        objectOutput.writeObject(Integer.toString(n2));
        if (this.readOnly) {
            objectOutput.writeObject("R");
        } else {
            objectOutput.writeObject("RW");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        String string2 = (String)objectInput.readObject();
        byte[] byArray = (byte[])objectInput.readObject();
        if (string.equals("ND")) {
            this.oByteBuffer = ByteBuffer.wrap(byArray);
            if (string2.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        } else {
            this.oByteBuffer = ByteBuffer.allocateDirect(byArray.length);
            if (string2.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.oByteBuffer.put(byArray);
        }
        this.oByteBuffer.position(Integer.parseInt((String)objectInput.readObject()));
        this.oByteBuffer.limit(Integer.parseInt((String)objectInput.readObject()));
        String string3 = (String)objectInput.readObject();
        this.readOnly = string3.equals("R");
        this.oWsByteBufferPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
        this.trusted = this.oWsByteBufferPoolManager.isTrustedUsers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readExternal:  trusted set to: " + this.trusted);
        }
        this.removedFromLeakDetection = true;
    }
}

