/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep$Type;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.w;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private AlgorithmParameterSpec keyParams;
    private transient boolean destroyed = false;
    private transient RSAKey rsaKey = null;
    private static final String[] z;

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public RSAPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.rsaPrivateCrtKey(algorithmId, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        block21: {
            block20: {
                this.algid = algorithmId;
                this.provider = iBMJCEPlusProvider;
                this.modulus = bigInteger;
                this.publicExponent = bigInteger2;
                this.privateExponent = bigInteger3;
                this.primeP = bigInteger4;
                this.primeQ = bigInteger5;
                this.primeExponentP = bigInteger6;
                this.primeExponentQ = bigInteger7;
                this.crtCoefficient = bigInteger8;
                this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
                if (this.modulus == null || this.publicExponent == null) break block20;
                if (this.privateExponent == null) break block20;
                if (this.primeP == null) break block20;
                if (this.primeQ == null) break block20;
                if (this.primeExponentP == null) break block20;
                if (this.primeExponentQ == null) break block20;
                if (this.crtCoefficient != null) break block21;
            }
            throw new InvalidKeyException(z[2]);
        }
        w.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.key = RSAPrivateCrtKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[4]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[5] + iOException.getMessage());
        }
        w.a(iBMJCEPlusProvider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[6]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[9]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[7]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[8], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, bigInteger3.toByteArray()), new DerValue(2, bigInteger4.toByteArray()), new DerValue(2, bigInteger5.toByteArray()), new DerValue(2, bigInteger6.toByteArray()), new DerValue(2, bigInteger7.toByteArray()), new DerValue(2, bigInteger8.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.b();
        return this.crtCoefficient;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.b();
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.b();
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getPrimeP() {
        this.b();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.b();
        return this.primeQ;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.b();
        return this.publicExponent;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new JCEPlusKeyRep(JCEPlusKeyRep$Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded(), this.provider.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
            this.keyParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[10]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[0]);
    }

    protected RSAKey c() {
        return this.rsaKey;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "P!%w\u0011k\u0004\u0005S\u0006A\u0000\u0010l\u0006{R\u000fB\u001aqR\u0005U\u0006\"\u001c\u000bSCf\u001b\u0016B\u0000v\u001e\u001d\u0007\u0007g\u0001\u0001U\nc\u001e\r]\u0002`\u001e\u0001";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 2;
                            break;
                        }
                        case 1: {
                            n6 = 114;
                            break;
                        }
                        case 2: {
                            n6 = 100;
                            break;
                        }
                        case 3: {
                            n6 = 39;
                            break;
                        }
                        default: {
                            n6 = 99;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "D\u0013\rK\u0006fR\u0010HCa\u0000\u0001F\u0017gR6t\"\"\u0002\u0016N\u0015c\u0006\u0001\u0007\bg\u000b";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "P!%\u0007(g\u000bDW\u0002p\u0013\tB\u0017g\u0000\u0017\u0007\u0000c\u001c\nH\u0017\"\u0010\u0001\u0007\rw\u001e\b";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "a\u001d\u0011K\u0007\"\u001c\u000bSCF76\u0007\u0006l\u0011\u000bC\u00068R";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "D\u0013\rK\u0006fR\u0010HCa\u0000\u0001F\u0017gR6t\"\"\u0002\u0016N\u0015c\u0006\u0001\u0007\bg\u000b";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "a\u001d\u0011K\u0007\"\u001c\u000bSCF76\u0007\u0006l\u0011\u000bC\u00068R";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "D\u0013\rK\u0006fR\u0010HCa\u0000\u0001F\u0017gR6t\"\"\u0002\u0016N\u0015c\u0006\u0001\u0007\bg\u000b";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "K\u001c\u0012F\u000fk\u0016Du0C\"\u0016N\u0015c\u0006\u0001d\u0011v9\u0001^Cg\u001c\u0007H\u0007k\u001c\u0003\u000bCf\u0013\u0010FCm\u0004\u0001U\u0011w\u001c";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "K\u001c\u0012F\u000fk\u0016Du0CR\u0014U\nt\u0013\u0010BCi\u0017\u001d";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "T\u0017\u0016T\nm\u001cDJ\u0016q\u0006DE\u0006\"B";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "V\u001a\rTCi\u0017\u001d\u0007\nqR\nHCn\u001d\n@\u0006pR\u0012F\u000fk\u0016";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

