/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep$Type;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPrivateKey
extends PrivateKeyInfo
implements PrivateKey,
Serializable,
javax.crypto.interfaces.DHPrivateKey,
Destroyable {
    private static final long serialVersionUID = -9137894705065174379L;
    private static final BigInteger PKCS8_VERSION;
    private IBMJCEPlusProvider provider = null;
    private BigInteger x = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.x = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[1]);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.x = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[18]);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            this.algid = new AlgorithmId(AlgorithmId.DH_oid, dHKey.getParameters());
            this.a(dHKey.getPrivateKeyBytes());
            this.dhKey = dHKey;
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[17], (Throwable)exception);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[2]);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[5]);
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(z[8] + PKCS8_VERSION + z[12] + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[9]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[3]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[4]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[6]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            BigInteger bigInteger3 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[10]);
            }
            this.key = derValue.getData().getOctetString();
            this.parseKeyBits();
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger2, bigInteger3, this.x.bitLength()) : new DHParameterSpec(bigInteger2, bigInteger3, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[7], exception);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[11], invalidParameterSpecException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a() throws IOException {
        BigInteger bigInteger = this.dhParams.b().modPow(this.x, this.dhParams.a());
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, this.x.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            return byArray;
        }
        finally {
            this.a(derOutputStream);
        }
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(z[13], iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return z[15];
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        DerOutputStream derOutputStream = null;
        DerOutputStream derOutputStream2 = null;
        this.b();
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putOID(new ObjectIdentifier(this.DH_data));
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.dhParams.a());
                derOutputStream2.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream4.putDerValue(derValue);
                derOutputStream3.write((byte)48, derOutputStream4);
                derOutputStream3.putOctetString(this.key);
                derOutputStream = new DerOutputStream();
                derOutputStream.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    derOutputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    derOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public DHParameterSpec getParams() {
        this.b();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[14], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public BigInteger getX() {
        this.b();
        return this.x;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.x = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[16]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new JCEPlusKeyRep(JCEPlusKeyRep$Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded(), this.provider.getName());
    }

    DHKey c() {
        return this.dhKey;
    }

    private void a(DerOutputStream derOutputStream) {
        try {
            derOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.x, this.dhParams.a(), this.dhParams.b()};
        return Arrays.hashCode(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPrivateKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)object;
        DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
        if (this.x.compareTo(dHPrivateKey.getX()) != 0) return false;
        if (this.dhParams.a().compareTo(dHParameterSpec.getP()) != 0) return false;
        if (this.dhParams.b().compareTo(dHParameterSpec.getG()) != 0) return false;
        if (object instanceof DHPrivateKey) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException(z[19]);
        }
        this.key = (byte[])this.key.clone();
        if (this.encodedKey != null && this.encodedKey.length != 0) {
            this.encodedKey = (byte[])this.encodedKey.clone();
            return;
        }
        throw new InvalidObjectException(z[20]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[21];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "5UN\u001fl\u0002\u0014P\u0003l\u0012AC\u0014#7gn_2VQN\u0012l\u0012]N\u0016";
        int n3 = -1;
        block28: while (true) {
            char[] cArray;
            block32: {
                int n4;
                int n5;
                block31: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block31;
                    n5 = n5;
                    if (n5 <= n4) break block32;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 118;
                            break;
                        }
                        case 1: {
                            n6 = 52;
                            break;
                        }
                        case 2: {
                            n6 = 32;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 3;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "5UN\u001fl\u0002\u0014I\u001fj\u0002]A\u001dj\fQ\u0000\u0001b\u0004UM\u0014w\u0013FS";
                    n3 = 0;
                    continue block28;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "0UI\u001dv\u0004Q\u0000\u0018mVph!q\u001fBA\u0005f=QY";
                    n3 = 1;
                    continue block28;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "&UR\u0010n\u0013@E\u0003pVYI\u0002p\u001fZG";
                    n3 = 2;
                    continue block28;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "8AL\u001d#\u0006UR\u0010n\u0013@E\u0003p";
                    n3 = 3;
                    continue block28;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "=QYQm\u0019@\u0000\u0010#%qq$F8we";
                    n3 = 4;
                    continue block28;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "&UR\u0010n\u0013@E\u0003pVZO\u0005#\u0017\u0014s4R#qn2F";
                    n3 = 5;
                    continue block28;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "3FR\u001eqVDA\u0003p\u001fZGQh\u0013M\u0000\u0014m\u0015[D\u0018m\u0011";
                    n3 = 6;
                    continue block28;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0000QR\u0002j\u0019Z\u0000\u001cj\u0005YA\u0005`\u001e\u000e\u0000Yp\u0003DP\u001eq\u0002QDK#";
                    n3 = 7;
                    continue block28;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "7XG8gV]SQm\u0019@\u0000\u0010#%qq$F8we";
                    n3 = 8;
                    continue block28;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "3LT\u0003bVDA\u0003b\u001bQT\u0014qVPA\u0005b";
                    n3 = 9;
                    continue block28;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "3FR\u001eqVWR\u0014b\u0002]N\u0016#2|p\u0010q\u0017YE\u0005f\u0004G";
                    n3 = 10;
                    continue block28;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "Z\u0014P\u0010q\u0005QDK#";
                    n3 = 11;
                    continue block28;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "?ZV\u0010o\u001fP\u00005KVDR\u0018u\u0017@EQh\u0013M";
                    n3 = 12;
                    continue block28;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "0UI\u001dv\u0004Q\u0000\u0018mVph!q\u001fBA\u0005f=QY";
                    n3 = 13;
                    continue block28;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "2|";
                    n3 = 14;
                    continue block28;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\"\\I\u0002#\u001dQYQj\u0005\u0014N\u001e#\u001a[N\u0016f\u0004\u0014V\u0010o\u001fP";
                    n3 = 15;
                    continue block28;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "0UI\u001dv\u0004Q\u0000\u0018mVph!q\u001fBA\u0005f=QY";
                    n3 = 16;
                    continue block28;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "5UN\u001fl\u0002\u0014P\u0003l\u0012AC\u0014#7gn_2VQN\u0012l\u0012]N\u0016";
                    n3 = 17;
                    continue block28;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u001dQYQm\u0019@\u0000\u0015f\u0005QR\u0018b\u001a]Z\u0010a\u001aQ";
                    n3 = 18;
                    continue block28;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u0013ZC\u001eg\u0013P\u0000\u001af\u000f\u0014N\u001ewVPE\u0002f\u0004]A\u001dj\fUB\u001df";
                    n3 = 19;
                    continue block28;
                }
                case 19: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        PKCS8_VERSION = BigInteger.valueOf(0L);
    }
}

