/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class Authenticator {
    public int authenticator_vno;
    public PrincipalName cname;
    Checksum a;
    public int cusec;
    public KerberosTime ctime;
    EncryptionKey b;
    Integer c;
    public AuthorizationData authorizationData;

    public Authenticator(PrincipalName principalName, Checksum checksum, int n2, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n3, AuthorizationData authorizationData) {
        this.authenticator_vno = 5;
        this.cname = principalName;
        this.a = checksum;
        this.cusec = n2;
        this.ctime = kerberosTime;
        this.b = encryptionKey;
        this.c = n3;
        this.authorizationData = authorizationData;
    }

    public Authenticator(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.a(new DerValue(byArray));
    }

    public Authenticator(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.a(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 2 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.authenticator_vno = derValue3.getData().getBigInteger().intValue();
        if (this.authenticator_vno != 5) {
            throw new KrbApErrException(39);
        }
        Realm realm = Realm.parse(derValue2.getData(), (byte)1, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)2, false, realm);
        this.a = Checksum.parse(derValue2.getData(), (byte)3, true);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        this.cusec = derValue3.getData().getBigInteger().intValue();
        this.ctime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        if (derValue2.getData().available() > 0) {
            this.b = EncryptionKey.parse(derValue2.getData(), (byte)6, true);
        } else {
            this.b = null;
            this.c = null;
            this.authorizationData = null;
        }
        if (derValue2.getData().available() > 0) {
            if ((derValue2.getData().peekByte() & 0x1F) == 7 && ((derValue3 = derValue2.getData().getDerValue()).getTag() & 0x1F) == 7) {
                this.c = new Integer(derValue3.getData().getBigInteger().intValue());
            }
        } else {
            this.c = null;
            this.authorizationData = null;
        }
        this.authorizationData = derValue2.getData().available() > 0 ? AuthorizationData.parse(derValue2.getData(), (byte)8, true) : null;
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.authenticator_vno));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream.toByteArray()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.cname.getRealm().asn1Encode()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.cname.asn1Encode()));
        if (this.a != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.a.asn1Encode()));
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.cusec));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), derOutputStream.toByteArray()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.ctime.asn1Encode()));
        if (this.b != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.b.asn1Encode()));
        }
        if (this.c != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.c.longValue()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream.toByteArray()));
        }
        if (this.authorizationData != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.authorizationData.asn1Encode()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)2), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final Checksum getChecksum() {
        return this.a;
    }

    public final Integer getSeqNumber() {
        return this.c;
    }

    public final EncryptionKey getSubKey() {
        return this.b;
    }

    public Realm getRealm() {
        return null;
    }

    public Authenticator(Realm realm, PrincipalName principalName, Checksum checksum, int n2, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n3, AuthorizationData authorizationData) {
        this(principalName, checksum, n2, kerberosTime, encryptionKey, n3, authorizationData);
    }

    public PrincipalName getClient() {
        return this.cname;
    }

    public int getMicroSeconds() {
        return this.cusec;
    }

    public KerberosTime getTime() {
        return this.ctime;
    }

    public EncryptionKey getSubsesionKey() {
        return this.getSubKey();
    }

    public int getSequenceNumber() {
        if (this.c == null) {
            return -1;
        }
        return this.c;
    }

    public AuthorizationData getAuthzData() {
        return this.authorizationData;
    }

    public int getVersionNumber() {
        return this.authenticator_vno;
    }
}

