/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.a;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.security.auth.DestroyFailedException;

public final class DSAPrivateHWKey
extends PrivateKeyInfo
implements Serializable {
    private boolean hasBeenDestroyed = false;
    private byte[] keyToken;
    private byte[] externalKeyToken = null;
    private DSAKeyHWAttributes attribs = null;
    static final long serialVersionUID = -8860382468882882467L;
    private static Debug debug;
    private static String className;
    private static final String[] a;

    public DSAPrivateHWKey(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, DSAKeyHWAttributes dSAKeyHWAttributes) throws InvalidKeyException {
        DerValue[] derValueArray;
        if (dSAKeyHWAttributes.getKeyType() == 2) {
            derValueArray = new KeyPairUtils();
            this.externalKeyToken = (byte[])byArray.clone();
            this.keyToken = derValueArray.importExternalToken(byArray, KeyPairUtils.KeyPairAlgorithm.DSA);
        } else {
            this.keyToken = (byte[])byArray.clone();
        }
        this.attribs = new DSAKeyHWAttributes(dSAKeyHWAttributes.getKeyType(), dSAKeyHWAttributes.getKeyUsage());
        this.algid = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
        try {
            derValueArray = new DerValue[]{new DerValue(4, byArray)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[21], iOException);
                }
            }
            catch (IOException iOException2) {
                throw DSAPrivateHWKey.b(iOException2);
            }
            String[] stringArray = a;
            throw new InvalidKeyException(stringArray[35] + iOException.getMessage());
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[14]);
            }
        }
        catch (IOException iOException) {
            throw DSAPrivateHWKey.b(iOException);
        }
    }

    public DSAPrivateHWKey(byte[] byArray) throws InvalidKeyException {
        if (debug != null) {
            String[] stringArray = a;
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, stringArray[14], (Object)byArray);
        }
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[14], iOException);
                }
            }
            catch (IOException iOException2) {
                throw DSAPrivateHWKey.b(iOException2);
            }
            throw new InvalidKeyException(iOException.getMessage());
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[14]);
            }
        }
        catch (IOException iOException) {
            throw DSAPrivateHWKey.b(iOException);
        }
    }

    /*
     * Loose catch block
     */
    public DSAParams getParams() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[19]);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw DSAPrivateHWKey.b(invalidParameterSpecException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[4], illegalStateException);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw DSAPrivateHWKey.b(invalidParameterSpecException);
            }
            throw illegalStateException;
        }
        try {
            AlgorithmParameters algorithmParameters;
            block25: {
                block26: {
                    block23: {
                        block24: {
                            if (!(this.algid instanceof DSAParams)) break block23;
                            try {
                                block27: {
                                    if (debug == null) break block24;
                                    break block27;
                                    catch (InvalidParameterSpecException invalidParameterSpecException) {
                                        throw DSAPrivateHWKey.b(invalidParameterSpecException);
                                    }
                                }
                                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[25], (DSAParams)this.algid);
                            }
                            catch (InvalidParameterSpecException invalidParameterSpecException) {
                                throw DSAPrivateHWKey.b(invalidParameterSpecException);
                            }
                        }
                        return (DSAParams)this.algid;
                    }
                    algorithmParameters = this.algid.getAlgParameters();
                    if (algorithmParameters != null) break block25;
                    try {
                        block28: {
                            if (debug == null) break block26;
                            break block28;
                            catch (InvalidParameterSpecException invalidParameterSpecException) {
                                throw DSAPrivateHWKey.b(invalidParameterSpecException);
                            }
                        }
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[4], null);
                    }
                    catch (InvalidParameterSpecException invalidParameterSpecException) {
                        throw DSAPrivateHWKey.b(invalidParameterSpecException);
                    }
                }
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            try {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[4], dSAParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw DSAPrivateHWKey.b(invalidParameterSpecException);
            }
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[4], invalidParameterSpecException);
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[4], null);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException2) {
                throw DSAPrivateHWKey.b(invalidParameterSpecException2);
            }
            return null;
        }
    }

    public BigInteger getX() throws UnsupportedOperationException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[24]);
                debug.text(Debug.TYPE_PUBLIC, className, a[18], a[30]);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw DSAPrivateHWKey.b(unsupportedOperationException);
        }
        throw new UnsupportedOperationException(a[16]);
    }

    public byte[] getEncoded() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[23]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[10], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw DSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        byte[] byArray = this.getToken();
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[10], byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        return byArray;
    }

    public byte[] getToken() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[5]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[22], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw DSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[22], this.keyToken);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        return this.keyToken;
    }

    public byte getType() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[3]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[1], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw DSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[1], this.attribs.getKeyType());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        return this.attribs.getKeyType();
    }

    /*
     * Loose catch block
     */
    protected void parseKeyBits() throws IOException {
        block19: {
            try {
                if (debug != null) {
                    debug.entry(Debug.TYPE_PUBLIC, className, a[36]);
                }
            }
            catch (Exception exception) {
                throw DSAPrivateHWKey.b(exception);
            }
            if (this.isDestroyed()) {
                String[] stringArray = a;
                IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, stringArray[34], illegalStateException);
                    }
                }
                catch (Exception exception) {
                    throw DSAPrivateHWKey.b(exception);
                }
                throw illegalStateException;
            }
            try {
                block20: {
                    DerValue derValue = new DerValue(this.key);
                    this.keyToken = derValue.getData().getOctetString();
                    if (derValue.getData().available() == 0) break block19;
                    try {
                        block21: {
                            if (debug == null) break block20;
                            break block21;
                            catch (Exception exception) {
                                throw DSAPrivateHWKey.b(exception);
                            }
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, a[34], a[33]);
                    }
                    catch (Exception exception) {
                        throw DSAPrivateHWKey.b(exception);
                    }
                }
                String[] stringArray = a;
                throw new IOException(stringArray[32]);
            }
            catch (Exception exception) {
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, a[31], exception);
                    }
                }
                catch (Exception exception2) {
                    throw DSAPrivateHWKey.b(exception2);
                }
                throw new IOException(exception.getMessage());
            }
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[34]);
            }
        }
        catch (Exception exception) {
            throw DSAPrivateHWKey.b(exception);
        }
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        block20: {
            block19: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[17]);
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw DSAPrivateHWKey.b(invalidKeyException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[9]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[37], illegalStateException);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw DSAPrivateHWKey.b(invalidKeyException);
                    }
                    throw illegalStateException;
                }
                if (this.getType() != 0) {
                    String[] stringArray = a;
                    InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[6]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[37], invalidKeyException);
                            debug.exit(Debug.TYPE_PUBLIC, className, stringArray[37]);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException2) {
                        throw DSAPrivateHWKey.b(invalidKeyException2);
                    }
                    throw invalidKeyException;
                }
                byte[] byArray = this.getToken();
                try {
                    if (byArray.length > 64) break block19;
                    KeyPairUtils.c(byArray);
                    break block20;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw DSAPrivateHWKey.b(invalidKeyException);
                }
            }
            String[] stringArray = a;
            RuntimeException runtimeException = new RuntimeException(stringArray[38]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[37], runtimeException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[37]);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw DSAPrivateHWKey.b(invalidKeyException);
            }
            throw runtimeException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[37]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw DSAPrivateHWKey.b(invalidKeyException);
        }
    }

    public String toString() {
        String string;
        block16: {
            block17: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[15]);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw DSAPrivateHWKey.b(illegalStateException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[29]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[13], illegalStateException);
                        }
                    }
                    catch (IllegalStateException illegalStateException2) {
                        throw DSAPrivateHWKey.b(illegalStateException2);
                    }
                    throw illegalStateException;
                }
                a a2 = new a();
                string = a2.encodeBuffer(this.keyToken);
                try {
                    try {
                        try {
                            if (Security.getProvider(a[20]) != null || Security.getProvider(a[28]) != null) break block16;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw DSAPrivateHWKey.b(illegalStateException);
                        }
                        if (debug == null) break block17;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw DSAPrivateHWKey.b(illegalStateException);
                    }
                    debug.exit(Debug.TYPE_PUBLIC, className, a[13]);
                }
                catch (IllegalStateException illegalStateException) {
                    throw DSAPrivateHWKey.b(illegalStateException);
                }
            }
            String[] stringArray = a;
            return stringArray[8] + string + "\n";
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[13]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        return a[12] + string + "\n";
    }

    public void destroy() throws DestroyFailedException {
        int n2;
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[27]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw DSAPrivateHWKey.b(destroyFailedException);
        }
        if (null != this.keyToken) {
            try {
                for (n2 = 0; n2 < this.keyToken.length; ++n2) {
                    this.keyToken[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw DSAPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.keyToken = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[27], a[7]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw DSAPrivateHWKey.b(destroyFailedException);
            }
        }
        if (null != this.externalKeyToken) {
            try {
                for (n2 = 0; n2 < this.externalKeyToken.length; ++n2) {
                    this.externalKeyToken[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw DSAPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.externalKeyToken = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[27], a[2]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw DSAPrivateHWKey.b(destroyFailedException);
            }
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[27]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw DSAPrivateHWKey.b(destroyFailedException);
        }
        this.hasBeenDestroyed = true;
    }

    public boolean isDestroyed() {
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[0], "" + this.hasBeenDestroyed);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DSAPrivateHWKey.b(illegalStateException);
        }
        return this.hasBeenDestroyed;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[39];
                var3_1 = 0;
                var2_2 = "]P\u00024y,9\u0007^P\u0005\u0014r3%5\\M\u0005%y-!U~\u00149_,+\\[Q(j0`[P\u0014.+9%KZ\u0014$+,5M\u0015\u0010.oc3\\AQ4dc.LY\u001dn\u0007^P\u0005\u0014r3%\t^P\u0005\u0010j1!TF\b^P\u0005\u0014d(%W1|G\u0003/yc!MA\u0014-{7)WRQ4dc$\\Y\u00144nc.V[\\\u0010@\u0007\u0013\u0019^\u00149+%2VXQ\u0010@\u0007\u0013-RP\b\u0014d(%W\u0015\u0019!xc\"\\P\u001f`q&2VP\u0015`d64\u0019T\u001f$+0%M\u0015\u0005/+-5UY_\"pw<\nH\u0002t\u000e\u0000I`O\u0010\u0001\u0019e\u0003)}\"4\\\u0015:%rc\fXW\u0014,1I-]P\u00024y,9\u0011\u001cQ(j0`[P\u0014.+ !UY\u0014$+*.\u0019A\u0019)xc+\\LQ/i)%ZA_\n^P\u0005\u0005e /]P\u0015/ZZ\u001cnb!-\u0017V\u00039{7/\u0017]\u00157y\u0000\u0003x\u001b\u00012d5)]P\u0003nO\u0010\u0001iG\u00186j7%qb:%r!pw<\nH\u0006\u0003ztQ\u0004X\u0002`iG\u00186j7%\u0019~\u00149+\u000f![P\u001dz\u0001\bMZ\"4y*.^\u000f}f0\u0010y*6XA\u0014\b\\\b%@\bMZ\"4y*.^8qT\u0003$|\"2\\\u0015\u00142y,2\u0015\u0015\u00175e 4PZ\u001f`l&4a\u0015\u0019!xc.V\u0015\u001c%j-)WRQ)ec(XG\u00157j1%\u000f]P\u001d%\u007f&\u0010rq\"\u0005e72@\u0004^P\u0005\u0018\t^P\u0005\u0010j1!TF\tpw<\nH\u0006\u0003zt\u000f}f0\u0010y*6XA\u0014\b\\\b%@\b^P\u0005\u0014d(%W\n^P\u0005\u0005e /]P\u0015\u0004^P\u0005\u0018\n^P\u0005\u0010j1!TF@\tPW\u001c*h&#ZT\u0007]P\u00024y,9\npw<\nH\u0006t\u000e\u0000I-]P\u00024y,9\u0011\u001cQ(j0`[P\u0014.+ !UY\u0014$+*.\u0019A\u0019)xc+\\LQ/i)%ZA_\u001f^P\u0005\u0018++!J\u0015\u001f/+.%X[\u0018.lc)W\u0015\u0019!y'7XG\u0014\fIT\u00033n\b%Mw\u00184x.p[\u0007!g*$\u0019q\"\u0001[1)OT\u0005%C\u0014\u000b\\LQ%e /]\\\u001f''c$XA\u0010`d5%KG\u0004..p[\u0007!g*$\u0019q\"\u0001[1)OT\u0005%C\u0014\u000b\\LQ%e /]\\\u001f''c$XA\u0010`d5%KG\u0004.\fIT\u00033n\b%@w\u00184x\u0018zZ\u0004,oc.VAQ\u0004N\u0011`\\[\u0012/o&`A\u000fQ\fIT\u00033n\b%@w\u00184x";
                var4_3 = "]P\u00024y,9\u0007^P\u0005\u0014r3%5\\M\u0005%y-!U~\u00149_,+\\[Q(j0`[P\u0014.+9%KZ\u0014$+,5M\u0015\u0010.oc3\\AQ4dc.LY\u001dn\u0007^P\u0005\u0014r3%\t^P\u0005\u0010j1!TF\b^P\u0005\u0014d(%W1|G\u0003/yc!MA\u0014-{7)WRQ4dc$\\Y\u00144nc.V[\\\u0010@\u0007\u0013\u0019^\u00149+%2VXQ\u0010@\u0007\u0013-RP\b\u0014d(%W\u0015\u0019!xc\"\\P\u001f`q&2VP\u0015`d64\u0019T\u001f$+0%M\u0015\u0005/+-5UY_\"pw<\nH\u0002t\u000e\u0000I`O\u0010\u0001\u0019e\u0003)}\"4\\\u0015:%rc\fXW\u0014,1I-]P\u00024y,9\u0011\u001cQ(j0`[P\u0014.+ !UY\u0014$+*.\u0019A\u0019)xc+\\LQ/i)%ZA_\n^P\u0005\u0005e /]P\u0015/ZZ\u001cnb!-\u0017V\u00039{7/\u0017]\u00157y\u0000\u0003x\u001b\u00012d5)]P\u0003nO\u0010\u0001iG\u00186j7%qb:%r!pw<\nH\u0006\u0003ztQ\u0004X\u0002`iG\u00186j7%\u0019~\u00149+\u000f![P\u001dz\u0001\bMZ\"4y*.^\u000f}f0\u0010y*6XA\u0014\b\\\b%@\bMZ\"4y*.^8qT\u0003$|\"2\\\u0015\u00142y,2\u0015\u0015\u00175e 4PZ\u001f`l&4a\u0015\u0019!xc.V\u0015\u001c%j-)WRQ)ec(XG\u00157j1%\u000f]P\u001d%\u007f&\u0010rq\"\u0005e72@\u0004^P\u0005\u0018\t^P\u0005\u0010j1!TF\tpw<\nH\u0006\u0003zt\u000f}f0\u0010y*6XA\u0014\b\\\b%@\b^P\u0005\u0014d(%W\n^P\u0005\u0005e /]P\u0015\u0004^P\u0005\u0018\n^P\u0005\u0010j1!TF@\tPW\u001c*h&#ZT\u0007]P\u00024y,9\npw<\nH\u0006t\u000e\u0000I-]P\u00024y,9\u0011\u001cQ(j0`[P\u0014.+ !UY\u0014$+*.\u0019A\u0019)xc+\\LQ/i)%ZA_\u001f^P\u0005\u0018++!J\u0015\u001f/+.%X[\u0018.lc)W\u0015\u0019!y'7XG\u0014\fIT\u00033n\b%Mw\u00184x.p[\u0007!g*$\u0019q\"\u0001[1)OT\u0005%C\u0014\u000b\\LQ%e /]\\\u001f''c$XA\u0010`d5%KG\u0004..p[\u0007!g*$\u0019q\"\u0001[1)OT\u0005%C\u0014\u000b\\LQ%e /]\\\u001f''c$XA\u0010`d5%KG\u0004.\fIT\u00033n\b%@w\u00184x\u0018zZ\u0004,oc.VAQ\u0004N\u0011`\\[\u0012/o&`A\u000fQ\fIT\u00033n\b%@w\u00184x".length();
                var1_4 = 7;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 123;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "gj'\u001fE\u001c*HK\u0018?_\r\bz(Ja=\u001b]\u0010\u001e#c*\u0018T\u0015Zoj%\u001dE\u0011Ze`9Za2>P/ \u001fHY\u0015ae.\u0019E";
                    var4_3 = "gj'\u001fE\u001c*HK\u0018?_\r\bz(Ja=\u001b]\u0010\u001e#c*\u0018T\u0015Zoj%\u001dE\u0011Ze`9Za2>P/ \u001fHY\u0015ae.\u0019E".length();
                    var1_4 = 15;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 65;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 66;
                            break;
                        }
                        case 1: {
                            v15 = 78;
                            break;
                        }
                        case 2: {
                            v15 = 10;
                            break;
                        }
                        case 3: {
                            v15 = 59;
                            break;
                        }
                        case 4: {
                            v15 = 112;
                            break;
                        }
                        case 5: {
                            v15 = 56;
                            break;
                        }
                        default: {
                            v15 = 59;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        DSAPrivateHWKey.a = var5;
        var0_6 = DSAPrivateHWKey.a;
        DSAPrivateHWKey.debug = Debug.getInstance(var0_6[26]);
        DSAPrivateHWKey.className = var0_6[11];
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

