/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodType;

class ThunkKey {
    final MethodType thunkableType;

    private static Class<?> normalize(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE || c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE) {
                return Integer.TYPE;
            }
            return c;
        }
        return Object.class;
    }

    public static MethodType computeThunkableType(MethodType type) {
        return ThunkKey.computeThunkableType(type, type.parameterCount());
    }

    public static MethodType computeThunkableType(MethodType type, int stopIndex) {
        return ThunkKey.computeThunkableType(type, stopIndex, type.parameterCount());
    }

    public static MethodType computeThunkableType(MethodType type, int stopIndex, int restartIndex) {
        int i;
        Class[] parameterTypes = new Class[type.parameterCount()];
        for (i = 0; i < stopIndex; ++i) {
            parameterTypes[i] = ThunkKey.normalize(type.parameterType(i));
        }
        while (i < restartIndex) {
            parameterTypes[i] = type.parameterType(i);
            ++i;
        }
        while (i < type.parameterCount()) {
            parameterTypes[i] = ThunkKey.normalize(type.parameterType(i));
            ++i;
        }
        MethodType result = MethodType.methodType(ThunkKey.normalize(type.returnType()), parameterTypes);
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof ThunkKey) {
            return ((ThunkKey)other).equalsThunkKey(this);
        }
        return false;
    }

    public int hashCode() {
        return this.thunkableType.hashCode();
    }

    boolean equalsThunkKey(ThunkKey other) {
        return this.thunkableType.equals(other.thunkableType);
    }

    public ThunkKey(MethodType t) {
        this.thunkableType = t;
    }

    public static void load() {
    }
}

