/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.io.ArrayListSerializer;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.BigDecimalSerializer;
import com.ibm.rmi.io.BigIntegerSerializer;
import com.ibm.rmi.io.BooleanArraySerializer;
import com.ibm.rmi.io.BooleanSerializer;
import com.ibm.rmi.io.ByteArraySerializer;
import com.ibm.rmi.io.ByteSerializer;
import com.ibm.rmi.io.CharArraySerializer;
import com.ibm.rmi.io.CharacterSerializer;
import com.ibm.rmi.io.DateSerializer;
import com.ibm.rmi.io.DoubleArraySerializer;
import com.ibm.rmi.io.DoubleSerializer;
import com.ibm.rmi.io.FloatArraySerializer;
import com.ibm.rmi.io.FloatSerializer;
import com.ibm.rmi.io.GregorianCalendarSerializer;
import com.ibm.rmi.io.HashMapSerializer;
import com.ibm.rmi.io.HashSetSerializer;
import com.ibm.rmi.io.HashtableSerializer;
import com.ibm.rmi.io.IdentityHashMapSerializer;
import com.ibm.rmi.io.IntArraySerializer;
import com.ibm.rmi.io.IntegerSerializer;
import com.ibm.rmi.io.JLBooleanArraySerializer;
import com.ibm.rmi.io.JLByteArraySerializer;
import com.ibm.rmi.io.JLCharacterArraySerializer;
import com.ibm.rmi.io.JLDoubleArraySerializer;
import com.ibm.rmi.io.JLFloatArraySerializer;
import com.ibm.rmi.io.JLIntegerArraySerializer;
import com.ibm.rmi.io.JLLongArraySerializer;
import com.ibm.rmi.io.JLShortArraySerializer;
import com.ibm.rmi.io.LinkedHashMapSerializer;
import com.ibm.rmi.io.LinkedHashSetSerializer;
import com.ibm.rmi.io.LinkedListSerializer;
import com.ibm.rmi.io.LongArraySerializer;
import com.ibm.rmi.io.LongSerializer;
import com.ibm.rmi.io.Object2DArraySerializer;
import com.ibm.rmi.io.ObjectArraySerializer;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.RandomArraySerializer;
import com.ibm.rmi.io.RandomSerializer;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.io.ReflectFieldFactoryStrategy;
import com.ibm.rmi.io.Serializer;
import com.ibm.rmi.io.ShortArraySerializer;
import com.ibm.rmi.io.ShortSerializer;
import com.ibm.rmi.io.StackSerializer;
import com.ibm.rmi.io.StringArraySerializer;
import com.ibm.rmi.io.StringSerializer;
import com.ibm.rmi.io.VectorSerializer;
import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable {
    private final String name;
    private final String signature;
    private char type;
    private Field field;
    private String typeString;
    private Class clazz;
    private volatile ObjectStreamClass osc;
    private final boolean omg10336Compliant;
    private int isAny = -1;
    private ReflectField reflectField;
    private static final ReflectFieldFactoryStrategy REFLECT_FIELD_FACTORY = ReflectFieldFactoryStrategy.REFLECT_FIELD_FACTORY;

    public ObjectStreamField(String string, Class clazz, boolean bl) {
        this.name = string;
        this.clazz = clazz;
        this.omg10336Compliant = bl;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(Field field, boolean bl) {
        this(field.getName(), field.getType(), bl);
        this.field = field;
        this.reflectField = REFLECT_FIELD_FACTORY.createReflectField(field);
    }

    public String getName() {
        return this.name;
    }

    public ObjectStreamClass getObjectStreamClass() {
        if (null == this.osc) {
            this.osc = ObjectStreamClass.lookup(this.clazz, this.omg10336Compliant);
        }
        return this.osc;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = Object.class;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
        this.reflectField = REFLECT_FIELD_FACTORY.createReflectField(field);
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    public int compareTo(Object object) {
        boolean bl;
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl2 = this.typeString == null;
        boolean bl3 = bl = objectStreamField.typeString == null;
        if (bl2 != bl) {
            return bl2 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public boolean typeEquals(ObjectStreamField objectStreamField) {
        if (objectStreamField == null || this.type != objectStreamField.type) {
            return false;
        }
        if (this.typeString == null && objectStreamField.typeString == null) {
            return true;
        }
        return ObjectStreamClass.compareClassNames(this.typeString, objectStreamField.typeString, '/');
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.typeString != null) {
            return this.typeString + " " + this.name;
        }
        return this.type + " " + this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean isAny() {
        if (this.isAny == -1) {
            this.isAny = this.typeString != null && (this.typeString.equals("Ljava/lang/Object;") || this.typeString.equals("Ljava/io/Serializable;") || this.typeString.equals("Ljava/io/Externalizable;")) ? 1 : 0;
        }
        return this.isAny == 1;
    }

    public ReflectField getReflectField() {
        return this.reflectField;
    }

    private Serializer getSerializer(Class clazz) {
        String string = clazz.getName();
        ObjectSerializer objectSerializer = null;
        switch (string) {
            case "java.util.ArrayList": {
                objectSerializer = ArrayListSerializer.getInstance();
                break;
            }
            case "java.util.HashMap": {
                objectSerializer = HashMapSerializer.getInstance();
                break;
            }
            case "java.util.Hashtable": {
                objectSerializer = HashtableSerializer.getInstance();
                break;
            }
            case "java.util.HashSet": {
                objectSerializer = HashSetSerializer.getInstance();
                break;
            }
            case "java.util.IdentityHashMap": {
                objectSerializer = IdentityHashMapSerializer.getInstance();
                break;
            }
            case "java.util.LinkedHashMap": {
                objectSerializer = LinkedHashMapSerializer.getInstance();
                break;
            }
            case "java.util.LinkedHashSet": {
                objectSerializer = LinkedHashSetSerializer.getInstance();
                break;
            }
            case "java.util.LinkedList": {
                objectSerializer = LinkedListSerializer.getInstance();
                break;
            }
            case "java.util.Stack": {
                objectSerializer = StackSerializer.getInstance();
                break;
            }
            case "java.util.Vector": {
                objectSerializer = VectorSerializer.getInstance();
                break;
            }
            case "java.lang.String": {
                objectSerializer = StringSerializer.getInstance();
                break;
            }
            case "java.util.Date": {
                objectSerializer = DateSerializer.getInstance();
                break;
            }
            case "java.lang.Integer": {
                objectSerializer = IntegerSerializer.getInstance();
                break;
            }
            case "java.lang.Boolean": {
                objectSerializer = BooleanSerializer.getInstance();
                break;
            }
            case "java.lang.Character": {
                objectSerializer = CharacterSerializer.getInstance();
                break;
            }
            case "java.lang.Double": {
                objectSerializer = DoubleSerializer.getInstance();
                break;
            }
            case "java.lang.Float": {
                objectSerializer = FloatSerializer.getInstance();
                break;
            }
            case "java.lang.Short": {
                objectSerializer = ShortSerializer.getInstance();
                break;
            }
            case "java.lang.Long": {
                objectSerializer = LongSerializer.getInstance();
                break;
            }
            case "java.lang.Byte": {
                objectSerializer = ByteSerializer.getInstance();
                break;
            }
            case "java.math.BigInteger": {
                objectSerializer = BigIntegerSerializer.getInstance();
                break;
            }
            case "java.math.BigDecimal": {
                objectSerializer = BigDecimalSerializer.getInstance();
                break;
            }
            case "java.util.GregorianCalendar": {
                objectSerializer = GregorianCalendarSerializer.getInstance();
                break;
            }
            case "java.util.Random": {
                objectSerializer = RandomSerializer.getInstance();
            }
        }
        return objectSerializer;
    }

    private Serializer getArraySerializer(Class clazz) {
        String string = clazz.getName();
        ArraySerializer arraySerializer = null;
        switch (string) {
            case "[B": {
                arraySerializer = ByteArraySerializer.getInstance();
                break;
            }
            case "[C": {
                arraySerializer = CharArraySerializer.getInstance();
                break;
            }
            case "[D": {
                arraySerializer = DoubleArraySerializer.getInstance();
                break;
            }
            case "[F": {
                arraySerializer = FloatArraySerializer.getInstance();
                break;
            }
            case "[I": {
                arraySerializer = IntArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Byte;": {
                arraySerializer = JLByteArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Character;": {
                arraySerializer = JLCharacterArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Double;": {
                arraySerializer = JLDoubleArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Float;": {
                arraySerializer = JLFloatArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Boolean;": {
                arraySerializer = JLBooleanArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Long;": {
                arraySerializer = JLLongArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Short;": {
                arraySerializer = JLShortArraySerializer.getInstance();
                break;
            }
            case "[J": {
                arraySerializer = LongArraySerializer.getInstance();
                break;
            }
            case "[S": {
                arraySerializer = ShortArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.String;": {
                arraySerializer = StringArraySerializer.getInstance();
                break;
            }
            case "[Z": {
                arraySerializer = BooleanArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Integer;": {
                arraySerializer = JLIntegerArraySerializer.getInstance();
                break;
            }
            case "[Ljava.util.Random;": {
                arraySerializer = RandomArraySerializer.getInstance();
                break;
            }
            case "[[Ljava.lang.Object;": {
                arraySerializer = Object2DArraySerializer.getInstance();
                break;
            }
            case "[Ljava.lang.Object;": {
                arraySerializer = ObjectArraySerializer.getInstance();
            }
        }
        return arraySerializer;
    }
}

