/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;

public class BufferPool {
    private static final String CLASS = BufferPool.class.getName();
    private byte[][] buffers;
    private int index;
    private int bufferLength;
    private int maxBuffers;
    private String name;

    public BufferPool() {
        this("Singleton", 0, 0);
    }

    public BufferPool(String string, int n, int n2) {
        this.name = string;
        this.bufferLength = n;
        if (this.bufferLength > 0) {
            this.maxBuffers = n2;
            this.buffers = new byte[n2][this.bufferLength];
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, string + ": Initialize BufferPool - BufferPool max size: " + this.maxBuffers + " Buffer length: " + this.bufferLength, CLASS, "<init> (int, int):89");
        }
    }

    public int getPoolBufferLength() {
        return this.bufferLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer(int n) {
        byte[] byArray = null;
        byte[][] byArray2 = this.buffers;
        synchronized (this.buffers) {
            if (n == this.bufferLength && this.index > 0) {
                byArray = this.buffers[--this.index];
                this.buffers[this.index] = null;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (byArray != null) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, this.name + ": Take Buffer.  BufferPool size: " + this.index, CLASS, "getBuffer:121");
                }
                return byArray;
            }
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, this.name + ": Create Buffer.  Buffer length: " + n, CLASS, "getBuffer:126");
            }
            return new byte[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBuffer(byte[] byArray) {
        byte[][] byArray2 = this.buffers;
        synchronized (this.buffers) {
            if (byArray != null && byArray.length == this.bufferLength && this.index < this.maxBuffers) {
                this.buffers[this.index++] = byArray;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, this.name + ": Return Buffer.  BufferPool size: " + this.index, CLASS, "releaseBuffer:146");
            }
            return;
        }
    }
}

