/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.BitLevel;
import java.math.Division;

class Conversion {
    static final int[] digitFitInInt = new int[]{-1, -1, 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
    static final int[] bigRadices = new int[]{Integer.MIN_VALUE, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};

    private Conversion() {
    }

    static String bigInteger2String(BigInteger bigInteger, int n) {
        int n2;
        int n3;
        int n4 = bigInteger.sign;
        int n5 = bigInteger.numberLength;
        int[] nArray = bigInteger.digits;
        if (n4 == 0) {
            return "0";
        }
        if (n5 == 1) {
            int n6 = nArray[n5 - 1];
            long l = (long)n6 & 0xFFFFFFFFL;
            if (n4 < 0) {
                l = -l;
            }
            return Long.toString(l, n);
        }
        if (n == 10 || n < 2 || n > 36) {
            return bigInteger.toString();
        }
        double d = Math.log(n) / Math.log(2.0);
        int n7 = (int)((double)bigInteger.abs().bitLength() / d + (double)(n4 < 0 ? 1 : 0)) + 1;
        char[] cArray = new char[n7];
        int n8 = n7;
        if (n != 16) {
            int n9;
            int[] nArray2 = new int[n5];
            System.arraycopy(nArray, 0, nArray2, 0, n5);
            n3 = n5;
            int n10 = digitFitInInt[n];
            int n11 = bigRadices[n - 2];
            do {
                n2 = Division.divideArrayByInt(nArray2, nArray2, n3, n11);
                int n12 = n8;
                do {
                    cArray[--n8] = Character.forDigit(n2 % n, n);
                } while ((n2 /= n) != 0 && n8 != 0);
                int n13 = n10 - n12 + n8;
                for (n9 = 0; n9 < n13 && n8 > 0; ++n9) {
                    cArray[--n8] = 48;
                }
                for (n9 = n3 - 1; n9 > 0 && nArray2[n9] == 0; --n9) {
                }
            } while ((n3 = n9 + 1) != 1 || nArray2[0] != 0);
        } else {
            for (int i = 0; i < n5; ++i) {
                for (n3 = 0; n3 < 8 && n8 > 0; ++n3) {
                    n2 = nArray[i] >> (n3 << 2) & 0xF;
                    cArray[--n8] = Character.forDigit(n2, 16);
                }
            }
        }
        while (cArray[n8] == '0') {
            ++n8;
        }
        if (n4 == -1) {
            cArray[--n8] = 45;
        }
        return new String(cArray, n8, n7 - n8);
    }

    static String toDecimalScaledString(BigInteger bigInteger, int n) {
        int n2;
        int n3 = bigInteger.sign;
        int n4 = bigInteger.numberLength;
        int[] nArray = bigInteger.digits;
        if (n3 == 0) {
            switch (n) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (n < 0) {
                stringBuilder.append("0E+");
            } else {
                stringBuilder.append("0E");
            }
            stringBuilder.append(-n);
            return stringBuilder.toString();
        }
        int n5 = n4 * 10 + 1 + 7;
        char[] cArray = new char[n5 + 1];
        int n6 = n5;
        if (n4 == 1) {
            int n7 = nArray[0];
            if (n7 < 0) {
                long l = (long)n7 & 0xFFFFFFFFL;
                do {
                    long l2 = l;
                    cArray[--n6] = (char)(48 + (int)(l2 - (l /= 10L) * 10L));
                } while (l != 0L);
            } else {
                int n8 = n7;
                do {
                    n2 = n8;
                    cArray[--n6] = (char)(48 + (n2 - (n8 /= 10) * 10));
                } while (n8 != 0);
            }
        } else {
            int[] nArray2 = new int[n4];
            int n9 = n4;
            System.arraycopy(nArray, 0, nArray2, 0, n9);
            block11: while (true) {
                int n10;
                int n11;
                long l = 0L;
                for (n11 = n9 - 1; n11 >= 0; --n11) {
                    long l3 = (l << 32) + ((long)nArray2[n11] & 0xFFFFFFFFL);
                    long l4 = Conversion.divideLongByBillion(l3);
                    nArray2[n11] = (int)l4;
                    l = (int)(l4 >> 32);
                }
                n11 = (int)l;
                int n12 = n6;
                do {
                    cArray[--n6] = (char)(48 + n11 % 10);
                } while ((n11 /= 10) != 0 && n6 != 0);
                int n13 = 9 - n12 + n6;
                for (n10 = 0; n10 < n13 && n6 > 0; ++n10) {
                    cArray[--n6] = 48;
                }
                n10 = n9 - 1;
                while (nArray2[n10] == 0) {
                    if (n10 == 0) break block11;
                    --n10;
                }
                n9 = n10 + 1;
            }
            while (cArray[n6] == '0') {
                ++n6;
            }
        }
        boolean bl = n3 < 0;
        int n14 = n5 - n6 - n - 1;
        if (n == 0) {
            if (bl) {
                cArray[--n6] = 45;
            }
            return new String(cArray, n6, n5 - n6);
        }
        if (n > 0 && n14 >= -6) {
            if (n14 >= 0) {
                n2 = n6 + n14;
                for (int i = n5 - 1; i >= n2; --i) {
                    cArray[i + 1] = cArray[i];
                }
                cArray[++n2] = 46;
                if (bl) {
                    cArray[--n6] = 45;
                }
                return new String(cArray, n6, n5 - n6 + 1);
            }
            for (n2 = 2; n2 < -n14 + 1; ++n2) {
                cArray[--n6] = 48;
            }
            cArray[--n6] = 46;
            cArray[--n6] = 48;
            if (bl) {
                cArray[--n6] = 45;
            }
            return new String(cArray, n6, n5 - n6);
        }
        n2 = n6 + 1;
        int n15 = n5;
        StringBuilder stringBuilder = new StringBuilder(16 + n15 - n2);
        if (bl) {
            stringBuilder.append('-');
        }
        if (n15 - n2 >= 1) {
            stringBuilder.append(cArray[n6]);
            stringBuilder.append('.');
            stringBuilder.append(cArray, n6 + 1, n5 - n6 - 1);
        } else {
            stringBuilder.append(cArray, n6, n5 - n6);
        }
        stringBuilder.append('E');
        if (n14 > 0) {
            stringBuilder.append('+');
        }
        stringBuilder.append(Integer.toString(n14));
        return stringBuilder.toString();
    }

    static String toDecimalScaledString(long l, int n) {
        long l2;
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (l == 0L) {
            switch (n) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (n < 0) {
                stringBuilder.append("0E+");
            } else {
                stringBuilder.append("0E");
            }
            stringBuilder.append(n == Integer.MIN_VALUE ? "2147483648" : Integer.toString(-n));
            return stringBuilder.toString();
        }
        int n2 = 18;
        char[] cArray = new char[n2 + 1];
        int n3 = n2;
        long l3 = l;
        do {
            l2 = l3;
            cArray[--n3] = (char)(48L + (l2 - (l3 /= 10L) * 10L));
        } while (l3 != 0L);
        l2 = (long)n2 - (long)n3 - (long)n - 1L;
        if (n == 0) {
            if (bl) {
                cArray[--n3] = 45;
            }
            return new String(cArray, n3, n2 - n3);
        }
        if (n > 0 && l2 >= -6L) {
            if (l2 >= 0L) {
                int n4 = n3 + (int)l2;
                for (int i = n2 - 1; i >= n4; --i) {
                    cArray[i + 1] = cArray[i];
                }
                cArray[++n4] = 46;
                if (bl) {
                    cArray[--n3] = 45;
                }
                return new String(cArray, n3, n2 - n3 + 1);
            }
            int n5 = 2;
            while ((long)n5 < -l2 + 1L) {
                cArray[--n3] = 48;
                ++n5;
            }
            cArray[--n3] = 46;
            cArray[--n3] = 48;
            if (bl) {
                cArray[--n3] = 45;
            }
            return new String(cArray, n3, n2 - n3);
        }
        int n6 = n3 + 1;
        int n7 = n2;
        StringBuilder stringBuilder = new StringBuilder(16 + n7 - n6);
        if (bl) {
            stringBuilder.append('-');
        }
        if (n7 - n6 >= 1) {
            stringBuilder.append(cArray[n3]);
            stringBuilder.append('.');
            stringBuilder.append(cArray, n3 + 1, n2 - n3 - 1);
        } else {
            stringBuilder.append(cArray, n3, n2 - n3);
        }
        stringBuilder.append('E');
        if (l2 > 0L) {
            stringBuilder.append('+');
        }
        stringBuilder.append(Long.toString(l2));
        return stringBuilder.toString();
    }

    static long divideLongByBillion(long l) {
        long l2;
        long l3;
        if (l >= 0L) {
            long l4 = 1000000000L;
            l3 = l / l4;
            l2 = l % l4;
        } else {
            long l5 = l >>> 1;
            long l6 = 500000000L;
            l3 = l5 / l6;
            l2 = l5 % l6;
            l2 = (l2 << 1) + (l & 1L);
        }
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    static double bigInteger2Double(BigInteger bigInteger) {
        if (bigInteger.numberLength < 2 || bigInteger.numberLength == 2 && bigInteger.digits[1] > 0) {
            return bigInteger.longValue();
        }
        if (bigInteger.numberLength > 32) {
            return bigInteger.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        int n = bigInteger.abs().bitLength();
        long l = n - 1;
        int n2 = n - 54;
        long l2 = bigInteger.abs().shiftRight(n2).longValue();
        long l3 = l2 & 0x1FFFFFFFFFFFFFL;
        if (l == 1023L) {
            if (l3 == 0x1FFFFFFFFFFFFFL) {
                return bigInteger.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (l3 == 0x1FFFFFFFFFFFFEL) {
                return bigInteger.sign > 0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
        }
        if ((l3 & 1L) == 1L && ((l3 & 2L) == 2L || BitLevel.nonZeroDroppedBits(n2, bigInteger.digits))) {
            l3 += 2L;
        }
        long l4 = bigInteger.sign < 0 ? Long.MIN_VALUE : 0L;
        l = 1023L + l << 52 & 0x7FF0000000000000L;
        long l5 = l4 | l | (l3 >>= 1);
        return Double.longBitsToDouble(l5);
    }
}

