/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeAbstract;
import com.ibm.jvm.j9.dump.indexsupport.NodeStack;
import org.xml.sax.Attributes;

public class NodeVMThread
extends NodeAbstract {
    private JavaThread _javaThread;

    public NodeVMThread(JavaRuntime runtime, Attributes attributes) {
        long id = NodeVMThread._longFromString(attributes.getValue("id"));
        long objectID = NodeVMThread._longFromString(attributes.getValue("obj"));
        String state = attributes.getValue("state");
        long monitorID = NodeVMThread._longFromString(attributes.getValue("monitor"));
        long nativeID = NodeVMThread._longFromString(attributes.getValue("native"));
        ImageThread imageThread = runtime.nativeThreadForID(nativeID);
        this._javaThread = new JavaThread(runtime, runtime.pointerInAddressSpace(id), runtime.pointerInAddressSpace(objectID), state, imageThread);
        long blockedID = 0L;
        long waitingID = 0L;
        if (null != state) {
            blockedID = state.equals("Blocked") ? monitorID : 0L;
            waitingID = state.equals("Waiting") ? monitorID : 0L;
        }
        runtime.addThread(this._javaThread, blockedID, waitingID);
    }

    @Override
    public IParserNode nodeToPushAfterStarting(String uri, String localName, String qName, Attributes attributes) {
        IParserNode child = null;
        if (qName.equals("stack")) {
            child = new NodeStack(this._javaThread, attributes);
        } else {
            if (qName.equals("error")) {
                this._javaThread.setStackCorrupt();
            }
            child = super.nodeToPushAfterStarting(uri, localName, qName, attributes);
        }
        return child;
    }
}

