/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Format2Tprof {
    final String Trc_JIT_Component_Name = "j9jit";
    final int Trc_JIT_Sampling_Id = 13;
    final int Trc_JIT_Sampling_Detail_Id = 14;
    final char FS = (char)9;
    final String TraceEntryPrefix = "SamplingLog";
    static int totalCount = 0;

    public void run(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Format2Tprof <trace format input> [tprof output]");
            return;
        }
        LinkedList sampleMethodTable = new LinkedList();
        if (!this.readAndFormat(args, sampleMethodTable)) {
            System.err.println("No method sampling event found in the trace.  No output will be written.");
            return;
        }
        Collections.sort(sampleMethodTable);
        totalCount = sampleMethodTable.size();
        this.countSampleMethod(sampleMethodTable);
        Collections.sort(sampleMethodTable, new Comparator(){

            public int compare(Object o1, Object o2) {
                MethodEntry m1 = (MethodEntry)o1;
                MethodEntry m2 = (MethodEntry)o2;
                return m2.count - m1.count;
            }
        });
        try {
            PrintStream ps = System.out;
            if (args.length == 2) {
                ps = new PrintStream(new FileOutputStream(args[1]));
            }
            this.generateTprofOutput(ps, sampleMethodTable);
            if (args.length == 2) {
                ps.close();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Error processing output file");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Format2Tprof pf = new Format2Tprof();
        pf.run(args);
    }

    public void countSampleMethod(Collection s) {
        Iterator iter = s.iterator();
        MethodEntry pe = (MethodEntry)iter.next();
        ++pe.count;
        while (iter.hasNext()) {
            MethodEntry e = (MethodEntry)iter.next();
            if (pe.equals(e)) {
                iter.remove();
            } else {
                pe = e;
            }
            ++pe.count;
        }
    }

    public void generateTprofOutput(PrintStream out, Collection s) {
        for (MethodEntry e : s) {
            float percent = (float)(e.count * 100) / (float)totalCount;
            String percentStr = new Float(percent).toString().substring(0, 4) + "%";
            out.println(percentStr + " " + e.count + " " + e.name);
        }
    }

    public MethodEntry getJittedMethod(String msg) {
        int secondTabPos;
        int firstTabPos = msg.indexOf(9);
        int n = secondTabPos = firstTabPos != -1 ? msg.indexOf(9, firstTabPos + 1) : -1;
        if (firstTabPos == -1 || secondTabPos == -1) {
            return null;
        }
        String name = msg.substring(firstTabPos + 1, secondTabPos - 1);
        int thirdTabPos = msg.indexOf(9, secondTabPos + 1);
        if (thirdTabPos == -1) {
            return new MethodEntry(name);
        }
        int fourthTabPos = msg.indexOf(9, thirdTabPos + 1);
        if (fourthTabPos == -1) {
            return new MethodEntry(name, msg.substring(thirdTabPos + 1));
        }
        return new MethodEntry(name, msg.substring(thirdTabPos + 1, fourthTabPos - 1));
    }

    public boolean readAndFormat(String[] args, List methodTable) {
        boolean rc = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(args[0]));
            String line = null;
            while ((line = in.readLine()) != null) {
                String formattedData;
                MethodEntry me;
                int pos = line.indexOf("SamplingLog");
                if (pos == -1 || (me = this.getJittedMethod(formattedData = line.substring(pos))) == null) continue;
                rc = true;
                methodTable.add(me);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening trace file");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Error processing trace file");
            e.printStackTrace();
        }
        return rc;
    }

    public class MethodEntry
    implements Comparable {
        public String name = null;
        public String offset = null;
        public int count = 0;

        public MethodEntry(String n, String o) {
            this.name = n;
            this.offset = o;
        }

        public MethodEntry(String n) {
            this.name = n;
        }

        public boolean equals(Object o) {
            MethodEntry e = (MethodEntry)o;
            return this.name.equals(e.name);
        }

        public int compareTo(Object o) {
            MethodEntry e = (MethodEntry)o;
            return this.name.compareTo(e.name);
        }
    }
}

