/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.parser.tprof;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TprofParser
implements LineParser {
    private static final String CLASSNAME = TprofParser.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(TprofParser.class);
    private static final DataFactory factory = DataFactory.getFactory();
    private static final String EYECATCHER_START = "tprofdatastart";
    private static final String EYECATCHER_END = "tprofdataend";
    private static final Pattern DELIMITER_REGEX = Pattern.compile("([0-9]+?),(.*?),([0-9]+?),(.*?),(.+?),(.+?),([0-9]+)");
    private static double currentTimestamp;
    private AxisPair numberAxisPair = null;
    private HashMap<String, Object> currentTprofTree;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = AxisUtil.prepareNumberAxis(outputProperties);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.populateTprofData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    private DataBuilder getTprofData(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.PROFILING);
        Data data = null;
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
            data = subsystemDataBuilder.getTopLevelData(JVMLabels.TPROF);
            if (data == null) {
                data = this.createTprofData(subsystemDataBuilder);
            }
        } else {
            SubsystemDataBuilder subsystemDataBuilder = this.createProfilingSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
            data = this.createTprofData(subsystemDataBuilder);
        }
        return data;
    }

    private SubsystemDataBuilder createProfilingSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(JVMLabels.PROFILING, "com.ibm.java.diagnostics.healthcenter.methodprofiling.perspective");
        return subsystemDataBuilder;
    }

    private DataBuilder createTprofData(SubsystemDataBuilder subsystemDataBuilder) {
        TwoDimensionalDataImpl twoDimensionalDataImpl = new TwoDimensionalDataImpl(JVMLabels.TPROF, this.numberAxisPair);
        subsystemDataBuilder.addData(twoDimensionalDataImpl);
        return twoDimensionalDataImpl;
    }

    private boolean populateTprofData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (string.startsWith(EYECATCHER_START)) {
                currentTimestamp = new Double(string.split(",")[1]);
                this.currentTprofTree = new HashMap();
                continue;
            }
            if (string.startsWith(EYECATCHER_END)) {
                this.storeData(dataBuilder);
                currentTimestamp = 0.0;
                continue;
            }
            Matcher matcher = DELIMITER_REGEX.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            String string5 = matcher.group(4);
            String string6 = matcher.group(5);
            String string7 = matcher.group(6);
            String string8 = matcher.group(7);
            if (string2 == null || string3 == null || string4 == null || string5 == null || string6 == null || string7 == null || string8 == null) continue;
            String string9 = "Process " + string2 + " " + string3;
            String string10 = "Thread " + string4 + " " + string5;
            String string11 = "Module " + string6;
            String string12 = "Symbol " + string7;
            int n = Integer.parseInt(string8);
            this.addToTprofTree(string9, string10, string11, string12, n);
            bl = true;
        }
        return bl;
    }

    private void incrementTreeLevelSamples(DataBuilder dataBuilder, String string, int n) {
        string = "NumberOfSamples:" + string;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        this.createNewDataPoint(currentTimestamp, n, dataBuilder2);
    }

    private void addSymbolNameToSamplesTree(DataBuilder dataBuilder, String string, int n) {
        DataBuilder dataBuilder2 = this.getDataLevel(dataBuilder, string);
        DataBuilder dataBuilder3 = dataBuilder2.getTopLevelData(string = "NumberOfSamples:" + string);
        if (dataBuilder3 == null) {
            dataBuilder3 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder2.addData(dataBuilder3);
        }
        this.createNewDataPoint(currentTimestamp, n, dataBuilder3);
    }

    private DataBuilder getDataLevel(DataBuilder dataBuilder, String string) {
        DataBuilder dataBuilder2;
        DataBuilder dataBuilder3 = dataBuilder.getTopLevelData(string);
        if (dataBuilder3 != null) {
            dataBuilder2 = dataBuilder3;
        } else {
            dataBuilder2 = this.createDataLevel(string);
            dataBuilder.addData(dataBuilder2);
        }
        return dataBuilder2;
    }

    private DataBuilder createDataLevel(String string) {
        TwoDimensionalDataImpl twoDimensionalDataImpl = new TwoDimensionalDataImpl(string, this.numberAxisPair);
        return twoDimensionalDataImpl;
    }

    private void createNewDataPoint(double d, int n, DataBuilder dataBuilder) {
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, n, this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder).addDataPointBuilder(dataPointImpl);
    }

    private void addToTprofTree(String string, String string2, String string3, String string4, int n) {
        if (this.currentTprofTree.containsKey(string)) {
            HashMap hashMap = (HashMap)this.currentTprofTree.get(string);
            this.incrementNumberOfSamples(hashMap, n);
            if (hashMap.containsKey(string2)) {
                HashMap hashMap2 = (HashMap)hashMap.get(string2);
                this.incrementNumberOfSamples(hashMap2, n);
                if (hashMap2.containsKey(string3)) {
                    HashMap hashMap3 = (HashMap)hashMap2.get(string3);
                    this.incrementNumberOfSamples(hashMap3, n);
                    if (hashMap3.containsKey(string4)) {
                        HashMap hashMap4 = (HashMap)hashMap3.get(string4);
                        this.incrementNumberOfSamples(hashMap4, n);
                    } else {
                        this.createTprofTreeSymbolNameDownwards(hashMap3, string4, n);
                    }
                } else {
                    this.createTprofTreeModuleNameDownwards(hashMap2, string3, string4, n);
                }
            } else {
                this.createTprofTreeTidDownwards(hashMap, string2, string3, string4, n);
            }
        } else {
            this.createTprofTreePidDownwards(string, string2, string3, string4, n);
        }
    }

    private void createTprofTreePidDownwards(String string, String string2, String string3, String string4, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("NumberOfSamples", n);
        this.createTprofTreeTidDownwards(hashMap, string2, string3, string4, n);
        this.currentTprofTree.put(string, hashMap);
    }

    private void createTprofTreeTidDownwards(HashMap<String, Object> hashMap, String string, String string2, String string3, int n) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("NumberOfSamples", n);
        this.createTprofTreeModuleNameDownwards(hashMap2, string2, string3, n);
        hashMap.put(string, hashMap2);
    }

    private void createTprofTreeModuleNameDownwards(HashMap<String, Object> hashMap, String string, String string2, int n) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("NumberOfSamples", n);
        this.createTprofTreeSymbolNameDownwards(hashMap2, string2, n);
        hashMap.put(string, hashMap2);
    }

    private void createTprofTreeSymbolNameDownwards(HashMap<String, Object> hashMap, String string, int n) {
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put("NumberOfSamples", n);
        hashMap.put(string, hashMap2);
    }

    private void incrementNumberOfSamples(HashMap<String, Object> hashMap, int n) {
        int n2 = (Integer)hashMap.get("NumberOfSamples");
        hashMap.put("NumberOfSamples", n2 + n);
    }

    private void storeData(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = this.getTprofData(dataBuilder);
        DataBuilder dataBuilder3 = this.getDataLevel(dataBuilder2, "NumberOfSamples");
        Set<Map.Entry<String, Object>> set = this.currentTprofTree.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String string = entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            this.storePid(entry, string, hashMap, dataBuilder2, dataBuilder3);
        }
    }

    private void storePid(Map.Entry entry, String string, HashMap<String, Object> hashMap, DataBuilder dataBuilder, DataBuilder dataBuilder2) {
        DataBuilder dataBuilder3 = this.getDataLevel(dataBuilder, string);
        Set<Map.Entry<String, Object>> set = hashMap.entrySet();
        for (Map.Entry<String, Object> entry2 : set) {
            String string2 = entry2.getKey();
            String string3 = "PID:" + string;
            DataBuilder dataBuilder4 = this.getDataLevel(dataBuilder2, string3);
            if (string2.equals("NumberOfSamples")) {
                int n = (Integer)hashMap.get("NumberOfSamples");
                this.incrementTreeLevelSamples(dataBuilder4, string3, n);
                continue;
            }
            this.storeTid(entry2, string2, dataBuilder, dataBuilder3, dataBuilder4);
        }
    }

    private void storeTid(Map.Entry entry, String string, DataBuilder dataBuilder, DataBuilder dataBuilder2, DataBuilder dataBuilder3) {
        HashMap hashMap = (HashMap)entry.getValue();
        DataBuilder dataBuilder4 = this.getDataLevel(dataBuilder2, string);
        Set set = hashMap.entrySet();
        for (Map.Entry entry2 : set) {
            String string2 = (String)entry2.getKey();
            String string3 = "TID:" + string;
            DataBuilder dataBuilder5 = this.getDataLevel(dataBuilder3, string3);
            if (string2.equals("NumberOfSamples")) {
                int n = (Integer)hashMap.get("NumberOfSamples");
                this.incrementTreeLevelSamples(dataBuilder5, string3, n);
                continue;
            }
            this.storeModuleName(entry2, string2, dataBuilder, dataBuilder4, dataBuilder5);
        }
    }

    private void storeModuleName(Map.Entry entry, String string, DataBuilder dataBuilder, DataBuilder dataBuilder2, DataBuilder dataBuilder3) {
        HashMap hashMap = (HashMap)entry.getValue();
        DataBuilder dataBuilder4 = this.getDataLevel(dataBuilder2, string);
        Set set = hashMap.entrySet();
        for (Map.Entry entry2 : set) {
            String string2 = (String)entry2.getKey();
            String string3 = "MODULE_NAME:" + string;
            DataBuilder dataBuilder5 = this.getDataLevel(dataBuilder3, string3);
            if (string2.equals("NumberOfSamples")) {
                int n = (Integer)hashMap.get("NumberOfSamples");
                this.incrementTreeLevelSamples(dataBuilder5, string3, n);
                continue;
            }
            this.storeSymbolName(entry2, string2, dataBuilder, dataBuilder4, dataBuilder5);
        }
    }

    private void storeSymbolName(Map.Entry entry, String string, DataBuilder dataBuilder, DataBuilder dataBuilder2, DataBuilder dataBuilder3) {
        HashMap hashMap = (HashMap)entry.getValue();
        DataBuilder dataBuilder4 = dataBuilder2.getTopLevelData(string);
        Set set = hashMap.entrySet();
        for (Map.Entry entry2 : set) {
            String string2 = (String)entry2.getKey();
            if (!string2.equals("NumberOfSamples")) continue;
            int n = (Integer)entry2.getValue();
            if (dataBuilder4 == null) {
                dataBuilder4 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
                dataBuilder2.addData(dataBuilder4);
            }
            String string3 = "SYMBOL_NAME: " + string;
            this.addSymbolNameToSamplesTree(dataBuilder3, string3, n);
            this.createNewDataPoint(currentTimestamp, n, dataBuilder4);
        }
    }
}

