/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.MonitoringDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HealthCenter
implements HealthCenterMBean {
    static final String DEBUG_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.debug";
    public static final int UNLIMITED_MAXSEND = -1;
    public static final boolean isDebug = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.debug") != null;
    private int currentSession = -1;
    private static final int MIN_SESSION_NUMBER = 0;
    private final List<DataProvider> dataProviders;
    private final int _processId;
    private static final int DEFAULT_CLIENT_TIMEOUT = 600000;
    private int clientTimeout = 600000;
    private long lastConnectTime = 0L;
    private HealthCenterOptionHandler handler;
    private AgentInfo agentInfo;

    public static native String[] getProviders();

    public static native boolean isTraceSubscriberAvailable();

    public HealthCenter(int n, HealthCenterOptionHandler healthCenterOptionHandler) {
        this.handler = healthCenterOptionHandler;
        this._processId = n;
        this.dataProviders = new ArrayList<DataProvider>();
        this.agentInfo = new AgentInfo();
        this.registerDataProviders(healthCenterOptionHandler);
    }

    @Override
    public byte[] getJMXData(int n, int n2) throws HealthCenterClientConnectedException {
        this.checkValidSession(n2);
        if (n >= 0 && n < this.dataProviders.size()) {
            DataProvider dataProvider = this.dataProviders.get(n);
            try {
                return dataProvider.getJMXData();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return dataProvider.getJMXData();
            }
        }
        String string = MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), n);
        return string.getBytes();
    }

    @Override
    public void resetJMXData(int n, int n2) throws HealthCenterClientConnectedException {
        this.checkValidSession(n2);
        if (n >= 0 && n < this.dataProviders.size()) {
            DataProvider dataProvider = this.dataProviders.get(n);
            dataProvider.resetData();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), n));
        }
    }

    public void resetForHeadless(int n, int n2) {
        if (n >= 0 && n < this.dataProviders.size()) {
            DataProvider dataProvider = this.dataProviders.get(n);
            dataProvider.headlessFileInitialise();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), n));
        }
    }

    private void registerDataProviders(HealthCenterOptionHandler healthCenterOptionHandler) {
        String[] stringArray = HealthCenter.getProviders();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addDataProvider(new MonitoringDataProvider(stringArray[i]));
        }
    }

    private void addDataProvider(DataProvider dataProvider) {
        this.dataProviders.add(dataProvider);
        if (isDebug) {
            System.out.println(MessageFormat.format("Added value {0} to position {1}  in _sources array", dataProvider, this.dataProviders.size()));
        }
    }

    @Override
    public List<Map<String, String>> getLiveSourceDetails() {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (DataProvider dataProvider : this.dataProviders) {
            arrayList.add(dataProvider.getLiveSourceDetails());
        }
        return arrayList;
    }

    @Override
    public synchronized int startSession() {
        if (this.handler.getDataCollectionLevel() == DataCollectionLevel.OFF) {
            this.handler.setDataCollectionLevel(DataCollectionLevel.FULL);
        }
        Iterator<DataProvider> iterator = this.dataProviders.iterator();
        while (iterator.hasNext()) {
            DataProvider dataProvider = iterator.next();
            dataProvider.startSession();
            boolean bl = dataProvider.isDataSupported();
            if (bl) continue;
            if (isDebug) {
                System.out.println(MessageFormat.format("Removing value {0} from position {1} in dataProviders list", dataProvider, this.dataProviders.indexOf(dataProvider)));
            }
            iterator.remove();
        }
        if (this.currentSession < Integer.MAX_VALUE) {
            ++this.currentSession;
            this.lastConnectTime = System.currentTimeMillis();
        }
        return this.currentSession;
    }

    private void checkValidSession(int n) throws HealthCenterClientConnectedException {
        String string;
        if (isDebug) {
            string = Messages.getString("HealthCenter.checking.session");
            System.out.println(MessageFormat.format(string, n, this.currentSession));
        }
        if (n > this.currentSession || n < 0) {
            throw new IllegalArgumentException(Messages.getString("HealthCenter.invalid.session.identifier"));
        }
        if (n != this.currentSession) {
            string = Messages.getString("HealthCenter.invalid.session.error.message");
            throw new HealthCenterClientConnectedException(string);
        }
        this.lastConnectTime = System.currentTimeMillis();
    }

    @Override
    public boolean isClientsConnected() {
        boolean bl = false;
        if (this.currentSession >= 0) {
            long l = System.currentTimeMillis() - this.lastConnectTime;
            bl = l < (long)this.clientTimeout;
        }
        return bl;
    }

    @Override
    public void setClientTimeout(int n) {
        this.clientTimeout = n;
    }

    @Override
    public void modify(int n, int n2, String string, String ... stringArray) throws HealthCenterClientConnectedException, ProviderModificationException {
        this.checkValidSession(n2);
        if (n >= 0 && n < this.dataProviders.size()) {
            DataProvider dataProvider = this.dataProviders.get(n);
            dataProvider.modify(string, stringArray);
        }
    }

    @Override
    public void restartProvider(int n, int n2) throws HealthCenterClientConnectedException {
        this.checkValidSession(n2);
        if (n >= 0 && n < this.dataProviders.size()) {
            DataProvider dataProvider = this.dataProviders.get(n);
            dataProvider.restartProvider();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), n));
        }
    }

    @Override
    public boolean isHardRealtimeVM() {
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    @Override
    public boolean isSoftRealtimeVM() {
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("soft");
        }
        return false;
    }

    @Override
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public static native void isLoaded();
}

