/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataChangedEvent;
import com.ibm.java.diagnostics.common.datamodel.data.DataListener;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.common.util.weak.WeakHashSet;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class DataImpl
implements DataBuilder {
    private static final int MAXIMUM_NOTIFICATION_FREQUENCY = 500;
    private static final String CLASS_NAME = DataImpl.class.getName();
    private static final String NOTIFY_LISTENERS_METHOD = "notifyListeners";
    protected static final DataBuilder[] dataTemplateArray = new DataBuilder[0];
    private Set<DataListener> dataSetListeners;
    private Object dataSetListenersLock = new Object();
    protected String label;
    protected URL icon;
    private Status status;
    protected final String id;
    private static final Logger TRACE = LogFactory.getTrace(DataImpl.class);
    private DataImpl parent;
    private boolean isEnabled = true;
    private Map<String, DataBuilder> children;
    private DataBuilder child;
    protected boolean isPostProcessedData = false;
    private boolean isRegistered = false;
    private boolean notificationsEnabled = true;
    private long lastNotificationTime;

    protected DataImpl(String string) {
        this(string, string);
    }

    protected DataImpl(String string, String string2) {
        this.id = string;
        this.label = string2;
        this.status = Status.BLANK;
    }

    @Override
    public int compareTo(Data data) {
        return this.getLabel().compareTo(data.getLabel());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void populate() {
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0 || this.child != null;
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public synchronized DataBuilder[] getChildren() {
        if (this.child != null) {
            return new DataBuilder[]{this.child};
        }
        if (this.children != null) {
            return this.children.values().toArray(dataTemplateArray);
        }
        return dataTemplateArray;
    }

    @Override
    public synchronized DataBuilder getTopLevelData(String string) {
        DataBuilder dataBuilder = null;
        if (this.child != null) {
            if (this.child.getID().equals(string)) {
                dataBuilder = this.child;
            }
        } else if (this.children != null) {
            dataBuilder = this.children.get(string);
        }
        return dataBuilder;
    }

    @Override
    public synchronized DataBuilder getData(String string) {
        DataBuilder dataBuilder = null;
        if (this.getID().equals(string)) {
            return this;
        }
        if (string != null && (this.children != null || this.child != null) && (dataBuilder = this.getTopLevelData(string)) == null) {
            if (this.child != null) {
                dataBuilder = this.child.getData(string);
            } else if (this.children != null) {
                Iterator<DataBuilder> iterator = this.children.values().iterator();
                while (iterator.hasNext() && dataBuilder == null) {
                    dataBuilder = iterator.next().getData(string);
                }
            }
        }
        return dataBuilder;
    }

    protected synchronized void mergeData(DataImpl dataImpl) {
        DataBuilder[] dataBuilderArray = dataImpl.getChildren();
        if (dataBuilderArray.length > 0) {
            for (DataBuilder dataBuilder : dataBuilderArray) {
                this.addData(dataBuilder, false);
            }
        }
    }

    protected final boolean isPostprocessing() {
        DataImpl dataImpl = this;
        while (dataImpl.getParent() != null) {
            dataImpl = dataImpl.getParent();
        }
        return dataImpl.getPostProcessing();
    }

    protected boolean getPostProcessing() {
        return false;
    }

    public void deleteDataOlderThanTime(double d) {
    }

    @Override
    public synchronized void removeData(String string) {
        if (this.child != null && this.child.getID().equals(string)) {
            this.child = null;
        }
        if (this.children != null) {
            this.children.remove(string);
        }
    }

    @Override
    public synchronized void addData(DataBuilder dataBuilder) {
        this.addData(dataBuilder, true);
    }

    private synchronized void addData(DataBuilder dataBuilder, boolean bl) {
        if (dataBuilder != null && this != dataBuilder) {
            if (dataBuilder instanceof DataImpl) {
                ((DataImpl)dataBuilder).setParent(this);
            }
            if (this.child == null && this.children == null) {
                this.child = dataBuilder;
            } else if (this.children == null && this.child != null) {
                this.children = this.createNewDataMap();
                this.children.put(this.child.getID(), this.child);
                this.child = null;
            }
            String string = dataBuilder.getID();
            if (this.isPostprocessing() && !this.isPostProcessedData) {
                if (!this.isRegistered) {
                    this.registerAsMixed(this);
                    this.isRegistered = true;
                }
                if (dataBuilder instanceof DataImpl) {
                    ((DataImpl)dataBuilder).isPostProcessedData = true;
                }
            }
            if (this.isPostProcessedData && !this.isPostprocessing() && bl) {
                TRACE.warning(MessageFormat.format(Messages.getString("DataImpl.parsed.data.on.postprocessed.parent"), dataBuilder.getLabel(), this.getLabel()));
            }
            if (this.children != null) {
                Data data = this.children.get(string);
                if (data instanceof DataImpl && dataBuilder instanceof DataImpl) {
                    ((DataImpl)data).mergeData((DataImpl)dataBuilder);
                } else {
                    this.children.put(string, dataBuilder);
                }
            }
            this.notifyListeners();
        }
    }

    protected void registerAsMixed(DataImpl dataImpl) {
        if (this.getParent() != null) {
            this.getParent().registerAsMixed(dataImpl);
        }
    }

    protected void setParent(DataImpl dataImpl) {
        this.parent = dataImpl;
    }

    public synchronized void clear() {
        this.children = null;
        this.child = null;
        this.isRegistered = false;
    }

    protected Map<String, DataBuilder> createNewDataMap() {
        return new HashMap<String, DataBuilder>();
    }

    public synchronized void clearPostprocessedData() {
        block4: {
            block3: {
                if (this.child == null) break block3;
                if (!(this.child instanceof DataImpl)) break block4;
                DataImpl dataImpl = (DataImpl)this.child;
                if (!dataImpl.isPostProcessedData) break block4;
                this.child = null;
                break block4;
            }
            if (this.children != null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Data object : this.children.values()) {
                    if (!(object instanceof DataImpl)) continue;
                    DataImpl dataImpl = (DataImpl)object;
                    if (!dataImpl.isPostProcessedData) continue;
                    hashSet.add(object.getID());
                }
                for (String string : hashSet) {
                    this.children.remove(string);
                }
            }
        }
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            this.notifyListeners();
        }
    }

    public String toString() {
        return this.label;
    }

    protected void evaluateDataForDeletion(double d, String string) {
    }

    protected void deleteHalfTheData() {
    }

    @Override
    public synchronized void removeOldDataBeforeTime(double d, String string) {
        DataBuilder[] dataBuilderArray = this.getChildren();
        this.evaluateDataForDeletion(d, string);
        for (DataBuilder dataBuilder : dataBuilderArray) {
            dataBuilder.removeOldDataBeforeTime(d, string);
        }
    }

    @Override
    public void truncateData() {
        DataBuilder[] dataBuilderArray = this.getChildren();
        this.deleteHalfTheData();
        for (DataBuilder dataBuilder : dataBuilderArray) {
            dataBuilder.truncateData();
        }
    }

    @Override
    public synchronized void updateXValues(double d) {
        DataBuilder[] dataBuilderArray = this.getChildren();
        this.updateDataPointXValues(d);
        for (DataBuilder dataBuilder : dataBuilderArray) {
            dataBuilder.updateXValues(d);
        }
    }

    protected void updateDataPointXValues(double d) {
    }

    protected DataPointBuilder getCurrentNodeBiggestXAxisValue() {
        return null;
    }

    protected DataPointBuilder getCurrentNodeSmallestXAxisValue() {
        return null;
    }

    @Override
    public DataPointBuilder getLargestOverallXAxisValue() {
        DataPointBuilder dataPointBuilder = this.getCurrentNodeBiggestXAxisValue();
        DataBuilder[] dataBuilderArray = this.getChildren();
        String string = UnitLabels.MILLISECONDS;
        for (DataBuilder dataBuilder : dataBuilderArray) {
            DataPointBuilder dataPointBuilder2 = dataBuilder.getLargestOverallXAxisValue();
            if (dataPointBuilder != null && dataPointBuilder2 != null) {
                double d = dataPointBuilder.getX(string);
                double d2 = dataPointBuilder2.getX(string);
                if (!(d2 > d)) continue;
                dataPointBuilder = dataPointBuilder2;
                continue;
            }
            if (dataPointBuilder2 == null) continue;
            dataPointBuilder = dataPointBuilder2;
        }
        return dataPointBuilder;
    }

    @Override
    public DataPointBuilder getEarliestOverallXAxisValue() {
        DataPointBuilder dataPointBuilder = this.getCurrentNodeSmallestXAxisValue();
        DataBuilder[] dataBuilderArray = this.getChildren();
        String string = UnitLabels.MILLISECONDS;
        for (DataBuilder dataBuilder : dataBuilderArray) {
            DataPointBuilder dataPointBuilder2 = dataBuilder.getEarliestOverallXAxisValue();
            if (dataPointBuilder != null && dataPointBuilder2 != null) {
                double d = dataPointBuilder.getX(string);
                double d2 = dataPointBuilder2.getX(string);
                if (!(d2 < d)) continue;
                dataPointBuilder = dataPointBuilder2;
                continue;
            }
            if (dataPointBuilder2 == null) continue;
            dataPointBuilder = dataPointBuilder2;
        }
        return dataPointBuilder;
    }

    @Override
    public long getDataPointMemoryUse() {
        long l = 0L;
        DataBuilder[] dataBuilderArray = this.getChildren();
        l = this.countDataPoints();
        for (DataBuilder dataBuilder : dataBuilderArray) {
            l += dataBuilder.getDataPointMemoryUse();
        }
        return l;
    }

    protected long countDataPoints() {
        return 128L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataListener(DataListener dataListener) {
        if (dataListener != null) {
            Object object = this.dataSetListenersLock;
            synchronized (object) {
                if (this.dataSetListeners == null) {
                    this.dataSetListeners = new WeakHashSet<DataListener>();
                }
                this.dataSetListeners.add(dataListener);
            }
            this.lastNotificationTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDataListeners() {
        Object object = this.dataSetListenersLock;
        synchronized (object) {
            if (this.dataSetListeners != null) {
                this.dataSetListeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataListener(DataListener dataListener) {
        Object object = this.dataSetListenersLock;
        synchronized (object) {
            if (this.dataSetListeners != null) {
                this.dataSetListeners.remove(dataListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        long l;
        if (this.notificationsEnabled && (l = System.currentTimeMillis()) - this.lastNotificationTime > (long)this.getMaximumNotificationFrequency()) {
            this.lastNotificationTime = l;
            DataChangedEvent dataChangedEvent = new DataChangedEvent(this);
            Object object = this.dataSetListenersLock;
            synchronized (object) {
                if (this.dataSetListeners != null) {
                    for (DataListener dataListener : this.dataSetListeners) {
                        dataListener.dataChanged(dataChangedEvent);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(DataChangedEvent dataChangedEvent) {
        Object object = this.dataSetListenersLock;
        synchronized (object) {
            if (this.dataSetListeners != null) {
                for (DataListener dataListener : this.dataSetListeners) {
                    dataListener.dataChanged(dataChangedEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNotifyListeners() {
        TRACE.entering(CLASS_NAME, NOTIFY_LISTENERS_METHOD);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(this);
        Object object = this.dataSetListenersLock;
        synchronized (object) {
            if (this.dataSetListeners != null) {
                for (DataListener dataListener : this.dataSetListeners) {
                    dataListener.dataChanged(dataChangedEvent);
                }
            }
        }
        TRACE.exiting(CLASS_NAME, NOTIFY_LISTENERS_METHOD);
    }

    protected int getMaximumNotificationFrequency() {
        return 500;
    }

    protected void enableNotifications() {
        this.notificationsEnabled = true;
    }

    protected void disableNotifications() {
        this.notificationsEnabled = false;
    }

    @Override
    public DataImpl getParent() {
        return this.parent;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public DataBuilder findRootData() {
        if (this.getParent() != null) {
            return this.getDataParent(this.getParent());
        }
        return this;
    }

    private DataBuilder getDataParent(Data data) {
        if (((DataBuilder)data).getParent() != null) {
            return this.getDataParent(((DataBuilder)data).getParent());
        }
        return (DataBuilder)data;
    }
}

