/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECParameters;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyRep;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;

public final class ECPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962695L;
    private static final boolean debugPublicKeyBytes = false;
    private BigInteger s;
    private ECParameterSpec params;
    private ECPublicKey publicKey = null;
    private byte[] publicKeyBytes = null;
    private static final String[] z;

    public ECPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
            this.a();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this(bigInteger, eCParameterSpec, null);
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec, ECPublicKey eCPublicKey) throws InvalidKeyException, InvalidParameterSpecException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        this.publicKey = eCPublicKey;
        if (this.publicKey == null) {
            try {
                this.publicKey = ECPrivateKey.a(bigInteger, eCParameterSpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AlgorithmParameters algorithmParameters = ECParameters.a(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, algorithmParameters);
        try {
            byte[] byArray = ECParameters.a(bigInteger.toByteArray());
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            ObjectIdentifier objectIdentifier = eCNamedCurve != null ? ECNamedCurve.getOIDFromName(eCNamedCurve.getName()) : null;
            ObjectIdentifier objectIdentifier2 = objectIdentifier;
            byte[] byArray2 = this.publicKey != null ? ECParameters.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve()) : null;
            byte[] byArray3 = byArray2;
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(byArray, objectIdentifier2, byArray3);
            this.key = eCPrivateKey.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(RFC5915ECPrivateKeyEncodedKeySpec rFC5915ECPrivateKeyEncodedKeySpec) throws InvalidKeyException {
        try {
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(rFC5915ECPrivateKeyEncodedKeySpec.getEncoded());
            this.key = rFC5915ECPrivateKeyEncodedKeySpec.getEncoded();
            this.s = new BigInteger(1, eCPrivateKey.getKeyBytes());
            ObjectIdentifier objectIdentifier = eCPrivateKey.getNamedCurve();
            if (objectIdentifier == null) {
                throw new InvalidKeyException(z[3]);
            }
            this.params = ECNamedCurve.a(objectIdentifier);
            this.publicKeyBytes = eCPrivateKey.getPublicKeyBytes();
            this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(this.params));
            this.a();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(invalidParameterSpecException);
        }
    }

    protected void parseKeyBits() throws IOException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                throw new IOException(z[8]);
            }
            this.params = ECUtils.getPrimeParameterSpec(algorithmParameters.getParameterSpec(ECParameterSpec.class));
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(this.key);
            this.s = new BigInteger(1, eCPrivateKey.getKeyBytes());
            this.publicKeyBytes = eCPrivateKey.getPublicKeyBytes();
        }
        catch (IOException iOException) {
            throw new IOException(z[7]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[6]);
        }
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public ECPublicKey getPublicKey() {
        block10: {
            block11: {
                if (this.publicKey != null) break block10;
                if (this.publicKeyBytes == null) break block11;
                try {
                    this.publicKey = new ECPublicKey(ECParameters.decodePoint(this.publicKeyBytes, this.params.getCurve()), this.params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.publicKey == null) {
                try {
                    this.publicKey = ECPrivateKey.a(this.s, this.params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.publicKey == null) {
                throw new RuntimeException(z[4]);
            }
        }
        return this.publicKey;
    }

    public byte[] getEncoded(String string) {
        if (string.equals(z[0])) {
            return this.getEncoded();
        }
        if (string.equals(z[1])) {
            return this.key;
        }
        throw new InvalidParameterException(z[2] + string);
    }

    private static ECPublicKey a(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        PrimeCurve primeCurve = ECUtils.getPrimeCurve(eCParameterSpec.getCurve());
        ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(eCParameterSpec.getGenerator())).getAffine();
        return new ECPublicKey(eCPoint, eCParameterSpec);
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    private void a() {
        if (this.publicKeyBytes == null) {
            return;
        }
        try {
            ECPoint eCPoint = ECParameters.decodePoint(this.publicKeyBytes, this.params.getCurve());
            if (this.publicKey == null) {
                this.publicKey = new ECPublicKey(eCPoint, this.params);
            }
            return;
        }
        catch (Exception exception) {
            try {
                if (this.publicKey == null) {
                    this.publicKey = ECPrivateKey.a(this.s, this.params);
                }
                if (!Arrays.equals(this.publicKeyBytes, this.publicKey.getEncoded())) {
                    return;
                }
                this.publicKeyBytes = ECParameters.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve());
                com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(this.key);
                com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey2 = new com.ibm.security.rfc5915.ECPrivateKey(eCPrivateKey.getKeyBytes(), eCPrivateKey.getNamedCurve(), this.publicKeyBytes);
                this.key = eCPrivateKey2.getEncoded();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new InvalidObjectException(z[5]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\"{h<6J";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                block19: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block19;
                    n5 = n5;
                    if (n5 <= n4) break block20;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 114;
                            break;
                        }
                        case 1: {
                            n6 = 48;
                            break;
                        }
                        case 2: {
                            n6 = 43;
                            break;
                        }
                        case 3: {
                            n6 = 111;
                            break;
                        }
                        default: {
                            n6 = 21;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = " vhZ,C\u0005";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ";^]\u000ey\u001bT\u000b\n{\u0011_O\u0006{\u0015\u0010J\u0003r\u001dBB\u001b}\u001f\u0010\u0011O";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ";^]\u000ey\u001bT\u000b*VR@Y\u0006c\u0013DNO~\u0017I";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "1_^\u0003qR^D\u001b5\u0010EB\u0003qRuhOe\u0007RG\u0006vR[N\u0016";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "7s{\u001d|\u0004Q_\n^\u0017I\u000b\u0004p\u000bC\u000b\u000eg\u0017\u0010E\u0000aRTB\u001dp\u0011DG\u00165\u0016UX\ng\u001bQG\u0006o\u0013RG\n";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ";^]\u000ey\u001bT\u000b*VR@Y\u0006c\u0013DNO~\u0017I";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ";^]\u000ey\u001bT\u000b*VR@Y\u0006c\u0013DNO~\u0017I";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "7s\u000b\u000bz\u001fQB\u00015\u0002QY\u000ex\u0017DN\u001dfR]^\u001caRRNOp\u001cSD\u000bp\u0016\u0010B\u00015\u0006XNOt\u001eWD\u001d|\u0006XFO|\u0016UE\u001b|\u0014YN\u001d";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

