/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.password.KeymanPasswordCallback;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

class DatabaseDescriptorFactory$DatabaseDescriptorImpl
implements DatabaseDescriptorFactory$DatabaseDescriptor {
    private FileName fileName;
    private String fileNameString;
    private String password;
    private CallbackHandler passwordCallbackHandler;
    private Constants$DatabaseType type;
    private DatabaseDescriptorFactory$DescriptorType descriptorType;
    private boolean isPasswordProtected = true;

    public boolean equals(Object object) {
        if (object.getClass().equals(this.getClass())) {
            return ((DatabaseDescriptorFactory$DatabaseDescriptorImpl)object).fileName.equals(this.fileName);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.fileName.hashCode() + (this.password == null ? 0 : this.password.hashCode());
    }

    public DatabaseDescriptorFactory$DatabaseDescriptorImpl(String string, String string2, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType) throws KeyManagerException {
        this.fileNameString = string;
        this.fileName = new FileName(string);
        this.password = string2;
        this.passwordCallbackHandler = callbackHandler;
        this.type = constants$DatabaseType;
        this.descriptorType = databaseDescriptorFactory$DescriptorType;
    }

    public DatabaseDescriptorFactory$DatabaseDescriptorImpl(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        this(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString(), databaseDescriptorFactory$DatabaseDescriptor.getPassword(), null, constants$DatabaseType, DatabaseDescriptorFactory$DescriptorType.Source);
    }

    public String getPassword(boolean bl, boolean bl2) throws KeyManagerException, CancelledException {
        if (this.password == null && bl) {
            KeymanPasswordCallback keymanPasswordCallback = new KeymanPasswordCallback(this.type, this.descriptorType, this.fileNameString, bl2);
            try {
                this.passwordCallbackHandler.handle(new Callback[]{keymanPasswordCallback});
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_CALLBACK, (Throwable)unsupportedCallbackException);
            }
            ParameterMap parameterMap = keymanPasswordCallback.getPasswordMap();
            if (parameterMap == null) {
                throw new CancelledException();
            }
            if (((String)parameterMap.get(Constants$Parameter.Password)).length() == 0) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.PASSWORD_CANNOT_BE_NULL);
            }
            this.updateDescriptor(parameterMap);
        }
        return this.password;
    }

    public boolean isPasswordProtected() {
        return this.isPasswordProtected;
    }

    public void setPasswordProtected(boolean bl) {
        this.isPasswordProtected = bl;
    }

    protected void updateDescriptor(ParameterMap parameterMap) {
        this.password = (String)parameterMap.get(Constants$Parameter.Password);
    }

    public String getPassword() {
        return this.password;
    }

    public Constants$DatabaseType getType() {
        return this.type;
    }

    public String getFileNameString() {
        return this.fileNameString;
    }

    public FileName getFileName() {
        return this.fileName;
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        String string = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.Password)) {
            string = commandParameters.getPassword();
        }
        return new DatabaseDescriptorFactory$DatabaseDescriptorImpl(commandParameters.getDatabaseName(), string, callbackHandler, constants$DatabaseType, DatabaseDescriptorFactory$DescriptorType.Source);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getDescriptor(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        return new DatabaseDescriptorFactory$DatabaseDescriptorImpl(databaseDescriptorFactory$DatabaseDescriptor, constants$DatabaseType);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getTargetDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        String string = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.TargetPassword)) {
            string = commandParameters.getTargetPassword();
        }
        return new DatabaseDescriptorFactory$DatabaseDescriptorImpl(commandParameters.getTarget(), string, callbackHandler, constants$DatabaseType, DatabaseDescriptorFactory$DescriptorType.Target);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getSecondaryDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        String string = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.SecondaryDbPassword)) {
            string = commandParameters.getSecondaryDbPassword();
        }
        return new DatabaseDescriptorFactory$DatabaseDescriptorImpl(commandParameters.getSecondaryDb(), string, callbackHandler, commandParameters.getSecondaryDbType(), DatabaseDescriptorFactory$DescriptorType.Secondary);
    }

    public void setFileName(String string) {
        this.fileNameString = string;
        this.fileName = new FileName(string);
    }

    public void setType(Constants$DatabaseType constants$DatabaseType) {
        this.type = constants$DatabaseType;
    }

    public ParameterMap getDatabaseParameters(boolean bl) throws KeyManagerException {
        ParameterMap parameterMap = new ParameterMap();
        if (bl) {
            parameterMap.put(Constants$Parameter.Target, this.getFileNameString());
            parameterMap.put(Constants$Parameter.TargetPassword, this.getPassword());
            parameterMap.put(Constants$Parameter.TargetType, this.getType());
        } else {
            parameterMap.put(Constants$Parameter.DatabaseName, this.getFileNameString());
            parameterMap.put(Constants$Parameter.Password, this.getPassword());
            parameterMap.put(Constants$Parameter.Type, this.getType());
        }
        return parameterMap;
    }

    public String toString() {
        return Messages.getString("Label.Database") + " " + this.fileName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean allowsAction(Constants$CommandType constants$CommandType) {
        switch (constants$CommandType) {
            case ConvertDB: 
            case ChangeDBPassword: {
                return true;
            }
            case StashDBPassword: 
            case DisplayDBPasswordExpiry: {
                return false;
            }
        }
        return true;
    }

    public void setPassword(CommandParameters commandParameters) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.NewPassword)) {
            this.password = commandParameters.getNewPassword();
        }
    }
}

