/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGeneratorFactory$1;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordHashGeneratorFactory;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV3Impl
implements RequestDatabaseHashGenerator {
    private RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV3Impl() {
    }

    public ByteSequence generateHash(RequestDatabase requestDatabase, String string) throws NullPointerException, NoSuchAlgorithmException, IOException {
        if (requestDatabase == null || string == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = requestDatabase.getHeader();
        Sequence sequence = requestDatabase.getRecords();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordHeaderHash().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        ByteSequence byteSequence = ByteSequenceFactory.newByteSequence(string.getBytes("UTF-8"));
        byteSequenceIterator = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            messageDigest.update(byteSequenceIterator.getNextByte());
        }
        ByteSequence byteSequence2 = ByteSequenceFactory.newByteSequence(messageDigest.digest());
        for (RequestRecord requestRecord : sequence) {
            ByteSequence byteSequence3 = RequestRecordHashGeneratorFactory.newRequestRecordHashGenerator().generateHash(requestRecord, string);
            byteSequence2 = ByteSequenceXorFactory.newByteSequenceXor().xor(byteSequence2, byteSequence3);
        }
        return byteSequence2;
    }

    RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV3Impl(RequestDatabaseHashGeneratorFactory$1 requestDatabaseHashGeneratorFactory$1) {
        this();
    }
}

