/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CAKeyUpdAnnContent;
import com.ibm.security.cmp.CRLAnnContent;
import com.ibm.security.cmp.CertConfirmContent;
import com.ibm.security.cmp.CertRepMessage;
import com.ibm.security.cmp.ErrorMsgContent;
import com.ibm.security.cmp.GenMsgContent;
import com.ibm.security.cmp.GenRepContent;
import com.ibm.security.cmp.KeyRecRepContent;
import com.ibm.security.cmp.PKIBodyInterface;
import com.ibm.security.cmp.PKIMessages;
import com.ibm.security.cmp.POPODecKeyChallContent;
import com.ibm.security.cmp.POPODecKeyRespContent;
import com.ibm.security.cmp.RevAnnContent;
import com.ibm.security.cmp.RevRepContent;
import com.ibm.security.cmp.RevReqContentv2;
import com.ibm.security.crmf.CertReqMessages;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public final class PKIBodyv2
extends PKIBodyInterface {
    private int choice;
    private Object body;
    private byte[] encodedBody;
    public static final int MESSAGE_BODY_IR = 0;
    public static final int MESSAGE_BODY_IP = 1;
    public static final int MESSAGE_BODY_CR = 2;
    public static final int MESSAGE_BODY_CP = 3;
    public static final int MESSAGE_BODY_P10CR = 4;
    public static final int MESSAGE_BODY_POPDECC = 5;
    public static final int MESSAGE_BODY_POPDECR = 6;
    public static final int MESSAGE_BODY_KUR = 7;
    public static final int MESSAGE_BODY_KUP = 8;
    public static final int MESSAGE_BODY_KRR = 9;
    public static final int MESSAGE_BODY_KRP = 10;
    public static final int MESSAGE_BODY_RR = 11;
    public static final int MESSAGE_BODY_RP = 12;
    public static final int MESSAGE_BODY_CCR = 13;
    public static final int MESSAGE_BODY_CCP = 14;
    public static final int MESSAGE_BODY_CKUANN = 15;
    public static final int MESSAGE_BODY_CANN = 16;
    public static final int MESSAGE_BODY_RANN = 17;
    public static final int MESSAGE_BODY_CRLANN = 18;
    public static final int MESSAGE_BODY_PKICONF = 19;
    public static final int MESSAGE_BODY_NESTED = 20;
    public static final int MESSAGE_BODY_GENM = 21;
    public static final int MESSAGE_BODY_GENP = 22;
    public static final int MESSAGE_BODY_ERROR = 23;
    public static final int MESSAGE_BODY_CERTCONF = 24;
    public static final byte TAG_IR = 0;
    public static final byte TAG_IP = 1;
    public static final byte TAG_CR = 2;
    public static final byte TAG_CP = 3;
    public static final byte TAG_P10CR = 4;
    public static final byte TAG_POPDECC = 5;
    public static final byte TAG_POPDECR = 6;
    public static final byte TAG_KUR = 7;
    public static final byte TAG_KUP = 8;
    public static final byte TAG_KRR = 9;
    public static final byte TAG_KRP = 10;
    public static final byte TAG_RR = 11;
    public static final byte TAG_RP = 12;
    public static final byte TAG_CCR = 13;
    public static final byte TAG_CCP = 14;
    public static final byte TAG_CKUANN = 15;
    public static final byte TAG_CANN = 16;
    public static final byte TAG_RANN = 17;
    public static final byte TAG_CRLANN = 18;
    public static final byte TAG_PKICONF = 19;
    public static final byte TAG_NESTED = 20;
    public static final byte TAG_GENM = 21;
    public static final byte TAG_GENP = 22;
    public static final byte TAG_ERROR = 23;
    public static final byte TAG_CERTCONF = 24;

    public PKIBodyv2(int n, Object object) {
        super(n, object);
    }

    public PKIBodyv2(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKIBodyv2(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.isContextSpecific((byte)0) && derValue.isConstructed()) {
            DerValue derValue2 = derValue.getData().getDerValue();
            this.body = new CertReqMessages(derValue2.toByteArray());
            this.choice = 0;
            this.encodedBody = derValue2.toByteArray();
        } else if (derValue.isContextSpecific((byte)1) && derValue.isConstructed()) {
            DerValue derValue3 = derValue.getData().getDerValue();
            this.body = new CertRepMessage(derValue3.toByteArray());
            this.choice = 1;
            this.encodedBody = derValue3.toByteArray();
        } else if (derValue.isContextSpecific((byte)2) && derValue.isConstructed()) {
            DerValue derValue4 = derValue.getData().getDerValue();
            this.body = new CertReqMessages(derValue4.toByteArray());
            this.choice = 2;
            this.encodedBody = derValue4.toByteArray();
        } else if (derValue.isContextSpecific((byte)3) && derValue.isConstructed()) {
            DerValue derValue5 = derValue.getData().getDerValue();
            this.body = new CertRepMessage(derValue5.toByteArray());
            this.choice = 3;
            this.encodedBody = derValue5.toByteArray();
        } else if (derValue.isContextSpecific((byte)4) && derValue.isConstructed()) {
            DerValue derValue6 = derValue.getData().getDerValue();
            this.body = new CertificationRequest(derValue6.toByteArray());
            this.choice = 4;
            this.encodedBody = derValue6.toByteArray();
        } else if (derValue.isContextSpecific((byte)5) && derValue.isConstructed()) {
            DerValue derValue7 = derValue.getData().getDerValue();
            this.body = new POPODecKeyChallContent(derValue7.toByteArray());
            this.choice = 5;
            this.encodedBody = derValue7.toByteArray();
        } else if (derValue.isContextSpecific((byte)6) && derValue.isConstructed()) {
            DerValue derValue8 = derValue.getData().getDerValue();
            this.body = new POPODecKeyRespContent(derValue8.toByteArray());
            this.choice = 6;
            this.encodedBody = derValue8.toByteArray();
        } else if (derValue.isContextSpecific((byte)7) && derValue.isConstructed()) {
            DerValue derValue9 = derValue.getData().getDerValue();
            this.body = new CertReqMessages(derValue9.toByteArray());
            this.choice = 7;
            this.encodedBody = derValue9.toByteArray();
        } else if (derValue.isContextSpecific((byte)8) && derValue.isConstructed()) {
            DerValue derValue10 = derValue.getData().getDerValue();
            this.body = new CertRepMessage(derValue10.toByteArray());
            this.choice = 8;
            this.encodedBody = derValue10.toByteArray();
        } else if (derValue.isContextSpecific((byte)9) && derValue.isConstructed()) {
            DerValue derValue11 = derValue.getData().getDerValue();
            this.body = new CertReqMessages(derValue11.toByteArray());
            this.choice = 9;
            this.encodedBody = derValue11.toByteArray();
        } else if (derValue.isContextSpecific((byte)10) && derValue.isConstructed()) {
            DerValue derValue12 = derValue.getData().getDerValue();
            this.body = new KeyRecRepContent(derValue12.toByteArray());
            this.choice = 10;
            this.encodedBody = derValue12.toByteArray();
        } else if (derValue.isContextSpecific((byte)11) && derValue.isConstructed()) {
            DerValue derValue13 = derValue.getData().getDerValue();
            this.body = new RevReqContentv2(derValue13.toByteArray());
            this.choice = 11;
            this.encodedBody = derValue13.toByteArray();
        } else if (derValue.isContextSpecific((byte)12) && derValue.isConstructed()) {
            DerValue derValue14 = derValue.getData().getDerValue();
            this.body = new RevRepContent(derValue14.toByteArray());
            this.choice = 12;
            this.encodedBody = derValue14.toByteArray();
        } else if (derValue.isContextSpecific((byte)13) && derValue.isConstructed()) {
            DerValue derValue15 = derValue.getData().getDerValue();
            this.body = new CertReqMessages(derValue15.toByteArray());
            this.choice = 13;
            this.encodedBody = derValue15.toByteArray();
        } else if (derValue.isContextSpecific((byte)14) && derValue.isConstructed()) {
            DerValue derValue16 = derValue.getData().getDerValue();
            this.body = new CertRepMessage(derValue16.toByteArray());
            this.choice = 14;
            this.encodedBody = derValue16.toByteArray();
        } else if (derValue.isContextSpecific((byte)15) && derValue.isConstructed()) {
            DerValue derValue17 = derValue.getData().getDerValue();
            this.body = new CAKeyUpdAnnContent(derValue17.toByteArray());
            this.choice = 15;
            this.encodedBody = derValue17.toByteArray();
        } else if (derValue.isContextSpecific((byte)16) && derValue.isConstructed()) {
            DerValue derValue18 = derValue.getData().getDerValue();
            try {
                this.body = new X509CertImpl(derValue18.toByteArray());
            }
            catch (CertificateException certificateException) {
                throw new IOException("PKIMessage parsing error, " + certificateException);
            }
            this.choice = 16;
            this.encodedBody = derValue18.toByteArray();
        } else if (derValue.isContextSpecific((byte)17) && derValue.isConstructed()) {
            DerValue derValue19 = derValue.getData().getDerValue();
            this.body = new RevAnnContent(derValue19.toByteArray());
            this.choice = 17;
            this.encodedBody = derValue19.toByteArray();
        } else if (derValue.isContextSpecific((byte)18) && derValue.isConstructed()) {
            DerValue derValue20 = derValue.getData().getDerValue();
            this.body = new CRLAnnContent(derValue20.toByteArray());
            this.choice = 18;
            this.encodedBody = derValue20.toByteArray();
        } else if (derValue.isContextSpecific((byte)19) && derValue.isConstructed()) {
            DerValue derValue21 = derValue.getData().getDerValue();
            this.body = null;
            this.choice = 19;
            this.encodedBody = null;
        } else if (derValue.isContextSpecific((byte)20) && derValue.isConstructed()) {
            DerValue derValue22 = derValue.getData().getDerValue();
            this.body = new PKIMessages(derValue22.toByteArray());
            this.choice = 20;
            this.encodedBody = derValue22.toByteArray();
        } else if (derValue.isContextSpecific((byte)21) && derValue.isConstructed()) {
            DerValue derValue23 = derValue.getData().getDerValue();
            this.body = new GenMsgContent(derValue23.toByteArray());
            this.choice = 21;
            this.encodedBody = derValue23.toByteArray();
        } else if (derValue.isContextSpecific((byte)22) && derValue.isConstructed()) {
            DerValue derValue24 = derValue.getData().getDerValue();
            this.body = new GenRepContent(derValue24.toByteArray());
            this.choice = 22;
            this.encodedBody = derValue24.toByteArray();
        } else if (derValue.isContextSpecific((byte)23) && derValue.isConstructed()) {
            DerValue derValue25 = derValue.getData().getDerValue();
            this.body = new ErrorMsgContent(derValue25.toByteArray());
            this.choice = 23;
            this.encodedBody = derValue25.toByteArray();
        } else if (derValue.isContextSpecific((byte)24) && derValue.isConstructed()) {
            DerValue derValue26 = derValue.getData().getDerValue();
            this.body = new CertConfirmContent(derValue26.toByteArray());
            this.choice = 24;
            this.encodedBody = derValue26.toByteArray();
        } else {
            throw new IOException("PKIBodyv2 parsing error, invalid tag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        block35: {
            derOutputStream = new DerOutputStream();
            try {
                switch (this.choice) {
                    case 0: 
                    case 2: 
                    case 7: 
                    case 9: 
                    case 13: {
                        switch (this.choice) {
                            case 0: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.encodedBody);
                                break block35;
                            }
                            case 2: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.encodedBody);
                                break block35;
                            }
                            case 7: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.encodedBody);
                                break block35;
                            }
                            case 9: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.encodedBody);
                                break block35;
                            }
                            case 13: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)13), this.encodedBody);
                                break block35;
                            }
                            default: {
                                throw new IOException("PKIBodyv2 encoding error, invalid body type");
                            }
                        }
                    }
                    case 1: 
                    case 3: 
                    case 8: 
                    case 14: {
                        switch (this.choice) {
                            case 1: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.encodedBody);
                                break block35;
                            }
                            case 3: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.encodedBody);
                                break block35;
                            }
                            case 8: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.encodedBody);
                                break block35;
                            }
                            case 14: {
                                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)14), this.encodedBody);
                                break block35;
                            }
                            default: {
                                throw new IOException("PKIBodyv2 encoding error, invalid body type");
                            }
                        }
                    }
                    case 4: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.encodedBody);
                        break;
                    }
                    case 5: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.encodedBody);
                        break;
                    }
                    case 6: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.encodedBody);
                        break;
                    }
                    case 10: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.encodedBody);
                        break;
                    }
                    case 11: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)11), this.encodedBody);
                        break;
                    }
                    case 12: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)12), this.encodedBody);
                        break;
                    }
                    case 15: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)15), this.encodedBody);
                        break;
                    }
                    case 16: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)16), this.encodedBody);
                        break;
                    }
                    case 17: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)17), this.encodedBody);
                        break;
                    }
                    case 18: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)18), this.encodedBody);
                        break;
                    }
                    case 19: {
                        DerOutputStream derOutputStream2 = new DerOutputStream();
                        derOutputStream2.putNull();
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)19), derOutputStream2);
                        break;
                    }
                    case 20: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)20), this.encodedBody);
                        break;
                    }
                    case 21: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)21), this.encodedBody);
                        break;
                    }
                    case 22: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)22), this.encodedBody);
                        break;
                    }
                    case 23: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)23), this.encodedBody);
                        break;
                    }
                    case 24: {
                        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)24), this.encodedBody);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("PKIMessage error, invalid body type");
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("PKIMessage error, invalid body object");
            }
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(PKIBodyv2 pKIBodyv2) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIBodyv2 == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIBodyv2.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIBodyv2) {
            return this.equals((PKIBodyv2)object);
        }
        return false;
    }

    public Object getBody() {
        switch (this.choice) {
            case 0: 
            case 2: 
            case 7: 
            case 9: 
            case 13: {
                return (CertReqMessages)((CertReqMessages)this.body).clone();
            }
            case 1: 
            case 3: 
            case 8: 
            case 14: {
                return (CertRepMessage)((CertRepMessage)this.body).clone();
            }
            case 4: {
                return (CertificationRequest)((CertificationRequest)this.body).clone();
            }
            case 5: {
                return (POPODecKeyChallContent)((POPODecKeyChallContent)this.body).clone();
            }
            case 6: {
                return (POPODecKeyRespContent)((POPODecKeyRespContent)this.body).clone();
            }
            case 10: {
                return (KeyRecRepContent)((KeyRecRepContent)this.body).clone();
            }
            case 11: {
                return (RevReqContentv2)((RevReqContentv2)this.body).clone();
            }
            case 12: {
                return (RevRepContent)((RevRepContent)this.body).clone();
            }
            case 15: {
                return (CAKeyUpdAnnContent)((CAKeyUpdAnnContent)this.body).clone();
            }
            case 16: {
                try {
                    byte[] byArray = ((X509CertImpl)this.body).getEncoded();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    return certificateFactory.generateCertificate(byteArrayInputStream);
                }
                catch (CertificateException certificateException) {
                    return null;
                }
            }
            case 17: {
                return (RevAnnContent)((RevAnnContent)this.body).clone();
            }
            case 18: {
                return ((CRLAnnContent)this.body).clone();
            }
            case 19: {
                return null;
            }
            case 20: {
                return ((PKIMessages)this.body).clone();
            }
            case 21: {
                return (GenMsgContent)((GenMsgContent)this.body).clone();
            }
            case 22: {
                return (GenRepContent)((GenRepContent)this.body).clone();
            }
            case 23: {
                return (ErrorMsgContent)((ErrorMsgContent)this.body).clone();
            }
            case 24: {
                return (CertConfirmContent)((CertConfirmContent)this.body).clone();
            }
        }
        return null;
    }

    public int getBodyType() {
        return this.choice;
    }

    public byte[] getEncodedBody() {
        if (this.choice == 19) {
            return null;
        }
        return (byte[])this.encodedBody.clone();
    }

    void setBody(int n, Object object) {
        if (n < 0 || n > 24) {
            throw new IllegalArgumentException("PKIMessage error, invalid body type");
        }
        if (n != 19 && object == null) {
            throw new IllegalArgumentException("PKIMessage error, body not specified");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            switch (n) {
                case 0: 
                case 2: 
                case 7: 
                case 9: 
                case 13: {
                    if (object instanceof CertReqMessages) {
                        ((CertReqMessages)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 1: 
                case 3: 
                case 8: 
                case 14: {
                    if (object instanceof CertRepMessage) {
                        ((CertRepMessage)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 4: {
                    if (object instanceof CertificationRequest) {
                        ((CertificationRequest)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 5: {
                    if (object instanceof POPODecKeyChallContent) {
                        ((POPODecKeyChallContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException();
                }
                case 6: {
                    if (object instanceof POPODecKeyRespContent) {
                        ((POPODecKeyRespContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 10: {
                    if (object instanceof KeyRecRepContent) {
                        ((KeyRecRepContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 11: {
                    if (object instanceof RevReqContentv2) {
                        ((RevReqContentv2)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 12: {
                    if (object instanceof RevRepContent) {
                        ((RevRepContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 15: {
                    if (object instanceof CAKeyUpdAnnContent) {
                        ((CAKeyUpdAnnContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 16: {
                    if (object instanceof X509CertImpl) {
                        try {
                            ((X509CertImpl)object).encode((OutputStream)derOutputStream);
                        }
                        catch (CertificateException certificateException) {
                            throw new IllegalArgumentException("PKIMessage error, invalid body object");
                        }
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 17: {
                    if (object instanceof RevAnnContent) {
                        ((RevAnnContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 18: {
                    if (object instanceof CRLAnnContent) {
                        ((CRLAnnContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 19: {
                    this.encodedBody = null;
                    break;
                }
                case 20: {
                    if (object instanceof PKIMessages) {
                        ((PKIMessages)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 21: {
                    if (object instanceof GenMsgContent) {
                        ((GenMsgContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 22: {
                    if (object instanceof GenRepContent) {
                        ((GenRepContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 23: {
                    if (object instanceof ErrorMsgContent) {
                        ((ErrorMsgContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                case 24: {
                    if (object instanceof CertConfirmContent) {
                        ((CertConfirmContent)object).encode((OutputStream)derOutputStream);
                        this.encodedBody = derOutputStream.toByteArray();
                        break;
                    }
                    throw new IOException("PKIBodyv2 error, invalid body object");
                }
                default: {
                    throw new IllegalArgumentException("PKIMessage error, invalid body type: " + n + " " + 24);
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("PKIMessage error, invalid body object");
        }
        this.choice = n;
        this.body = object;
    }

    public String toString() {
        String string = "PKIBodyv2:\r\n";
        switch (this.choice) {
            case 0: {
                string = String.valueOf(string) + "\r\n\t Initialization Request: " + ((CertReqMessages)this.body).toString();
                break;
            }
            case 1: {
                string = String.valueOf(string) + "\r\n\t Initialization Response: " + ((CertRepMessage)this.body).toString();
                break;
            }
            case 2: {
                string = String.valueOf(string) + "\r\n\t Certification Request: " + ((CertReqMessages)this.body).toString();
                break;
            }
            case 3: {
                string = String.valueOf(string) + "\r\n\t Certification Response: " + ((CertRepMessage)this.body).toString();
                break;
            }
            case 4: {
                string = String.valueOf(string) + "\r\n\t PKCS#10 Certification Request: " + ((CertificationRequest)this.body).toString();
                break;
            }
            case 5: {
                string = String.valueOf(string) + "\r\n\t Pop Challenge: " + ((POPODecKeyChallContent)this.body).toString();
                break;
            }
            case 6: {
                string = String.valueOf(string) + "\r\n\t Pop Response: " + ((POPODecKeyRespContent)this.body).toString();
                break;
            }
            case 7: {
                string = String.valueOf(string) + "\r\n\t Key Update Request: " + ((CertReqMessages)this.body).toString();
                break;
            }
            case 8: {
                string = String.valueOf(string) + "\r\n\t Key Update Response: " + ((CertRepMessage)this.body).toString();
                break;
            }
            case 9: {
                string = String.valueOf(string) + "\r\n\t Key Recovery Request: " + ((CertReqMessages)this.body).toString();
                break;
            }
            case 10: {
                string = String.valueOf(string) + "\r\n\t Key Recovery Response: " + ((KeyRecRepContent)this.body).toString();
                break;
            }
            case 11: {
                string = String.valueOf(string) + "\r\n\t Revocation Request: " + ((RevReqContentv2)this.body).toString();
                break;
            }
            case 12: {
                string = String.valueOf(string) + "\r\n\t Revocation Response: " + ((RevRepContent)this.body).toString();
                break;
            }
            case 13: {
                string = String.valueOf(string) + "\r\n\t Cross-cert Request: " + ((CertReqMessages)this.body).toString();
                break;
            }
            case 14: {
                string = String.valueOf(string) + "\r\n\t Cross-cert Response: " + ((CertRepMessage)this.body).toString();
                break;
            }
            case 15: {
                string = String.valueOf(string) + "\r\n\t CA Key Update Ann: " + ((CAKeyUpdAnnContent)this.body).toString();
                break;
            }
            case 16: {
                string = String.valueOf(string) + "\r\n\t Certificate Ann: " + ((X509CertImpl)this.body).toString();
                break;
            }
            case 17: {
                string = String.valueOf(string) + "\r\n\t Revocation Ann: " + ((RevAnnContent)this.body).toString();
                break;
            }
            case 18: {
                string = String.valueOf(string) + "\r\n\t CRL Announcement: " + ((CRLAnnContent)this.body).toString();
                break;
            }
            case 19: {
                string = String.valueOf(string) + "\r\n\t Confirmation ";
                break;
            }
            case 20: {
                string = String.valueOf(string) + "\r\n\t Nested Message: " + ((PKIMessages)this.body).toString();
                break;
            }
            case 21: {
                string = String.valueOf(string) + "\r\n\t General Message: " + ((GenMsgContent)this.body).toString();
                break;
            }
            case 22: {
                string = String.valueOf(string) + "\r\n\t General Response: " + ((GenRepContent)this.body).toString();
                break;
            }
            case 23: {
                string = String.valueOf(string) + "\r\n\t Error Message: " + ((ErrorMsgContent)this.body).toString();
                break;
            }
            case 24: {
                string = String.valueOf(string) + "\r\n\t Cert Confirm Content: " + ((CertConfirmContent)this.body).toString();
                break;
            }
        }
        return string;
    }
}

