/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.gsskerb;

import com.ibm.security.sasl.gsskerb.GssKrb5Base;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;

final class GssKrb5Client
extends GssKrb5Base
implements SaslClient {
    private static final String MY_CLASS_NAME = GssKrb5Client.class.getName();
    private boolean finalHandshake = false;
    private boolean mutual = false;
    private byte[] authzID;

    GssKrb5Client(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        super(map, MY_CLASS_NAME);
        String string4 = string2 + "@" + string3;
        logger.log(Level.FINE, "KRB5CLNT01:Requesting service name: {0}", string4);
        try {
            Object object;
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(string4, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSCredential gSSCredential = null;
            if (map != null && (object = map.get("javax.security.sasl.credentials")) != null && object instanceof GSSCredential) {
                gSSCredential = (GSSCredential)object;
                logger.log(Level.FINE, "KRB5CLNT01:Using the credentials supplied in javax.security.sasl.credentials");
            }
            this.secCtx = gSSManager.createContext(gSSName, KRB5_OID, gSSCredential, Integer.MAX_VALUE);
            if (gSSCredential != null) {
                this.secCtx.requestCredDeleg(true);
            }
            if (map != null && (object = (String)map.get("javax.security.sasl.server.authentication")) != null) {
                this.mutual = "true".equalsIgnoreCase((String)object);
            }
            this.secCtx.requestMutualAuth(this.mutual);
            this.secCtx.requestConf(true);
            this.secCtx.requestInteg(true);
        }
        catch (GSSException gSSException) {
            throw new SaslException("Failure to initialize security context", gSSException);
        }
        if (string != null && string.length() > 0) {
            try {
                this.authzID = string.getBytes("UTF8");
            }
            catch (IOException iOException) {
                throw new SaslException("Cannot encode authorization ID", iOException);
            }
        }
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("GSSAPI authentication already complete");
        }
        if (this.finalHandshake) {
            return this.doFinalHandshake(byArray);
        }
        try {
            byte[] byArray2 = this.secCtx.initSecContext(byArray, 0, byArray.length);
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "evaluteChallenge", "KRB5CLNT02:Challenge: [raw]", byArray);
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "evaluateChallenge", "KRB5CLNT03:Response: [after initSecCtx]", byArray2);
            }
            if (this.secCtx.isEstablished()) {
                this.finalHandshake = true;
                if (byArray2 == null) {
                    return EMPTY;
                }
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("GSS initiate failed", gSSException);
        }
    }

    private byte[] doFinalHandshake(byte[] byArray) throws SaslException {
        try {
            byte by;
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT04:Challenge [raw]:", byArray);
            }
            if (byArray.length == 0) {
                return EMPTY;
            }
            MessageProp messageProp = new MessageProp(false);
            byte[] byArray2 = this.secCtx.unwrap(byArray, 0, byArray.length, messageProp);
            this.checkMessageProp("Handshake failure: ", messageProp);
            if (logger.isLoggable(Level.FINE)) {
                if (logger.isLoggable(Level.FINER)) {
                    GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT05:Challenge [unwrapped]:", byArray2);
                }
                logger.log(Level.FINE, "KRB5CLNT06:Server protections: {0}", new Byte(byArray2[0]));
            }
            if ((by = GssKrb5Client.findPreferredMask(byArray2[0], this.qop)) == 0) {
                throw new SaslException("No common protection layer between client and server");
            }
            if ((by & 4) != 0) {
                this.privacy = true;
                this.integrity = true;
            } else if ((by & 2) != 0) {
                this.integrity = true;
            }
            int n = GssKrb5Client.networkByteOrderToInt(byArray2, 1, 3);
            this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n : Math.min(this.sendMaxBufSize, n);
            this.rawSendSize = this.secCtx.getWrapSizeLimit(0, this.privacy, this.sendMaxBufSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5CLNT07:Client max recv size: {0}; server max recv size: {1}; rawSendSize: {2}", new Object[]{new Integer(this.recvMaxBufSize), new Integer(n), new Integer(this.rawSendSize)});
            }
            int n2 = 4;
            if (this.authzID != null) {
                n2 += this.authzID.length;
            }
            byte[] byArray3 = new byte[n2];
            byArray3[0] = by;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5CLNT08:Selected protection: {0}; privacy: {1}; integrity: {2}", new Object[]{new Byte(by), this.privacy, this.integrity});
            }
            GssKrb5Client.intToNetworkByteOrder(this.recvMaxBufSize, byArray3, 1, 3);
            if (this.authzID != null) {
                System.arraycopy(this.authzID, 0, byArray3, 4, this.authzID.length);
                logger.log(Level.FINE, "KRB5CLNT09:Authzid: {0}", (Object)this.authzID);
            }
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT10:Response [raw]", byArray3);
            }
            byArray2 = this.secCtx.wrap(byArray3, 0, byArray3.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT11:Response [after wrap]", byArray2);
            }
            this.completed = true;
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Final handshake failed", gSSException);
        }
    }
}

