/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.IStringModifier;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TokensTool
extends Tool
implements IPipe {
    private static final String COMMAND = "tokens";
    private static final String RANGE_INDICATOR = "..";
    private static final String OPTION_KEEP = "-keep";
    private static final String ARGUMENT_DESCRIPTION = "[-keep] <range>[,<range>...]";
    private static final String HELP_DESCRIPTION = "To be used after a pipeline to pick up tokens in a line.";
    private static final String USAGE = "tokens\t[-keep] <range>[,<range>...]\tTo be used after a pipeline to pick up tokens in a line.\n     A range can be defined in the following formats:\n          X\n          X..Y\n     In the latter format, if X is missing, it is assumed to be 1 (representing the first token).\n     If Y is missing, it is assumed to be -1 (representing the last token).\n     X or Y can be preceded by a minus sign (-), which implies counting from the right.\n     X has to represent a position (that can be) the same or to the left of what Y represents.\n     \n     A range is present if it includes at least one token.\n     The output consists of the selected tokens, in the order specified; a single space separates output tokens.\n     If all the ranges are missing from the line, the line is suppressed unless the -keep option is used.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String command, String[] args, PrintStream out) throws CommandException {
        Arguments arguments = TokensTool.processArguments(args, out);
        if (arguments == null) {
            out.println(USAGE);
            return;
        }
        try (PrintStream newOut = null;){
            newOut = new PrintStream(new OutputStreamModifier(out, new StringModifier(arguments)));
            ToolsRegistry.process(arguments.nextCommand, arguments.nextCommandArgs, newOut);
        }
    }

    @Override
    public boolean accept(String command, String[] args) {
        return COMMAND.equalsIgnoreCase(command);
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private static Arguments processArguments(String[] args, PrintStream out) {
        if (args.length < 2) {
            return null;
        }
        int currentIndex = 0;
        boolean keep = false;
        ArrayList<Range> rangeList = new ArrayList<Range>();
        if (args[currentIndex].equalsIgnoreCase(OPTION_KEEP)) {
            keep = true;
            ++currentIndex;
        }
        StringTokenizer st = new StringTokenizer(args[currentIndex], ",");
        while (st.hasMoreTokens()) {
            Range range = TokensTool.parseRange(st.nextToken(), out);
            if (range == null) {
                return null;
            }
            rangeList.add(range);
        }
        if (args[++currentIndex].equalsIgnoreCase(OPTION_KEEP)) {
            keep = true;
            ++currentIndex;
        }
        String ddrCommand = args[currentIndex];
        int startIndexForNextCommand = currentIndex + 1;
        String[] ddrCommandArgs = new String[args.length - startIndexForNextCommand];
        for (int i = 0; i < ddrCommandArgs.length; ++i) {
            ddrCommandArgs[i] = args[i + startIndexForNextCommand];
        }
        return new Arguments(keep, rangeList, ddrCommand, ddrCommandArgs);
    }

    private static Range parseRange(String range, PrintStream out) {
        int start = 1;
        int end = -1;
        int index = range.indexOf(RANGE_INDICATOR);
        try {
            if (index < 0) {
                end = start = Integer.parseInt(range);
            } else {
                String y;
                String x = range.substring(0, index);
                if (x.length() > 0) {
                    start = Integer.parseInt(x);
                }
                if ((y = range.substring(index + RANGE_INDICATOR.length())).length() > 0) {
                    end = Integer.parseInt(y);
                }
            }
        }
        catch (NumberFormatException e) {
            out.println("Range must be numeric : " + range);
            return null;
        }
        if (start == 0 || end == 0 || start * end > 0 && start > end) {
            out.println("Invalid range : " + range);
            return null;
        }
        return new Range(start, end);
    }

    private static final class Arguments {
        public final String nextCommand;
        public final String[] nextCommandArgs;
        public final boolean keep;
        public final List<Range> rangeList;

        public Arguments(boolean keep, List<Range> rangeList, String nextCommand, String[] nextCommandArgs) {
            this.keep = keep;
            this.rangeList = rangeList;
            this.nextCommand = nextCommand;
            this.nextCommandArgs = nextCommandArgs;
        }
    }

    private static final class Range {
        final int start;
        final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStartIndex(int tokenSize) {
            return Math.max(0, this.start < 0 ? tokenSize + this.start : this.start - 1);
        }

        public int getEndIndex(int tokenSize) {
            return Math.min(tokenSize - 1, this.end < 0 ? tokenSize + this.end : this.end - 1);
        }
    }

    private static final class StringModifier
    implements IStringModifier {
        private final Arguments arguments;

        public StringModifier(Arguments arguments) {
            this.arguments = arguments;
        }

        @Override
        public String modify(String s) {
            StringBuilder sb = null;
            List<String> tokenList = StringModifier.tokenize(s);
            int tokenSize = tokenList.size();
            for (Range range : this.arguments.rangeList) {
                int endIndex = range.getEndIndex(tokenSize);
                for (int index = range.getStartIndex(tokenSize); index <= endIndex; ++index) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append(" ");
                    }
                    sb.append(tokenList.get(index));
                }
            }
            if (sb == null || sb.length() == 0) {
                if (this.arguments.keep) {
                    return s.endsWith("\n") ? s : s + "\n";
                }
                return "";
            }
            return sb.toString() + "\n";
        }

        private static List<String> tokenize(String s) {
            ArrayList<String> tokenList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                tokenList.add(st.nextToken());
            }
            return tokenList;
        }
    }
}

