/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.portable.LongObjectRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.MediumObjectRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpClassCache;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.ShortObjectRecord;

public abstract class ObjectRecord
extends PortableHeapDumpRecord {
    protected final int _hashCode;
    protected final long _classAddress;
    protected final boolean _is32BitHash;

    protected ObjectRecord(long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references, boolean is32BitHash) {
        super(address, previousAddress, references);
        this._hashCode = hashCode;
        this._classAddress = classAddress;
        this._is32BitHash = is32BitHash;
    }

    protected static boolean isShortObjectEligible(long current, long previous) {
        long addressDifference = PortableHeapDumpRecord.getAddressDifference(current, previous);
        return addressDifference < 32767L && addressDifference > -32768L;
    }

    public static ObjectRecord getObjectRecord(long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references, PortableHeapDumpClassCache cache, boolean is64Bit, boolean is32BitHash) {
        byte classCacheIndex = cache.getClassCacheIndex(classAddress);
        if (classCacheIndex == -1 || previousAddress == 0L) {
            cache.setClassCacheIndex(classAddress);
            return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
        }
        if (is32BitHash && hashCode != 0) {
            cache.setClassCacheIndex(classAddress);
            return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
        }
        if (ObjectRecord.isShortObjectEligible(address, previousAddress)) {
            int numberOfReferences = ObjectRecord.countReferences(references);
            if (numberOfReferences <= 3) {
                return new ShortObjectRecord(address, previousAddress, classAddress, hashCode, references, classCacheIndex, is32BitHash);
            }
            if (numberOfReferences < 8) {
                cache.setClassCacheIndex(classAddress);
                return new MediumObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
            }
            cache.setClassCacheIndex(classAddress);
            return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
        }
        cache.setClassCacheIndex(classAddress);
        return new LongObjectRecord(address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
    }

    private static int countReferences(ReferenceIterator references) {
        int count = 0;
        references.reset();
        while (references.hasNext()) {
            references.next();
            ++count;
        }
        return count;
    }
}

