/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoJitmCommand
extends BaseJdmpviewCommand {
    public InfoJitmCommand() {
        this.addCommand("info jitm", "", "Displays JIT'ed methods and their addresses");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"info jitm\" command does not take any parameters");
            return;
        }
        this.showJITdMethods();
    }

    private void showJITdMethods() {
        JavaRuntime jr = this.ctx.getRuntime();
        Iterator itJavaClassLoader = jr.getJavaClassLoaders();
        while (itJavaClassLoader.hasNext()) {
            JavaClassLoader jcl = (JavaClassLoader)itJavaClassLoader.next();
            Iterator itJavaClass = jcl.getDefinedClasses();
            while (itJavaClass.hasNext()) {
                String jcName;
                JavaClass jc = (JavaClass)itJavaClass.next();
                Iterator itJavaMethod = jc.getDeclaredMethods();
                try {
                    jcName = jc.getName();
                }
                catch (CorruptDataException e) {
                    jcName = Exceptions.getCorruptDataExceptionString();
                }
                while (itJavaMethod.hasNext()) {
                    String sig;
                    String name;
                    JavaMethod jm = (JavaMethod)itJavaMethod.next();
                    try {
                        name = jm.getName();
                    }
                    catch (CorruptDataException e) {
                        name = Exceptions.getCorruptDataExceptionString();
                    }
                    try {
                        sig = jm.getSignature();
                    }
                    catch (CorruptDataException e) {
                        sig = Exceptions.getCorruptDataExceptionString();
                    }
                    if (!jm.getCompiledSections().hasNext()) continue;
                    Iterator itImageSection = jm.getCompiledSections();
                    while (itImageSection.hasNext()) {
                        ImageSection is = (ImageSection)itImageSection.next();
                        long startAddr = is.getBaseAddress().getAddress();
                        long size = is.getSize();
                        long endAddr = startAddr + size;
                        this.out.print("\n\tstart=" + Utils.toHex(startAddr) + "  end=" + Utils.toHex(endAddr) + "   " + jcName + "::" + name + sig);
                    }
                }
            }
        }
        this.out.print("\n");
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("displays JIT'ed methods and their addresses\n\nparameters: none\n\nprints the following information about each JIT'ed method\n\n  - method name and signature\n  - method start address\n  - method end address\n");
    }
}

