/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.Iterator;
import java.util.LinkedList;

public class JUCMonitorNode
extends MonitorNode {
    private JavaObject lock;
    private JavaRuntime jr;

    public JUCMonitorNode(JavaObject jucLock, JavaRuntime rt) {
        this.lock = jucLock;
        this.jr = rt;
    }

    @Override
    public Iterator getEnterWaiters() {
        LinkedList<JavaThread> waiters = new LinkedList<JavaThread>();
        Iterator itThread = this.jr.getThreads();
        while (itThread.hasNext()) {
            Object o = itThread.next();
            try {
                JavaObject blocker;
                JavaThread jt;
                if (!(o instanceof JavaThread) || ((jt = (JavaThread)o).getState() & 0x200) == 0 || (blocker = jt.getBlockingObject()) == null || !blocker.equals((Object)this.lock)) continue;
                waiters.add(jt);
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {}
        }
        return waiters.iterator();
    }

    @Override
    public JavaThread getOwner() throws CorruptDataException, MemoryAccessException {
        return Utils.getParkBlockerOwner(this.lock, this.jr);
    }

    @Override
    public JavaObject getObject() {
        return this.lock;
    }

    @Override
    public String getType() {
        try {
            return this.lock.getJavaClass().getName();
        }
        catch (CorruptDataException e) {
            return "<unknown>";
        }
    }
}

