/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java2d.Java2Demo;
import java2d.RunWindow;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class Java2DemoApplet
extends JApplet {
    private Java2Demo demo;

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JPanel jPanel = new JPanel();
                    Java2DemoApplet.this.getContentPane().add((Component)jPanel, "Center");
                    jPanel.setLayout(new BoxLayout(jPanel, 0));
                    JPanel jPanel2 = new JPanel(){

                        @Override
                        public Insets getInsets() {
                            return new Insets(40, 30, 20, 30);
                        }
                    };
                    jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                    jPanel.add(Box.createGlue());
                    jPanel.add(jPanel2);
                    jPanel.add(Box.createGlue());
                    jPanel2.add(Box.createGlue());
                    Dimension dimension = new Dimension(400, 20);
                    JLabel jLabel = new JLabel("Loading, please wait...");
                    jLabel.setMaximumSize(dimension);
                    jPanel2.add(jLabel);
                    jPanel2.add(Box.createRigidArea(new Dimension(1, 20)));
                    JProgressBar jProgressBar = new JProgressBar();
                    jProgressBar.setStringPainted(true);
                    jLabel.setLabelFor(jProgressBar);
                    jProgressBar.setAlignmentX(0.5f);
                    jProgressBar.setMaximumSize(dimension);
                    jProgressBar.setMinimum(0);
                    jProgressBar.setValue(0);
                    jPanel2.add(jProgressBar);
                    jPanel2.add(Box.createGlue());
                    jPanel2.add(Box.createGlue());
                    Java2Demo.DemoProgress demoProgress = new Java2Demo.DemoProgress(jLabel, jProgressBar);
                    Rectangle rectangle = Java2DemoApplet.this.getContentPane().getBounds();
                    jPanel.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
                    Java2DemoApplet.this.getContentPane().add((Component)jPanel, "Center");
                    Java2DemoApplet.this.validate();
                    Java2DemoApplet.this.setVisible(true);
                    RunWindow.RunWindowSettings runWindowSettings = new RunWindow.RunWindowSettings();
                    Java2DemoApplet.this.demo = new Java2Demo(true, demoProgress, runWindowSettings);
                    Java2DemoApplet.this.getContentPane().remove(jPanel);
                    Java2DemoApplet.this.getContentPane().setLayout(new BorderLayout());
                    Java2DemoApplet.this.getContentPane().add((Component)Java2DemoApplet.this.demo, "Center");
                    String string = null;
                    string = Java2DemoApplet.this.getParameter("delay");
                    if (string != null) {
                        runWindowSettings.setDelay(Integer.parseInt(string));
                    }
                    if (Java2DemoApplet.this.getParameter("ccthread") != null) {
                        Java2DemoApplet.this.demo.getCcthreadCB().setSelected(true);
                    }
                    if ((string = Java2DemoApplet.this.getParameter("screen")) != null) {
                        ((Java2DemoApplet)Java2DemoApplet.this).demo.getControls().screenCombo.setSelectedIndex(Integer.parseInt(string));
                    }
                    if ((string = Java2DemoApplet.this.getParameter("antialias")) != null) {
                        ((Java2DemoApplet)Java2DemoApplet.this).demo.getControls().aliasCB.setSelected(string.endsWith("true"));
                    }
                    if ((string = Java2DemoApplet.this.getParameter("rendering")) != null) {
                        ((Java2DemoApplet)Java2DemoApplet.this).demo.getControls().renderCB.setSelected(string.endsWith("true"));
                    }
                    if ((string = Java2DemoApplet.this.getParameter("texture")) != null) {
                        ((Java2DemoApplet)Java2DemoApplet.this).demo.getControls().textureCB.setSelected(string.endsWith("true"));
                    }
                    if ((string = Java2DemoApplet.this.getParameter("composite")) != null) {
                        ((Java2DemoApplet)Java2DemoApplet.this).demo.getControls().compositeCB.setSelected(string.endsWith("true"));
                    }
                    if (Java2DemoApplet.this.getParameter("verbose") != null) {
                        Java2DemoApplet.this.demo.getVerboseCB().setSelected(true);
                    }
                    if ((string = Java2DemoApplet.this.getParameter("columns")) != null) {
                        Java2DemoApplet.this.demo.setGroupColumns(Integer.parseInt(string));
                    }
                    if ((string = Java2DemoApplet.this.getParameter("buffers")) != null) {
                        runWindowSettings.setBuffersFlag(true);
                        int n = string.indexOf(44);
                        String string2 = string.substring(0, n);
                        runWindowSettings.setBufBeg(Integer.parseInt(string2));
                        string2 = string.substring(n + 1, string.length());
                        runWindowSettings.setBufEnd(Integer.parseInt(string2));
                    }
                    if (Java2DemoApplet.this.getParameter("zoom") != null) {
                        runWindowSettings.setZoomCBSelected(true);
                    }
                    if ((string = Java2DemoApplet.this.getParameter("runs")) != null) {
                        runWindowSettings.setNumRuns(Integer.parseInt(string));
                        Java2DemoApplet.this.demo.createRunWindow();
                        Java2DemoApplet.this.demo.startRunWindow();
                    }
                    Java2DemoApplet.this.validate();
                    Java2DemoApplet.this.repaint();
                    Java2DemoApplet.this.requestDefaultFocus();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void requestDefaultFocus() {
        Container container = this.getFocusCycleRootAncestor();
        if (container != null) {
            container.getFocusTraversalPolicy().getDefaultComponent(container).requestFocus();
        }
    }

    @Override
    public void start() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Java2DemoApplet.this.demo != null) {
                        Java2DemoApplet.this.demo.start();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Java2DemoApplet.this.demo != null) {
                        Java2DemoApplet.this.demo.stop();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Java2DemoApplet.this.getContentPane().removeAll();
                    Java2DemoApplet.this.validate();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

