/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;

class SignaturePropertiesImpl
extends XMLStructureImpl
implements SignatureProperties {
    List content;
    private String id;

    SignaturePropertiesImpl(AlgorithmFactory f, List content, String id) {
        super(f);
        if (content.size() == 0) {
            throw new IllegalArgumentException("No content");
        }
        this.content = new ArrayList(content.size());
        for (SignatureProperty obj : content) {
            this.content.add(obj);
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getProperties() {
        return Collections.unmodifiableList(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperties)) {
            return false;
        }
        SignatureProperties osp = (SignatureProperties)o;
        boolean propertiesEqual = this.content.equals(osp.getProperties());
        boolean idsEqual = this.id == null ? osp.getId() == null : this.id.equals(osp.getId());
        return propertiesEqual && idsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

